/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvview.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.table.AbstractTableModel;
import net.sf.cuf.csvview.util.FilteredTableModel;

public class CSVTableModel
extends AbstractTableModel
implements FilteredTableModel {
    private int mRows;
    private int mColumns;
    private String[][] mData;
    private int mFilteredRows;
    private int[] mFilteredRowsIndexMapper;
    private String[] mRowHeaders;
    private String mLastFilter;
    private boolean mFirstRowIsHeader;
    private String mCSVSeparator;
    private static final String CSV_SEPARATOR = ",";
    private static final String EMPTY = "";
    private static final String[] DUMMY = new String[0];
    private static final Pattern CSV_QUOTE_PATTERN = Pattern.compile("\"\"");

    public CSVTableModel() {
        this.init();
    }

    public CSVTableModel(InputStream pCSVData, boolean pFirstRowIsHeader, String pCSVSeparator, String pEncoding) throws IOException {
        if (pCSVData == null) {
            this.init();
        } else {
            this.init(new InputStreamReader(pCSVData, pEncoding), pFirstRowIsHeader, pCSVSeparator);
        }
    }

    public CSVTableModel(Reader pCSVData, boolean pFirstRowIsHeader, String pCSVSeparator) throws IOException {
        if (pCSVData == null) {
            this.init();
        } else {
            this.init(pCSVData, pFirstRowIsHeader, pCSVSeparator);
        }
    }

    private void init() {
        this.mRows = 0;
        this.mColumns = 0;
        this.mData = new String[this.mRows][this.mColumns];
        this.mFilteredRows = 0;
        this.mFilteredRowsIndexMapper = new int[this.mRows];
        this.mRowHeaders = new String[this.mColumns];
        this.mLastFilter = null;
        this.mFirstRowIsHeader = false;
        this.mCSVSeparator = CSV_SEPARATOR;
    }

    private void init(Reader pCSVData, boolean pFirstRowIsHeader, String pCSVSeparator) throws IOException {
        int i;
        if (pCSVData == null) {
            this.init();
            return;
        }
        this.mCSVSeparator = pCSVSeparator == null ? CSV_SEPARATOR : pCSVSeparator;
        LineNumberReader reader = new LineNumberReader(pCSVData);
        ArrayList<String[]> data = new ArrayList<String[]>();
        ArrayList<String> row = new ArrayList<String>();
        String csvMainString = "  \\G(?:^|" + this.mCSVSeparator + ")\n" + "  (?:\n" + "     # Either a double-quoted field...\n" + "     \" # field's opening quote\n" + "      (  (?> [^\"]*+ ) (?> \"\" [^\"]*+ )*+  )\n" + "     \" # field's closing quote\n" + "   # ... or ...\n" + "   |\n" + "     # ... some non-quote/non-comma text ...\n" + "     ( [^\"" + this.mCSVSeparator + "]*+ )\n" + "  )\n";
        Pattern csvMainPattern = Pattern.compile(csvMainString, 4);
        Matcher csvQuote = CSV_QUOTE_PATTERN.matcher(EMPTY);
        Matcher csvMain = csvMainPattern.matcher(EMPTY);
        String line = reader.readLine();
        while (line != null) {
            row.clear();
            csvMain.reset(line);
            while (csvMain.find()) {
                String field;
                String first = csvMain.group(2);
                if (first != null) {
                    field = first;
                } else {
                    csvQuote.reset(csvMain.group(1));
                    field = csvQuote.replaceAll("\"");
                }
                if (EMPTY.equals(field)) {
                    field = EMPTY;
                }
                row.add(field);
            }
            data.add(row.toArray(new String[row.size()]));
            this.mColumns = Math.max(this.mColumns, row.size());
            ++this.mRows;
            line = reader.readLine();
        }
        if (pFirstRowIsHeader && this.mRows > 1) {
            this.mFirstRowIsHeader = true;
            --this.mRows;
            this.mRowHeaders = (String[])data.remove(0);
        } else {
            this.mRowHeaders = DUMMY;
            this.mFirstRowIsHeader = false;
        }
        this.mData = new String[this.mRows][0];
        for (i = 0; i < this.mRows; ++i) {
            String[] rowContent = (String[])data.get(i);
            this.mData[i] = rowContent;
        }
        this.mFilteredRows = this.mRows;
        this.mFilteredRowsIndexMapper = new int[this.mRows];
        for (i = 0; i < this.mRows; ++i) {
            this.mFilteredRowsIndexMapper[i] = i;
        }
        this.mLastFilter = null;
    }

    @Override
    public int getRowCount() {
        return this.mFilteredRows;
    }

    @Override
    public int getAllRowsCount() {
        return this.mRows;
    }

    @Override
    public int getColumnCount() {
        return this.mColumns;
    }

    @Override
    public Object getValueAt(int pRowIndex, int pColumnIndex) {
        int realIndex = this.mFilteredRowsIndexMapper[pRowIndex];
        String[] row = this.mData[realIndex];
        if (row.length > pColumnIndex) {
            return row[pColumnIndex];
        }
        return EMPTY;
    }

    @Override
    public String getColumnName(int pColumnIndex) {
        if (this.mRowHeaders.length > pColumnIndex) {
            return this.mRowHeaders[pColumnIndex];
        }
        return Integer.toString(pColumnIndex);
    }

    @Override
    public boolean filter(String pFilterExpression) {
        Pattern filter;
        try {
            filter = Pattern.compile(pFilterExpression, 2);
        }
        catch (PatternSyntaxException ignored) {
            return false;
        }
        Matcher match = filter.matcher(EMPTY);
        this.mFilteredRows = 0;
        this.mLastFilter = pFilterExpression;
        block2: for (int i = 0; i < this.mData.length; ++i) {
            String[] row;
            for (String field : row = this.mData[i]) {
                match.reset(field);
                if (!match.find()) continue;
                this.mFilteredRowsIndexMapper[this.mFilteredRows] = i;
                ++this.mFilteredRows;
                continue block2;
            }
        }
        this.fireTableDataChanged();
        return true;
    }

    @Override
    public void filterReset() {
        this.mFilteredRows = this.mRows;
        this.mLastFilter = null;
        for (int i = 0; i < this.mRows; ++i) {
            this.mFilteredRowsIndexMapper[i] = i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setFirstRowIsHeader(boolean pFirstRowIsHeader) {
        if (this.mFirstRowIsHeader == pFirstRowIsHeader) {
            return;
        }
        if (pFirstRowIsHeader && this.mRows < 1) {
            return;
        }
        if (pFirstRowIsHeader) {
            --this.mRows;
            String[][] data = new String[this.mRows][0];
            System.arraycopy(this.mData, 1, data, 0, this.mRows);
            this.mRowHeaders = this.mData[0];
            this.mData = data;
        } else {
            ++this.mRows;
            String[][] data = new String[this.mRows][0];
            System.arraycopy(this.mData, 0, data, 1, this.mData.length);
            this.mData = data;
            this.mData[0] = this.mRowHeaders;
            this.mRowHeaders = DUMMY;
        }
        this.mFirstRowIsHeader = pFirstRowIsHeader;
        this.mFilteredRowsIndexMapper = new int[this.mRows];
        if (this.mLastFilter != null) {
            this.filter(this.mLastFilter);
        } else {
            this.filterReset();
        }
    }
}

