package net.sf.cuf.csvview.browse;

import net.sf.cuf.xfer.AbstractRequest;

/**
 * Commmon base class for loading.
 */
public abstract class AbstractLoadRequest extends AbstractRequest
{
    /** true if the first row contains the header */
    protected boolean     mFirstRowIsHeader;
    /** null or the csv separator */
    protected String      mCSVSeparator;
    /** our encoding, never null */
    protected String      mEncoding;

    /**
     * Creates a new Request, the CSV data will bi loaded in execute().
     * @param pFirstRowIsHeader true if the first row contains the header
     * @param pCSVSeparator "comma" separator, may be null
     * @param pEncoding the encoding, must not be nul
     * @throws IllegalArgumentException if pFile is null
     */
    public AbstractLoadRequest(final String pCSVSeparator, final String pEncoding, final boolean pFirstRowIsHeader)
    {
        if (pEncoding==null)
        {
            throw new IllegalArgumentException("encoding must not be null");
        }
        mCSVSeparator    = pCSVSeparator;
        mEncoding        = pEncoding;
        mFirstRowIsHeader= pFirstRowIsHeader;
    }
}
