package net.sf.cuf.csvview.about;

import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Pc;

import java.util.Map;

/**
 * Dialog component of the about panel.
 */
public class AboutDc implements Dc, SwingXMLBuilder.Backlink
{
    /** our mapping helper */
    private SwingXMLBuilder mBuilder;

    /**
     * When a SwingXMLBuilder creates an object of ourselves, we want to
     * know that builder.
     * @param pBuilder the builder that created this object
     */
    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    /**
     * This method initializes only its presentation component.
     * @param pParent not used
     * @param pArgs the arguments
     */
    public void init(final Dc pParent, final Map<String, ? super Object> pArgs)
    {
        Pc pc= (Pc)mBuilder.getNonVisualObject("AboutPc");
        pc.init(this, pArgs);
    }
}
