/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sf.cuf.ui.table.ColumnVisibilityChangeEvent;
import net.sf.cuf.ui.table.ColumnVisibilityChangeListener;

public class ColumnVisibilitySupport
implements PropertyChangeListener {
    private static final String TABLE_PROPERTY_COLUMN_MODEL = "columnModel";
    private static final String TABLE_PROPERTY_MODEL = "model";
    private static final String TABLE_PROPERTY_AUTO_CREATE_COLUMNS_FROM_MODEL = "autoCreateColumnsFromModel";
    protected JTable mTable;
    protected List<TableColumn> mInvisibleColumns = new ArrayList<TableColumn>();
    protected EventListenerList mListenerList = new EventListenerList();

    public ColumnVisibilitySupport(JTable pTable) {
        if (pTable == null) {
            throw new IllegalArgumentException("table must not be null");
        }
        this.mTable = pTable;
        pTable.addPropertyChangeListener(this);
    }

    public JTable getTable() {
        return this.mTable;
    }

    protected void hideColumn(int pModelIndex) {
        int viewIndex = this.mTable.convertColumnIndexToView(pModelIndex);
        if (viewIndex >= 0) {
            TableColumnModel tcm = this.mTable.getColumnModel();
            TableColumn col = tcm.getColumn(viewIndex);
            tcm.removeColumn(col);
            this.mInvisibleColumns.add(col);
            this.fireColumnVisibilityEventHidden(col);
        }
    }

    protected void showColumn(int pModelIndex) {
        Iterator<TableColumn> i = this.mInvisibleColumns.iterator();
        while (i.hasNext()) {
            TableColumn col = i.next();
            if (col.getModelIndex() != pModelIndex) continue;
            this.mTable.getColumnModel().addColumn(col);
            i.remove();
            this.fireColumnVisibilityEventShown(col);
            return;
        }
    }

    public boolean isColumnVisible(int pModelIndex) {
        return this.mTable.convertColumnIndexToView(pModelIndex) >= 0;
    }

    public void setColumnVisible(int pModelIndex, boolean pVisible) {
        if (pVisible) {
            this.showColumn(pModelIndex);
        } else {
            this.hideColumn(pModelIndex);
        }
        this.mTable.sizeColumnsToFit(-1);
    }

    public boolean[] getColumnsVisible() {
        boolean[] visible = new boolean[this.mTable.getModel().getColumnCount()];
        for (int i = 0; i < visible.length; ++i) {
            visible[i] = this.isColumnVisible(i);
        }
        return visible;
    }

    public void setColumnsVisible(boolean[] pVisible) {
        int columnCount = this.mTable.getModel().getColumnCount();
        if (pVisible == null || pVisible.length != columnCount) {
            throw new IllegalArgumentException("visible must not be null and must contain the same number of columns as the table model");
        }
        for (int i = 0; i < columnCount; ++i) {
            if (this.isColumnVisible(i) == pVisible[i]) continue;
            this.setColumnVisible(i, pVisible[i]);
        }
    }

    public void setAllColumnsVisible() {
        int columnCount = this.mTable.getModel().getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            if (this.isColumnVisible(i)) continue;
            this.setColumnVisible(i, true);
        }
    }

    public boolean isAllColumnsVisible() {
        return this.mInvisibleColumns.isEmpty();
    }

    public TableColumn getInvisibleColumn(int pModelIndex) {
        for (TableColumn invisibleColumn : this.mInvisibleColumns) {
            TableColumn t = invisibleColumn;
            if (t.getModelIndex() != pModelIndex) continue;
            return t;
        }
        return null;
    }

    public void clearInvisibleColumns() {
        this.mInvisibleColumns.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent pEvent) {
        String propertyName = pEvent.getPropertyName();
        if (TABLE_PROPERTY_COLUMN_MODEL.equals(propertyName)) {
            if (pEvent.getNewValue() != pEvent.getOldValue()) {
                this.clearInvisibleColumns();
            }
        } else if ((TABLE_PROPERTY_AUTO_CREATE_COLUMNS_FROM_MODEL.equals(propertyName) || TABLE_PROPERTY_MODEL.equals(propertyName)) && this.mTable.getAutoCreateColumnsFromModel()) {
            this.clearInvisibleColumns();
        }
    }

    public void addColumnVisibilityChangeListener(ColumnVisibilityChangeListener pListener) {
        this.mListenerList.add(ColumnVisibilityChangeListener.class, pListener);
    }

    public void removeColumnVisibilityChangeListener(ColumnVisibilityChangeListener pListener) {
        this.mListenerList.remove(ColumnVisibilityChangeListener.class, pListener);
    }

    protected void fireColumnVisibilityEventShown(TableColumn pColumn) {
        ColumnVisibilityChangeEvent event = new ColumnVisibilityChangeEvent(this, this.mTable, pColumn);
        Object[] listeners = this.mListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ColumnVisibilityChangeListener.class) continue;
            ((ColumnVisibilityChangeListener)listeners[i + 1]).columnShown(event);
        }
    }

    protected void fireColumnVisibilityEventHidden(TableColumn pColumn) {
        ColumnVisibilityChangeEvent event = new ColumnVisibilityChangeEvent(this, this.mTable, pColumn);
        Object[] listeners = this.mListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ColumnVisibilityChangeListener.class) continue;
            ((ColumnVisibilityChangeListener)listeners[i + 1]).columnHidden(event);
        }
    }
}

