/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.builder;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.Document;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;
import net.sf.cuf.ui.DispatcherAction;
import net.sf.cuf.ui.FlexibleGridLayout;
import net.sf.cuf.ui.SwingDecoratorFunctionality;
import net.sf.cuf.ui.TableLayout2;
import net.sf.cuf.ui.TitledSeparator;
import net.sf.cuf.ui.builder.IconCache;
import net.sf.cuf.ui.builder.NonVisualBuilderDelegate;
import net.sf.cuf.ui.builder.PopupManager;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;

class VisualBuilderDelegate
implements SwingXMLBuilder.BuilderDelegate {
    private SwingXMLBuilder mBuilder;
    private static Map sEmptyBorders = new HashMap();

    VisualBuilderDelegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(SwingXMLBuilder pBuilder, Element pElement) {
        this.mBuilder = pBuilder;
        try {
            List<Element> topLevelChildren = pElement.getChildren();
            for (int i = 0; i < topLevelChildren.size(); ++i) {
                Element topLevel = topLevelChildren.get(i);
                if (!this.isWidgetElement(topLevel)) continue;
                this.addChildren(null, topLevel);
            }
        }
        finally {
            this.mBuilder = null;
        }
    }

    public void addChildren(Container pParentWidget, Element pXMLCurrent) throws IllegalArgumentException {
        Container currentComponent;
        List<Element> childElements = pXMLCurrent.getChildren();
        ArrayList<Element> childWidgetElements = new ArrayList<Element>();
        WidgetElement currentWidget = this.createWidget(pParentWidget, pXMLCurrent);
        for (Element childElement : childElements) {
            if (this.isWidgetElement(childElement)) {
                childWidgetElements.add(childElement);
                continue;
            }
            if (!VisualBuilderDelegate.isWidgetDecoration(childElement)) continue;
            this.decorateWidget(currentWidget.getWidget(), childElement);
        }
        SwingDecoratorFunctionality decorator = this.mBuilder.getSwingDecorator();
        if (decorator != null) {
            Object widget = currentWidget.getWidget();
            String name = this.mBuilder.getVisualToName().get(widget);
            if (name != null && widget instanceof Component) {
                String title;
                decorator.initialize((Component)widget, name);
                if (widget instanceof JComponent && (title = decorator.getTitle(name)) != null) {
                    ((JComponent)widget).setBorder(new TitledBorder(title));
                }
            }
        }
        for (Element childElement : childWidgetElements) {
            this.addChildren(currentWidget.getComponent(), childElement);
        }
        if (currentWidget.isPseudoWidget()) {
            PseudoWidget pseudoWidget = currentWidget.getPseudoWidget();
            pseudoWidget.addToParent(pParentWidget);
        } else if (pParentWidget != null && (currentComponent = currentWidget.getComponent()) != null) {
            if (pParentWidget instanceof JSplitPane) {
                JSplitPane splitPane = (JSplitPane)pParentWidget;
                if (splitPane.getLeftComponent() == null) {
                    splitPane.setLeftComponent(currentComponent);
                } else {
                    splitPane.setRightComponent(currentComponent);
                }
            } else if (pParentWidget instanceof JScrollPane) {
                ((JScrollPane)pParentWidget).setViewportView(currentComponent);
            } else if (pParentWidget instanceof JTabbedPane) {
                JTabbedPane tabbedPane = (JTabbedPane)pParentWidget;
                Map tabMapping = (Map)tabbedPane.getClientProperty("tabmapping");
                String widgetName = currentComponent.getName();
                if (tabMapping != null && tabMapping.containsKey(widgetName)) {
                    Object[] mapValue = (Object[])tabMapping.get(widgetName);
                    tabbedPane.addTab((String)mapValue[0], (Icon)mapValue[1], currentComponent, (String)mapValue[2]);
                    tabMapping.remove(widgetName);
                    if (tabMapping.size() == 0) {
                        tabbedPane.putClientProperty("tabmapping", null);
                    }
                }
            } else if (pParentWidget instanceof JFrame) {
                JFrame frame = (JFrame)pParentWidget;
                if (currentComponent instanceof JMenuBar) {
                    frame.setJMenuBar((JMenuBar)currentComponent);
                } else if (currentComponent instanceof JToolBar) {
                    frame.getContentPane().add((Component)currentComponent, "North");
                } else if (!(currentComponent instanceof JDialog)) {
                    frame.getContentPane().add(currentComponent);
                }
            } else if (pParentWidget instanceof JDialog) {
                ((JDialog)pParentWidget).getContentPane().add(currentComponent);
            } else {
                Object constraint;
                DefaultFormBuilder builder = null;
                if (pParentWidget instanceof JPanel) {
                    JPanel panel = (JPanel)pParentWidget;
                    builder = (DefaultFormBuilder)panel.getClientProperty("formbuilder");
                }
                if ((constraint = currentWidget.getConstraint()) != null) {
                    if (builder != null) {
                        if (!(constraint instanceof String)) {
                            throw SwingXMLBuilder.createException("invalid constraint " + constraint + " for builder", pXMLCurrent);
                        }
                        builder.add((Component)currentComponent, (String)constraint);
                    } else {
                        pParentWidget.add((Component)currentComponent, constraint);
                    }
                } else if (builder != null) {
                    builder.append(currentComponent);
                } else {
                    pParentWidget.add(currentComponent);
                }
            }
        }
        if (currentWidget.getComponent() != null) {
            String defaultButton;
            Container component = currentWidget.getComponent();
            if ((component instanceof JFrame || component instanceof JDialog) && (defaultButton = pXMLCurrent.getAttributeValue("default")) != null) {
                if (!(this.mBuilder.get(defaultButton) instanceof JButton)) {
                    throw SwingXMLBuilder.createException("could not find default button " + defaultButton, pXMLCurrent);
                }
                JButton button = (JButton)this.mBuilder.get(defaultButton);
                if (component instanceof JFrame) {
                    ((JFrame)component).getRootPane().setDefaultButton(button);
                } else {
                    ((JDialog)component).getRootPane().setDefaultButton(button);
                }
            }
            this.mBuilder.getWidgetFactory().notifyWidgetComplete(currentWidget.getComponent().getClass().getName(), pXMLCurrent, currentWidget.getComponent());
        }
    }

    private static boolean isWidgetDecoration(Element pElement) {
        String widgetDecorationName = pElement.getName();
        if (widgetDecorationName.equals("property")) {
            return true;
        }
        if (widgetDecorationName.equals("text")) {
            return true;
        }
        if (widgetDecorationName.equals("title")) {
            return true;
        }
        if (widgetDecorationName.equals("mnemonic")) {
            return true;
        }
        if (widgetDecorationName.equals("accelerator")) {
            return true;
        }
        if (widgetDecorationName.equals("shortcut")) {
            return true;
        }
        if (widgetDecorationName.equals("tooltip")) {
            return true;
        }
        if (widgetDecorationName.equals("icon")) {
            return true;
        }
        if (widgetDecorationName.equals("comboitem")) {
            return true;
        }
        if (widgetDecorationName.equals("tabmapping")) {
            return true;
        }
        if (widgetDecorationName.equals("tabitem")) {
            return true;
        }
        if (widgetDecorationName.equals("popupref")) {
            return true;
        }
        if (widgetDecorationName.equals("layoutmanager")) {
            return true;
        }
        if (widgetDecorationName.equals("constraint")) {
            return true;
        }
        if (widgetDecorationName.equals("border")) {
            return true;
        }
        if (widgetDecorationName.equals("minsize")) {
            return true;
        }
        if (widgetDecorationName.equals("maxsize")) {
            return true;
        }
        return widgetDecorationName.equals("prefsize");
    }

    private FormLayout createFormLayout(Element pElement) {
        String columns = pElement.getChildTextNormalize("columns");
        String rows = pElement.getChildTextNormalize("rows");
        if (rows == null) {
            rows = "";
        }
        FormLayout formLayout = new FormLayout(columns, rows);
        String columnGroups = pElement.getChildTextNormalize("columngroups");
        String rowGroups = pElement.getChildTextNormalize("rowgroups");
        if (columnGroups != null) {
            formLayout.setColumnGroups(this.getGroups(columnGroups));
        }
        if (rowGroups != null) {
            formLayout.setRowGroups(this.getGroups(rowGroups));
        }
        return formLayout;
    }

    private int[][] getGroups(String pGroups) {
        StringTokenizer groups = new StringTokenizer(pGroups, ";");
        int[][] groupsIndeces = new int[groups.countTokens()][];
        int n = groupsIndeces.length;
        for (int i = 0; i < n; ++i) {
            StringTokenizer sameSize = new StringTokenizer(groups.nextToken(), ",");
            groupsIndeces[i] = new int[sameSize.countTokens()];
            int m = groupsIndeces[i].length;
            for (int j = 0; j < m; ++j) {
                groupsIndeces[i][j] = Integer.parseInt(sameSize.nextToken());
            }
        }
        return groupsIndeces;
    }

    private void addBorder(Element pElement, JComponent pComponent) {
        Border border = VisualBuilderDelegate.getBorder(pElement);
        if (border != null) {
            Border oldBorder;
            Element childBorderElement = pElement.getChild("border");
            if (childBorderElement != null) {
                this.addBorder(childBorderElement, pComponent);
            }
            if ((oldBorder = pComponent.getBorder()) != null) {
                border = BorderFactory.createCompoundBorder(border, oldBorder);
            }
            pComponent.setBorder(border);
        }
    }

    static Border getBorder(Element pElement) {
        if (pElement == null) {
            return null;
        }
        String type = pElement.getAttributeValue("type");
        Border border = null;
        if ("line".equals(type)) {
            Color color = VisualBuilderDelegate.getColor(pElement, 0);
            if (color != null) {
                int thickness = 1;
                Element thicknessElement = pElement.getChild("thickness");
                if (thicknessElement != null) {
                    thickness = Integer.parseInt(thicknessElement.getTextTrim());
                }
                border = BorderFactory.createLineBorder(color, thickness);
            }
        } else if ("etched".equals(type)) {
            int etchType = 1;
            String sunken = pElement.getAttributeValue("sunken");
            if ("raised".equals(sunken)) {
                etchType = 0;
            }
            Color highlight = VisualBuilderDelegate.getColor(pElement, 0);
            Color shadow = VisualBuilderDelegate.getColor(pElement, 1);
            border = highlight != null && shadow != null ? BorderFactory.createEtchedBorder(etchType, highlight, shadow) : BorderFactory.createEtchedBorder(etchType);
        } else if ("bevel".equals(type)) {
            int bevelType = 1;
            String sunken = pElement.getAttributeValue("sunken");
            if ("raised".equals(sunken)) {
                bevelType = 0;
            }
            Color highlight = VisualBuilderDelegate.getColor(pElement, 0);
            Color shadow = VisualBuilderDelegate.getColor(pElement, 1);
            border = highlight != null && shadow != null ? BorderFactory.createBevelBorder(bevelType, highlight, shadow) : BorderFactory.createBevelBorder(bevelType);
        } else if ("empty".equals(type)) {
            String forms = pElement.getChildTextTrim("dlu");
            if (forms != null) {
                if (sEmptyBorders.containsKey(forms)) {
                    border = (Border)sEmptyBorders.get(forms);
                } else {
                    try {
                        border = Borders.createEmptyBorder(forms);
                    }
                    catch (IllegalArgumentException e) {
                        throw SwingXMLBuilder.createException("could not create a JGoodies Forms EmptyBorder, forms= " + forms, e, pElement);
                    }
                }
            } else {
                Insets insets = VisualBuilderDelegate.getInsets(pElement);
                border = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
            }
        } else if ("matte".equals(type)) {
            Insets insets = VisualBuilderDelegate.getInsets(pElement);
            Color color = VisualBuilderDelegate.getColor(pElement, 0);
            if (color != null) {
                border = BorderFactory.createMatteBorder(insets.top, insets.left, insets.bottom, insets.right, color);
            }
        }
        return border;
    }

    static Color getColor(Element pElement, int pos) {
        Color color = null;
        List<Element> colorChildren = pElement.getChildren("color");
        if (pos < colorChildren.size()) {
            color = VisualBuilderDelegate.getColor(colorChildren.get(pos));
        }
        return color;
    }

    private static Color getColor(Element pColorElement) {
        String r = pColorElement.getAttributeValue("r");
        String g = pColorElement.getAttributeValue("g");
        String b = pColorElement.getAttributeValue("b");
        String alpha = pColorElement.getAttributeValue("a");
        Color color = alpha == null ? new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b)) : new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b), Integer.parseInt(alpha));
        return color;
    }

    private void storeTabMapInformation(Map pTabMapping, Element pElement) {
        List<Element> tabItems = pElement.getChildren("tabitem");
        for (Element tabItem : tabItems) {
            Attribute refAttribute = tabItem.getAttribute("ref");
            if (refAttribute == null) {
                throw SwingXMLBuilder.createException("tabitem requires a ref attribute", pElement);
            }
            String refName = refAttribute.getValue();
            Object[] mapValue = new Object[3];
            if (pTabMapping.containsKey(refName)) {
                throw SwingXMLBuilder.createException("non uniq refName in tabmapping: " + refName, pElement);
            }
            pTabMapping.put(refName, mapValue);
            mapValue[0] = refName;
            mapValue[0] = this.mBuilder.getTitle(tabItem);
            for (Element iconElement : tabItem.getChildren("icon")) {
                Attribute nameAttribute = iconElement.getAttribute("name");
                if (!this.mBuilder.isSameLanguage(iconElement) || nameAttribute == null) continue;
                String iconRelName = nameAttribute.getValue();
                ImageIcon icon = this.mBuilder.getIconCache().getIcon(iconRelName, "");
                mapValue[1] = icon;
            }
            for (Element tooltipElement : tabItem.getChildren("tooltip")) {
                if (!this.mBuilder.isSameLanguage(tooltipElement)) continue;
                String tooltip = tooltipElement.getText();
                mapValue[2] = tooltip;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decorateWidget(Object pWidget, Element pElement) {
        String widgetDecorationName = pElement.getName();
        if (widgetDecorationName.equals("property")) {
            if (!(pWidget instanceof JComponent)) {
                throw SwingXMLBuilder.createException("can't set a property for non-JComponent " + pWidget, pElement);
            }
            JComponent component = (JComponent)pWidget;
            String key = pElement.getAttributeValue("key");
            if (key == null) {
                throw SwingXMLBuilder.createException("invalid null key", pElement);
            }
            Object value = NonVisualBuilderDelegate.getValue(this.mBuilder, pElement, key);
            component.putClientProperty(key, value);
            return;
        }
        if (widgetDecorationName.equals("text")) {
            if (!this.mBuilder.isSameLanguage(pElement)) return;
            if (pWidget instanceof JLabel) {
                ((JLabel)pWidget).setText(pElement.getText());
                return;
            } else if (pWidget instanceof AbstractButton) {
                ((AbstractButton)pWidget).setText(pElement.getText());
                return;
            } else if (pWidget instanceof TitledSeparator) {
                ((TitledSeparator)pWidget).setText(pElement.getText());
                return;
            } else {
                if (!(pWidget instanceof BuilderAppendSeparator)) return;
                ((BuilderAppendSeparator)pWidget).setText(pElement.getText());
            }
            return;
        }
        if (widgetDecorationName.equals("title")) {
            if (!this.mBuilder.isSameLanguage(pElement)) return;
            if (pWidget instanceof JComponent) {
                ((JComponent)pWidget).setBorder(new TitledBorder(pElement.getText()));
                return;
            } else if (pWidget instanceof JFrame) {
                ((JFrame)pWidget).setTitle(pElement.getText());
                return;
            } else {
                if (!(pWidget instanceof JDialog)) return;
                ((JDialog)pWidget).setTitle(pElement.getText());
            }
            return;
        }
        if (widgetDecorationName.equals("mnemonic")) {
            if (!this.mBuilder.isSameLanguage(pElement)) return;
            if (pWidget instanceof AbstractButton) {
                ((AbstractButton)pWidget).setMnemonic(pElement.getText().charAt(0));
                return;
            } else {
                if (!(pWidget instanceof JLabel)) return;
                ((JLabel)pWidget).setDisplayedMnemonic(pElement.getText().charAt(0));
            }
            return;
        }
        if (widgetDecorationName.equals("accelerator")) {
            if (!this.mBuilder.isSameLanguage(pElement) || !(pWidget instanceof JMenuItem)) return;
            String accelerator = pElement.getText();
            ((JMenuItem)pWidget).setAccelerator(KeyStroke.getKeyStroke(accelerator));
            return;
        }
        if (widgetDecorationName.equals("shortcut")) {
            if (!(pWidget instanceof JComponent)) return;
            String key = pElement.getAttributeValue("key");
            String modifiers = pElement.getAttributeValue("modifiers");
            String condition = pElement.getAttributeValue("condition");
            String string = pElement.getAttributeValue("actionref");
            try {
                ((JComponent)pWidget).getActionMap().put(string, (Action)this.mBuilder.getNonVisualObject(string));
                int cond = 0;
                int mod = 0;
                if (condition != null) {
                    cond = JComponent.class.getField(condition).getInt(condition);
                }
                if (modifiers != null) {
                    mod = KeyEvent.class.getField(modifiers).getInt(modifiers);
                }
                ((JComponent)pWidget).getInputMap(cond).put(KeyStroke.getKeyStroke(KeyEvent.class.getField(key).getInt(key), mod), string);
                return;
            }
            catch (ClassCastException e) {
                throw SwingXMLBuilder.createException("could not get an Action for actionref " + string + " for this component", e, pElement);
            }
            catch (Exception e) {
                throw SwingXMLBuilder.createException("could not create shortcut from key: '" + key + "', modifiers: '" + modifiers + ", condition: '" + condition + "' for this component", e, pElement);
            }
        }
        if (widgetDecorationName.equals("tooltip")) {
            if (!this.mBuilder.isSameLanguage(pElement) || !(pWidget instanceof JComponent)) return;
            ((JComponent)pWidget).setToolTipText(pElement.getText());
            return;
        }
        if (widgetDecorationName.equals("icon")) {
            Attribute nameAttribute = pElement.getAttribute("name");
            if (!this.mBuilder.isSameLanguage(pElement) || nameAttribute == null) return;
            String iconName = nameAttribute.getValue();
            if (pWidget instanceof JMenuItem) {
                JMenuItem menuItem = (JMenuItem)pWidget;
                ImageIcon imageIcon = this.mBuilder.getIconCache().getIcon(iconName, "Small");
                if (imageIcon == null) return;
                menuItem.setIcon(imageIcon);
                return;
            } else if (pWidget instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)pWidget;
                IconCache iconCache = this.mBuilder.getIconCache();
                ImageIcon normal = iconCache.getIcon(iconName, "");
                if (normal == null) return;
                button.setIcon(normal);
                button.setDisabledIcon(iconCache.getIcon(iconName, "Disabled"));
                button.setPressedIcon(iconCache.getIcon(iconName, "Pressed"));
                button.setSelectedIcon(iconCache.getIcon(iconName, "Selected"));
                button.setDisabledSelectedIcon(iconCache.getIcon(iconName, "DisabledSelected"));
                ImageIcon rollover = iconCache.getIcon(iconName, "Rollover");
                if (rollover == null) {
                    button.setRolloverEnabled(false);
                    return;
                } else {
                    button.setRolloverEnabled(true);
                    button.setRolloverIcon(rollover);
                    button.setRolloverSelectedIcon(iconCache.getIcon(iconName, "RolloverSelected"));
                }
                return;
            } else if (pWidget instanceof JFrame) {
                JFrame frame = (JFrame)pWidget;
                ImageIcon imageIcon = this.mBuilder.getIconCache().getIcon(iconName, "Small");
                if (imageIcon == null) return;
                frame.setIconImage(imageIcon.getImage());
                return;
            } else {
                if (!(pWidget instanceof JLabel)) throw SwingXMLBuilder.createException("no icon support for " + pWidget, pElement);
                JLabel label = (JLabel)pWidget;
                ImageIcon imageIcon = this.mBuilder.getIconCache().getIcon(iconName, "");
                if (imageIcon == null) return;
                label.setIcon(imageIcon);
            }
            return;
        }
        if (widgetDecorationName.equals("comboitem")) {
            if (!this.mBuilder.isSameLanguage(pElement) || !(pWidget instanceof JComboBox)) return;
            JComboBox combobox = (JComboBox)pWidget;
            String comboboxItem = pElement.getTextTrim();
            if ("".equals(comboboxItem)) return;
            combobox.addItem(comboboxItem);
            return;
        }
        if (widgetDecorationName.equals("tabmapping")) {
            if (!(pWidget instanceof JTabbedPane)) return;
            JTabbedPane tabbedPane = (JTabbedPane)pWidget;
            HashMap tabMapping = (HashMap)tabbedPane.getClientProperty("tabmapping");
            if (tabMapping == null) {
                tabMapping = new HashMap();
                tabbedPane.putClientProperty("tabmapping", tabMapping);
            }
            this.storeTabMapInformation(tabMapping, pElement);
            return;
        }
        if (widgetDecorationName.equals("popupref")) {
            String widgetName;
            JComponent jComponent;
            if (!(pWidget instanceof JPopupMenu)) return;
            JPopupMenu popup = (JPopupMenu)pWidget;
            PopupManager popupManger = (PopupManager)popup.getClientProperty("popupmanager");
            Attribute refAttribute = pElement.getAttribute("ref");
            if (refAttribute == null || (jComponent = this.mBuilder.getComponentByAnyName(widgetName = refAttribute.getValue())) == null) return;
            popupManger.addManagedComponent(jComponent);
            return;
        }
        if (widgetDecorationName.equals("layoutmanager") && pWidget instanceof Container) {
            void var7_46;
            Container container = (Container)pWidget;
            Attribute typeAttribute = pElement.getAttribute("type");
            if (typeAttribute == null) throw SwingXMLBuilder.createException("layout without type", pElement);
            String layoutType = typeAttribute.getValue();
            Object var7_33 = null;
            boolean foundLayoutType = true;
            try {
                Element child;
                if (layoutType.equals("gridbag")) {
                    GridBagLayout gridBagLayout = new GridBagLayout();
                } else if (layoutType.equals("null")) {
                    Object var7_35 = null;
                } else if (layoutType.equals("border")) {
                    int hgap = 0;
                    int vgap = 0;
                    child = pElement.getChild("hgap");
                    if (child != null) {
                        hgap = Integer.parseInt(child.getTextTrim());
                    }
                    if ((child = pElement.getChild("vgap")) != null) {
                        vgap = Integer.parseInt(child.getTextTrim());
                    }
                    BorderLayout borderLayout = new BorderLayout(hgap, vgap);
                } else if (layoutType.equals("box")) {
                    int axis = 0;
                    child = pElement.getChild("axis");
                    if (child != null) {
                        axis = Integer.parseInt(child.getTextTrim());
                    }
                    BoxLayout boxLayout = new BoxLayout(container, axis);
                } else if (layoutType.equals("card")) {
                    int hgap = 0;
                    int vgap = 0;
                    child = pElement.getChild("hgap");
                    if (child != null) {
                        hgap = Integer.parseInt(child.getTextTrim());
                    }
                    if ((child = pElement.getChild("vgap")) != null) {
                        vgap = Integer.parseInt(child.getTextTrim());
                    }
                    CardLayout cardLayout = new CardLayout(hgap, vgap);
                } else if (layoutType.equals("flow")) {
                    int align = 0;
                    int hgap = 0;
                    int vgap = 0;
                    child = pElement.getChild("align");
                    if (child != null) {
                        align = Integer.parseInt(child.getTextTrim());
                    }
                    if ((child = pElement.getChild("hgap")) != null) {
                        hgap = Integer.parseInt(child.getTextTrim());
                    }
                    if ((child = pElement.getChild("vgap")) != null) {
                        vgap = Integer.parseInt(child.getTextTrim());
                    }
                    FlowLayout flowLayout = new FlowLayout(align, hgap, vgap);
                } else if (layoutType.equals("grid")) {
                    int rows = 0;
                    int cols = 0;
                    int hgap = 0;
                    int vgap = 0;
                    child = pElement.getChild("rows");
                    if (child != null) {
                        rows = Integer.parseInt(child.getTextTrim());
                    }
                    if ((child = pElement.getChild("columns")) != null) {
                        cols = Integer.parseInt(child.getTextTrim());
                    }
                    if ((child = pElement.getChild("hgap")) != null) {
                        hgap = Integer.parseInt(child.getTextTrim());
                    }
                    if ((child = pElement.getChild("vgap")) != null) {
                        vgap = Integer.parseInt(child.getTextTrim());
                    }
                    GridLayout gridLayout = new GridLayout(rows, cols, hgap, vgap);
                } else if (layoutType.equals("table")) {
                    String columns = pElement.getChildText("columns");
                    String rows = pElement.getChildText("rows");
                    TableLayout2 tableLayout2 = new TableLayout2(columns, rows);
                } else if (layoutType.equals("form")) {
                    FormLayout formLayout = this.createFormLayout(pElement);
                } else if (layoutType.equals("flexiblegrid")) {
                    if (!(pWidget instanceof JPanel)) {
                        throw SwingXMLBuilder.createException("FlexibleGridLayout can only be set on a JPanel, not for a " + pWidget.getClass().getName(), pElement);
                    }
                    FlexibleGridLayout flexibleGridLayout = new FlexibleGridLayout((JPanel)pWidget);
                    Element child2 = pElement.getChild("vgap");
                    if (child2 != null) {
                        flexibleGridLayout.setVgap(Integer.parseInt(child2.getTextTrim()));
                    }
                    if (pElement.getChild("columns") != null && pElement.getChild("rows") != null) {
                        throw SwingXMLBuilder.createException("can't set both columns and rows", pElement);
                    }
                    child2 = pElement.getChild("columns");
                    if (child2 != null) {
                        flexibleGridLayout.setDefaultBreak(Integer.parseInt(child2.getTextTrim()));
                    } else {
                        child2 = pElement.getChild("rows");
                        if (child2 != null) {
                            flexibleGridLayout.setDefaultBreak(Integer.parseInt(child2.getTextTrim()));
                        }
                    }
                    FlexibleGridLayout flexibleGridLayout2 = flexibleGridLayout;
                } else {
                    foundLayoutType = false;
                }
            }
            catch (Exception e) {
                throw SwingXMLBuilder.createException("could not create layoutmanager for layout " + layoutType, e, pElement);
            }
            if (!foundLayoutType) {
                String className = pElement.getAttributeValue("class");
                if (className == null) throw SwingXMLBuilder.createException("unknown layout " + layoutType, pElement);
                try {
                    LayoutManager layoutManager = (LayoutManager)Class.forName(className).newInstance();
                }
                catch (Exception e) {
                    throw SwingXMLBuilder.createException("could not create layoutmanager class= " + className, e, pElement);
                }
            }
            container.setLayout((LayoutManager)var7_46);
            return;
        }
        if (widgetDecorationName.equals("border") && pWidget instanceof JComponent) {
            this.addBorder(pElement, (JComponent)pWidget);
            return;
        } else if (widgetDecorationName.equals("minsize") && pWidget instanceof JComponent) {
            ((JComponent)pWidget).setMinimumSize(this.parseSizeTag(pElement));
            return;
        } else if (widgetDecorationName.equals("maxsize") && pWidget instanceof JComponent) {
            ((JComponent)pWidget).setMaximumSize(this.parseSizeTag(pElement));
            return;
        } else {
            if (!widgetDecorationName.equals("prefsize") || !(pWidget instanceof JComponent)) return;
            ((JComponent)pWidget).setPreferredSize(this.parseSizeTag(pElement));
        }
    }

    protected Dimension parseSizeTag(Element pElement) {
        String[] size = pElement.getValue().split(",");
        return new Dimension(Integer.parseInt(size[0]), Integer.parseInt(size[1]));
    }

    private boolean isWidgetElement(Element pElement) {
        String widgetTypeName = pElement.getName();
        if (widgetTypeName.equals("frame")) {
            return true;
        }
        if (widgetTypeName.equals("dialog")) {
            return true;
        }
        if (widgetTypeName.equals("panel")) {
            return true;
        }
        if (widgetTypeName.equals("any")) {
            return true;
        }
        if (widgetTypeName.equals("button")) {
            return true;
        }
        if (widgetTypeName.equals("label")) {
            return true;
        }
        if (widgetTypeName.equals("radiobutton")) {
            return true;
        }
        if (widgetTypeName.equals("togglebutton")) {
            return true;
        }
        if (widgetTypeName.equals("checkbox")) {
            return true;
        }
        if (widgetTypeName.equals("textfield")) {
            return true;
        }
        if (widgetTypeName.equals("passwordfield")) {
            return true;
        }
        if (widgetTypeName.equals("textarea")) {
            return true;
        }
        if (widgetTypeName.equals("combobox")) {
            return true;
        }
        if (widgetTypeName.equals("slider")) {
            return true;
        }
        if (widgetTypeName.equals("splitpane")) {
            return true;
        }
        if (widgetTypeName.equals("scrollpane")) {
            return true;
        }
        if (widgetTypeName.equals("tabbedpane")) {
            return true;
        }
        if (widgetTypeName.equals("list")) {
            return true;
        }
        if (widgetTypeName.equals("table")) {
            return true;
        }
        if (widgetTypeName.equals("tree")) {
            return true;
        }
        if (widgetTypeName.equals("separator")) {
            return true;
        }
        if (widgetTypeName.equals("separatorpanel")) {
            return true;
        }
        if (widgetTypeName.equals("menubar")) {
            return true;
        }
        if (widgetTypeName.equals("menu")) {
            return true;
        }
        if (widgetTypeName.equals("menuitem")) {
            return true;
        }
        if (widgetTypeName.equals("toolbar")) {
            return true;
        }
        if (widgetTypeName.equals("toolbaritem")) {
            return true;
        }
        if (widgetTypeName.equals("popup")) {
            return true;
        }
        if (widgetTypeName.equals("popupmenu")) {
            return true;
        }
        if (widgetTypeName.equals("popupitem")) {
            return true;
        }
        if (widgetTypeName.equals("builder")) {
            return true;
        }
        return widgetTypeName.equals("spinner");
    }

    private WidgetElement createWidget(Container pParent, Element pElement) {
        String importNames;
        boolean recurse;
        boolean setName;
        WidgetElement widgetElement;
        Object widget;
        String widgetTypeName = pElement.getName();
        if (widgetTypeName.equals("frame")) {
            widget = this.createFrame(pParent, pElement);
        } else if (widgetTypeName.equals("dialog")) {
            widget = this.createDialog(pParent, pElement);
        } else if (widgetTypeName.equals("panel")) {
            widget = this.createPanel(pParent, pElement);
        } else if (widgetTypeName.equals("any")) {
            widget = this.createAny(pParent, pElement);
        } else if (widgetTypeName.equals("button")) {
            widget = this.createButton(pParent, pElement);
        } else if (widgetTypeName.equals("label")) {
            widget = this.createLabel(pParent, pElement);
        } else if (widgetTypeName.equals("radiobutton")) {
            widget = this.createRadioButton(pParent, pElement);
        } else if (widgetTypeName.equals("togglebutton")) {
            widget = this.createToggleButton(pParent, pElement);
        } else if (widgetTypeName.equals("checkbox")) {
            widget = this.createCheckBox(pParent, pElement);
        } else if (widgetTypeName.equals("textfield")) {
            widget = this.createTextField(pParent, pElement);
        } else if (widgetTypeName.equals("passwordfield")) {
            widget = this.createPasswordField(pParent, pElement);
        } else if (widgetTypeName.equals("textarea")) {
            widget = this.createTextArea(pParent, pElement);
        } else if (widgetTypeName.equals("combobox")) {
            widget = this.createComboBox(pParent, pElement);
        } else if (widgetTypeName.equals("slider")) {
            widget = this.createSlider(pParent, pElement);
        } else if (widgetTypeName.equals("splitpane")) {
            widget = this.createSplitPane(pParent, pElement);
        } else if (widgetTypeName.equals("scrollpane")) {
            widget = this.createScrollPane(pParent, pElement);
        } else if (widgetTypeName.equals("tabbedpane")) {
            widget = this.createTabbedPane(pParent, pElement);
        } else if (widgetTypeName.equals("list")) {
            widget = this.createList(pParent, pElement);
        } else if (widgetTypeName.equals("table")) {
            widget = this.createTable(pParent, pElement);
        } else if (widgetTypeName.equals("tree")) {
            widget = this.createTree(pParent, pElement);
        } else if (widgetTypeName.equals("separator")) {
            widget = this.createSeparator(pParent, pElement);
        } else if (widgetTypeName.equals("separatorpanel")) {
            widget = this.createSeparatorPanel(pParent, pElement);
        } else if (widgetTypeName.equals("menubar")) {
            widget = this.createMenubar(pParent, pElement);
        } else if (widgetTypeName.equals("menu")) {
            widget = this.createMenu(pParent, pElement);
        } else if (widgetTypeName.equals("menuitem")) {
            widget = this.createMenuItem(pParent, pElement);
        } else if (widgetTypeName.equals("toolbar")) {
            widget = this.createToolbar(pParent, pElement);
        } else if (widgetTypeName.equals("toolbaritem")) {
            widget = this.createToolbarItem(pParent, pElement);
        } else if (widgetTypeName.equals("popup")) {
            widget = this.createPopup(pParent, pElement);
        } else if (widgetTypeName.equals("popupmenu")) {
            widget = this.createPopupMenu(pParent, pElement);
        } else if (widgetTypeName.equals("popupitem")) {
            widget = this.createPopupItem(pParent, pElement);
        } else if (widgetTypeName.equals("builder")) {
            widget = this.createBuilder(pParent, pElement);
        } else if (widgetTypeName.equals("spinner")) {
            widget = this.createSpinner(pParent, pElement);
        } else {
            throw SwingXMLBuilder.createException("unknown widget " + widgetTypeName, pElement);
        }
        if (widget instanceof Container || widget == null) {
            widgetElement = new WidgetElement((Container)widget, this.createConstraint(pElement));
        } else if (widget instanceof WidgetElement) {
            widgetElement = (WidgetElement)widget;
        } else {
            throw SwingXMLBuilder.createException("widgets of type " + widget.getClass().getName() + " are not supported");
        }
        String name = null;
        Attribute id = pElement.getAttribute("id");
        boolean bl = setName = id != null;
        if (setName) {
            name = id.getValue();
            widgetElement.getComponent().setName(name);
        }
        if ((recurse = "true".equalsIgnoreCase(importNames = pElement.getAttributeValue("importNames"))) && (name = widgetElement.getComponent().getName()) == null) {
            throw SwingXMLBuilder.createException("can't import names of the elment name is not set", pElement);
        }
        if (setName || recurse) {
            String prefix;
            if (pParent != null) {
                prefix = this.mBuilder.getNameByContainer(pParent);
                if (prefix == null) {
                    throw SwingXMLBuilder.createException("parent of name " + name + " has no name", pElement);
                }
            } else {
                prefix = "";
                if (this.mBuilder.getContainerByName(name) != null) {
                    throw SwingXMLBuilder.createException("top level name " + name + " is not uniq", pElement);
                }
            }
            this.importMappings(pElement, prefix, widgetElement.getComponent(), recurse);
        }
        return widgetElement;
    }

    private void importMappings(Element pElement, String pPrefix, Container pNode, boolean pRecurse) {
        String newPrefix;
        String myName = pNode.getName();
        boolean hasName = myName != null;
        boolean isScrollPane = pNode instanceof JViewport;
        if (!hasName && !isScrollPane) {
            return;
        }
        if (isScrollPane) {
            newPrefix = pPrefix;
        } else {
            if (myName.indexOf("/") != -1) {
                throw SwingXMLBuilder.createException("name " + myName + "invalid (no slash allowed)", pElement);
            }
            StringBuffer sb = new StringBuffer(pPrefix.length() + "/".length() + myName.length());
            sb.append(pPrefix);
            if (pPrefix.length() > 1) {
                sb.append("/");
            }
            sb.append(myName);
            String fullName = sb.toString();
            if (this.mBuilder.getContainerByName(fullName) != null) {
                throw SwingXMLBuilder.createException("name " + fullName + " contained twice in parent", pElement);
            }
            this.mBuilder.getNameToVisual().put(fullName, pNode);
            this.mBuilder.getShortNameToVisual().put(myName, pNode);
            this.mBuilder.getVisualToName().put(pNode, fullName);
            newPrefix = fullName;
        }
        if (pRecurse) {
            Component[] children = pNode.getComponents();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof Container)) continue;
                this.importMappings(pElement, newPrefix, (Container)children[i], true);
            }
        }
    }

    private JFrame createFrame(Container pParent, Element pElement) throws IllegalArgumentException {
        JFrame frame = (JFrame)this.mBuilder.getWidgetFactory().create(JFrame.class.getName(), pElement, pParent);
        Attribute closeActionAttribute = pElement.getAttribute("closeAction");
        if (closeActionAttribute == null) {
            frame.setDefaultCloseOperation(3);
        } else {
            String closeAction = closeActionAttribute.getValue();
            final DispatcherAction action = (DispatcherAction)this.mBuilder.getNameToNonVisual().get(closeAction);
            if (action == null) {
                throw SwingXMLBuilder.createException("unknown closeAction attribute" + closeAction, pElement);
            }
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ActionEvent actionEvent = new ActionEvent(e.getSource(), e.getID(), "WINDOW_CLOSING");
                    action.actionPerformed(actionEvent);
                }
            });
            frame.setDefaultCloseOperation(0);
        }
        return frame;
    }

    private JDialog createDialog(Container pParent, Element pElement) {
        String modal;
        String escapeAction;
        JDialog dialog = (JDialog)this.mBuilder.getWidgetFactory().create(JDialog.class.getName(), pElement, pParent);
        dialog.setDefaultCloseOperation(1);
        String closeAction = pElement.getAttributeValue("closeAction");
        if (closeAction != null) {
            final DispatcherAction action = (DispatcherAction)this.mBuilder.getNameToNonVisual().get(closeAction);
            if (action == null) {
                throw SwingXMLBuilder.createException("unknown closeAction attribute" + closeAction, pElement);
            }
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ActionEvent actionEvent = new ActionEvent(e.getSource(), e.getID(), "WINDOW_CLOSING");
                    action.actionPerformed(actionEvent);
                }
            });
            dialog.setDefaultCloseOperation(0);
        }
        if ((escapeAction = pElement.getAttributeValue("escapeAction")) != null) {
            DispatcherAction action = (DispatcherAction)this.mBuilder.getNameToNonVisual().get(escapeAction);
            if (action == null) {
                throw SwingXMLBuilder.createException("unknown escapeAction attribute" + escapeAction, pElement);
            }
            KeyStroke escStroke = KeyStroke.getKeyStroke(27, 0, false);
            InputMap inputMap = dialog.getRootPane().getInputMap(2);
            ActionMap actionMap = dialog.getRootPane().getActionMap();
            inputMap.put(escStroke, "CANCEL_ACTION_KEY");
            actionMap.put("CANCEL_ACTION_KEY", action);
        }
        if ("true".equals(modal = pElement.getAttributeValue("modal"))) {
            dialog.setModal(true);
        }
        return dialog;
    }

    private JPanel createPanel(Container pParent, Element pElement) {
        return (JPanel)this.mBuilder.getWidgetFactory().create(JPanel.class.getName(), pElement, pParent);
    }

    protected JComponent createAny(Container pParent, Element pElement) {
        JComponent component;
        Attribute classAttribute = pElement.getAttribute("class");
        if (classAttribute == null) {
            throw SwingXMLBuilder.createException("an any element needs a class attribute", pElement);
        }
        String panelClassName = classAttribute.getValue();
        try {
            component = (JComponent)Class.forName(panelClassName).newInstance();
        }
        catch (Exception e) {
            throw SwingXMLBuilder.createException("could not create JComponent for an any element", e, pElement);
        }
        return component;
    }

    private JButton createButton(Container pParent, Element pElement) {
        Attribute enabledAttribute;
        JButton button = (JButton)this.mBuilder.getWidgetFactory().create(JButton.class.getName(), pElement, pParent);
        DispatcherAction action = this.getAction(pElement, this.mBuilder.getNameToNonVisual());
        if (action != null) {
            button.setAction(action);
        }
        if ((enabledAttribute = pElement.getAttribute("editable")) != null) {
            boolean enabled = "true".equals(enabledAttribute.getValue());
            button.setEnabled(enabled);
        }
        return button;
    }

    private JLabel createLabel(Container pParent, Element pElement) {
        JComponent labelfor;
        Attribute labelforAttribute;
        JLabel label = (JLabel)this.mBuilder.getWidgetFactory().create(JLabel.class.getName(), pElement, pParent);
        Attribute orientationAttribute = pElement.getAttribute("align");
        if (orientationAttribute != null) {
            int orientation = 2;
            if ("center".equals(orientationAttribute.getValue())) {
                orientation = 0;
            } else if ("right".equals(orientationAttribute.getValue())) {
                orientation = 4;
            }
            label.setHorizontalAlignment(orientation);
        }
        if ((labelforAttribute = pElement.getAttribute("labelfor")) != null && (labelfor = this.mBuilder.getComponentByAnyName(labelforAttribute.getValue())) != null) {
            label.setLabelFor(labelfor);
        }
        return label;
    }

    private JRadioButton createRadioButton(Container pParent, Element pElement) throws IllegalArgumentException {
        JRadioButton radioButton = (JRadioButton)this.mBuilder.getWidgetFactory().create(JRadioButton.class.getName(), pElement, pParent);
        DispatcherAction action = this.getAction(pElement, this.mBuilder.getNameToNonVisual());
        if (action != null) {
            radioButton.setAction(action);
        }
        if (!(pParent instanceof JComponent)) {
            throw SwingXMLBuilder.createException("parent of a radiobutton must be a JComponent", pElement);
        }
        JComponent parent = (JComponent)pParent;
        ButtonGroup buttonGroup = (ButtonGroup)parent.getClientProperty("buttongroup");
        if (buttonGroup == null) {
            buttonGroup = new ButtonGroup();
            parent.putClientProperty("buttongroup", buttonGroup);
        }
        buttonGroup.add(radioButton);
        Attribute defaultAttribute = pElement.getAttribute("default");
        if (defaultAttribute != null && "true".equals(defaultAttribute.getValue())) {
            buttonGroup.setSelected(radioButton.getModel(), true);
        }
        return radioButton;
    }

    private JToggleButton createToggleButton(Container pParent, Element pElement) {
        JToggleButton toggleButton = (JToggleButton)this.mBuilder.getWidgetFactory().create(JToggleButton.class.getName(), pElement, pParent);
        DispatcherAction action = this.getAction(pElement, this.mBuilder.getNameToNonVisual());
        if (action != null) {
            toggleButton.setAction(action);
        }
        return toggleButton;
    }

    private JCheckBox createCheckBox(Container pParent, Element pElement) {
        Attribute selectedAttribute;
        Attribute enabledAttribute;
        JCheckBox checkBox = (JCheckBox)this.mBuilder.getWidgetFactory().create(JCheckBox.class.getName(), pElement, pParent);
        DispatcherAction action = this.getAction(pElement, this.mBuilder.getNameToNonVisual());
        if (action != null && action.isToggle()) {
            checkBox.setAction(action);
            checkBox.setModel(action.getToggleModel());
        }
        if ((enabledAttribute = pElement.getAttribute("enabled")) != null) {
            boolean enabled = "true".equals(enabledAttribute.getValue());
            checkBox.setEnabled(enabled);
        }
        if ((selectedAttribute = pElement.getAttribute("selected")) != null) {
            boolean selected = "true".equals(selectedAttribute.getValue());
            checkBox.setSelected(selected);
        }
        return checkBox;
    }

    private JTextField createTextField(Container pParent, Element pElement) throws IllegalArgumentException {
        Attribute columnsAttribute;
        Attribute alignAttribute;
        Attribute editableAttribute;
        Attribute documentAttribute;
        JTextField textField;
        DefaultFormatter formatter;
        String maskFormat = pElement.getAttributeValue("maskFormat");
        String dateFormat = pElement.getAttributeValue("dateFormat");
        String numberFormat = pElement.getAttributeValue("numberFormat");
        if (maskFormat != null) {
            try {
                formatter = new MaskFormatter(maskFormat);
            }
            catch (ParseException e) {
                throw SwingXMLBuilder.createException("could not create a MaskFormatter for format " + maskFormat, e, pElement);
            }
            textField = new JFormattedTextField(formatter);
        } else if (dateFormat != null) {
            try {
                formatter = "".equals(dateFormat) ? new DateFormatter(new SimpleDateFormat()) : new DateFormatter(new SimpleDateFormat(dateFormat));
            }
            catch (IllegalArgumentException e) {
                throw SwingXMLBuilder.createException("could not create a DateFormatter for format " + dateFormat, e, pElement);
            }
            textField = new JFormattedTextField(formatter);
        } else if (numberFormat != null) {
            try {
                formatter = new NumberFormatter(new DecimalFormat(numberFormat));
            }
            catch (IllegalArgumentException e) {
                throw SwingXMLBuilder.createException("could not create a NumberFormatter for format " + numberFormat, e, pElement);
            }
            textField = new JFormattedTextField(formatter);
        } else {
            textField = (JTextField)this.mBuilder.getWidgetFactory().create(JTextField.class.getName(), pElement, pParent);
        }
        Attribute enabledAttribute = pElement.getAttribute("enabled");
        if (enabledAttribute != null) {
            boolean enabled = "true".equals(enabledAttribute.getValue());
            textField.setEnabled(enabled);
        }
        if ((documentAttribute = pElement.getAttribute("document")) != null) {
            String documentClass = documentAttribute.getValue();
            try {
                Document document = (Document)Class.forName(documentClass).newInstance();
                textField.setDocument(document);
            }
            catch (Exception e) {
                throw SwingXMLBuilder.createException("could not create Document", e, pElement);
            }
        }
        if ((editableAttribute = pElement.getAttribute("editable")) != null) {
            boolean editable = "true".equals(editableAttribute.getValue());
            textField.setEditable(editable);
        }
        if ((alignAttribute = pElement.getAttribute("align")) != null) {
            int orientation = 2;
            if ("center".equals(alignAttribute.getValue())) {
                orientation = 0;
            } else if ("left".equals(alignAttribute.getValue())) {
                orientation = 2;
            } else if ("right".equals(alignAttribute.getValue())) {
                orientation = 4;
            }
            textField.setHorizontalAlignment(orientation);
        }
        if ((columnsAttribute = pElement.getAttribute("columns")) != null) {
            int columns;
            try {
                columns = columnsAttribute.getIntValue();
            }
            catch (DataConversionException e) {
                throw SwingXMLBuilder.createException("could not create columns attributtes", e, pElement);
            }
            textField.setColumns(columns);
        }
        return textField;
    }

    private JPasswordField createPasswordField(Container pParent, Element pElement) {
        return (JPasswordField)this.mBuilder.getWidgetFactory().create(JPasswordField.class.getName(), pElement, pParent);
    }

    private JTextArea createTextArea(Container pParent, Element pElement) {
        Attribute linewrapAttribute;
        JTextArea textArea = (JTextArea)this.mBuilder.getWidgetFactory().create(JTextArea.class.getName(), pElement, pParent);
        Attribute editableAttribute = pElement.getAttribute("editable");
        if (editableAttribute != null) {
            boolean editable = "true".equals(editableAttribute.getValue());
            textArea.setEditable(editable);
        }
        if ((linewrapAttribute = pElement.getAttribute("linewrap")) != null) {
            boolean linewrap = "true".equals(linewrapAttribute.getValue());
            textArea.setLineWrap(linewrap);
        }
        return textArea;
    }

    private JComboBox createComboBox(Container pParent, Element pElement) {
        JComboBox comboBox = (JComboBox)this.mBuilder.getWidgetFactory().create(JComboBox.class.getName(), pElement, pParent);
        Attribute enabledAttribute = pElement.getAttribute("enabled");
        if (enabledAttribute != null) {
            boolean enabled = "true".equals(enabledAttribute.getValue());
            comboBox.setEnabled(enabled);
        }
        return comboBox;
    }

    private JSlider createSlider(Container pParent, Element pElement) {
        JSlider slider = (JSlider)this.mBuilder.getWidgetFactory().create(JSlider.class.getName(), pElement, pParent);
        return slider;
    }

    private JSplitPane createSplitPane(Container pParent, Element pElement) throws IllegalArgumentException {
        JSplitPane splitPane = (JSplitPane)this.mBuilder.getWidgetFactory().create(JSplitPane.class.getName(), pElement, pParent);
        int orientation = 1;
        Attribute orientationAttribute = pElement.getAttribute("orientation");
        if (orientationAttribute != null) {
            try {
                orientation = orientationAttribute.getIntValue();
            }
            catch (DataConversionException e) {
                throw SwingXMLBuilder.createException("wrong splitpane orientation " + orientationAttribute, e, pElement);
            }
        }
        splitPane.setOrientation(orientation);
        Attribute oneTouchExpandableAttribute = pElement.getAttribute("oneTouchExpandable");
        if (oneTouchExpandableAttribute != null) {
            splitPane.setOneTouchExpandable(true);
        }
        return splitPane;
    }

    private JScrollPane createScrollPane(Container pParent, Element pElement) {
        String hValue;
        JScrollPane scrollPane = (JScrollPane)this.mBuilder.getWidgetFactory().create(JScrollPane.class.getName(), pElement, pParent);
        int vertical = 22;
        int horizontal = 32;
        String vValue = pElement.getAttributeValue("verticalScrollBar");
        if (vValue != null) {
            if ("asNeeded".equals(vValue)) {
                vertical = 20;
            } else if ("always".equals(vValue)) {
                vertical = 22;
            } else if ("never".equals(vValue)) {
                vertical = 21;
            }
        }
        if ((hValue = pElement.getAttributeValue("horizontalScrollBar")) != null) {
            if ("asNeeded".equals(hValue)) {
                horizontal = 30;
            } else if ("always".equals(hValue)) {
                horizontal = 32;
            } else if ("never".equals(hValue)) {
                horizontal = 31;
            }
        }
        scrollPane.setHorizontalScrollBarPolicy(horizontal);
        scrollPane.setVerticalScrollBarPolicy(vertical);
        return scrollPane;
    }

    private JTabbedPane createTabbedPane(Container pParent, Element pElement) {
        JTabbedPane tabbedPane = (JTabbedPane)this.mBuilder.getWidgetFactory().create(JTabbedPane.class.getName(), pElement, pParent);
        int tabPlacement = 1;
        Attribute tabPlacementAttribute = pElement.getAttribute("tabPlacement");
        if (tabPlacementAttribute != null) {
            tabPlacement = Integer.parseInt(tabPlacementAttribute.getValue());
        }
        tabbedPane.setTabPlacement(tabPlacement);
        return tabbedPane;
    }

    private JList createList(Container pParent, Element pElement) {
        JList list = (JList)this.mBuilder.getWidgetFactory().create(JList.class.getName(), pElement, pParent);
        return list;
    }

    private JTable createTable(Container pParent, Element pElement) {
        JTable table = (JTable)this.mBuilder.getWidgetFactory().create(JTable.class.getName(), pElement, pParent);
        return table;
    }

    private JTree createTree(Container pParent, Element pElement) {
        JTree tree = (JTree)this.mBuilder.getWidgetFactory().create(JTree.class.getName(), pElement, pParent);
        return tree;
    }

    private JSeparator createSeparator(Container pParent, Element pElement) throws IllegalArgumentException {
        if (pParent instanceof JMenu) {
            ((JMenu)pParent).addSeparator();
        } else if (pParent instanceof JPopupMenu) {
            ((JPopupMenu)pParent).addSeparator();
        } else if (pParent instanceof JToolBar) {
            ((JToolBar)pParent).addSeparator();
        } else {
            JSeparator separator = (JSeparator)this.mBuilder.getWidgetFactory().create(JSeparator.class.getName(), pElement, pParent);
            return separator;
        }
        return null;
    }

    private TitledSeparator createSeparatorPanel(Container pParent, Element pElement) {
        TitledSeparator titledSeparator = (TitledSeparator)this.mBuilder.getWidgetFactory().create(TitledSeparator.class.getName(), pElement, pParent);
        return titledSeparator;
    }

    private JMenuBar createMenubar(Container pParent, Element pElement) throws IllegalArgumentException {
        JMenuBar menuBar = (JMenuBar)this.mBuilder.getWidgetFactory().create(JMenuBar.class.getName(), pElement, pParent);
        return menuBar;
    }

    private JMenu createMenu(Container pParent, Element pElement) throws IllegalArgumentException {
        JMenu menu = (JMenu)this.mBuilder.getWidgetFactory().create(JMenu.class.getName(), pElement, pParent);
        return menu;
    }

    private JMenuItem createMenuItem(Container pParent, Element pElement) throws IllegalArgumentException {
        JMenuItem menuItem;
        DispatcherAction action = this.getAction(pElement, this.mBuilder.getNameToNonVisual());
        if (action != null) {
            if (action.isToggle()) {
                menuItem = (JCheckBoxMenuItem)this.mBuilder.getWidgetFactory().create(JCheckBoxMenuItem.class.getName(), pElement, pParent);
                menuItem.setAction(action);
                menuItem.setModel(action.getToggleModel());
            } else {
                menuItem = (JMenuItem)this.mBuilder.getWidgetFactory().create(JMenuItem.class.getName(), pElement, pParent);
                menuItem.setAction(action);
            }
        } else {
            menuItem = (JMenuItem)this.mBuilder.getWidgetFactory().create(JMenuItem.class.getName(), pElement, pParent);
        }
        return menuItem;
    }

    private JToolBar createToolbar(Container pParent, Element pElement) throws IllegalArgumentException {
        JToolBar toolbar = (JToolBar)this.mBuilder.getWidgetFactory().create(JToolBar.class.getName(), pElement, pParent);
        return toolbar;
    }

    private JButton createToolbarItem(Container pParent, Element pElement) {
        Attribute enabledAttribute;
        JButton button = this.createButton(pParent, pElement);
        if (button.getAction() != null) {
            button.setText(null);
        }
        if ((enabledAttribute = pElement.getAttribute("enabled")) != null) {
            boolean enabled = "false".equals(enabledAttribute.getValue());
            button.setEnabled(enabled);
        }
        return button;
    }

    private JPopupMenu createPopup(Container pParent, Element pElement) throws IllegalArgumentException {
        JPopupMenu popup = (JPopupMenu)this.mBuilder.getWidgetFactory().create(JPopupMenu.class.getName(), pElement, pParent);
        return popup;
    }

    private JMenu createPopupMenu(Container pParent, Element pElement) throws IllegalArgumentException {
        return this.createMenu(pParent, pElement);
    }

    private JMenuItem createPopupItem(Container pParent, Element pElement) throws IllegalArgumentException {
        return this.createMenuItem(pParent, pElement);
    }

    private WidgetElement createBuilder(Container pParent, Element pElement) throws IllegalArgumentException {
        PseudoWidget pseudoWidget;
        String type = pElement.getAttributeValue("type");
        String command = pElement.getAttributeValue("command");
        if (type == null && command == null || type != null && command != null) {
            throw SwingXMLBuilder.createException("builder must either have a type or command attribute", pElement);
        }
        if (type != null) {
            String layoutType;
            if (!"default".equals(type)) {
                throw SwingXMLBuilder.createException("only know how to create DefaultFormBuilders", pElement);
            }
            if (!(pParent instanceof JPanel)) {
                throw SwingXMLBuilder.createException("builder only works with a JPanel", pElement);
            }
            Element layoutElement = pElement.getChild("layoutmanager");
            String string = layoutType = layoutElement == null ? null : layoutElement.getAttributeValue("type");
            if (layoutElement == null || !"form".equals(layoutType)) {
                throw SwingXMLBuilder.createException("builder needs a FormLayout", pElement);
            }
            JPanel panel = (JPanel)pParent;
            FormLayout layout = this.createFormLayout(layoutElement);
            DefaultFormBuilder builder = new DefaultFormBuilder(layout, panel);
            panel.putClientProperty("formbuilder", builder);
            return new WidgetElement(null);
        }
        if ("appendSeparator".equals(command)) {
            pseudoWidget = new BuilderAppendSeparator();
        } else if ("nextLine".equals(command)) {
            pseudoWidget = BuilderNextLine.NEXT_LINE;
        } else if (command.startsWith("appendRow")) {
            pseudoWidget = new BuilderAppendRow(command.substring(command.indexOf(58) + 1));
        } else {
            throw SwingXMLBuilder.createException("unknown builder command " + command, pElement);
        }
        return new WidgetElement(pseudoWidget);
    }

    private JSpinner createSpinner(Container pParent, Element pElement) {
        JSpinner spinner = (JSpinner)this.mBuilder.getWidgetFactory().create(JSpinner.class.getName(), pElement, pParent);
        return spinner;
    }

    protected DispatcherAction getAction(Element pElement, Map pNameToNonVisual) throws IllegalArgumentException {
        Attribute actionrefAttribute = pElement.getAttribute("actionref");
        if (actionrefAttribute != null) {
            String actionref = actionrefAttribute.getValue();
            DispatcherAction action = (DispatcherAction)pNameToNonVisual.get(actionref);
            if (action == null) {
                throw SwingXMLBuilder.createException("unknown actionref attribute " + actionref, pElement);
            }
            return action;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object createConstraint(Element pElement) throws IllegalArgumentException {
        String constraintObject = null;
        Element constraintElement = pElement.getChild("constraint");
        if (constraintElement == null) return constraintObject;
        Attribute typeAttribute = constraintElement.getAttribute("type");
        if (typeAttribute != null) {
            String constraintType = typeAttribute.getValue();
            if (constraintType.equals("gridbag")) {
                GridBagConstraints constraint = new GridBagConstraints();
                Element child = constraintElement.getChild("gridx");
                if (child != null) {
                    constraint.gridx = Integer.parseInt(child.getTextTrim());
                }
                if ((child = constraintElement.getChild("gridy")) != null) {
                    constraint.gridy = Integer.parseInt(child.getTextTrim());
                }
                if ((child = constraintElement.getChild("fill")) != null) {
                    constraint.fill = Integer.parseInt(child.getTextTrim());
                }
                if ((child = constraintElement.getChild("weightx")) != null) {
                    constraint.weightx = Double.parseDouble(child.getTextTrim());
                }
                if ((child = constraintElement.getChild("weighty")) != null) {
                    constraint.weighty = Double.parseDouble(child.getTextTrim());
                }
                if ((child = constraintElement.getChild("gridheight")) != null) {
                    constraint.gridheight = Integer.parseInt(child.getTextTrim());
                }
                if ((child = constraintElement.getChild("gridwidth")) != null) {
                    constraint.gridwidth = Integer.parseInt(child.getTextTrim());
                }
                if ((child = constraintElement.getChild("insets")) != null) {
                    Insets insets;
                    constraint.insets = insets = VisualBuilderDelegate.getInsets(child);
                }
                if ((child = constraintElement.getChild("anchor")) != null) {
                    constraint.anchor = Integer.parseInt(child.getTextTrim());
                }
                if ((child = constraintElement.getChild("ipadx")) != null) {
                    constraint.ipadx = Integer.parseInt(child.getTextTrim());
                }
                if ((child = constraintElement.getChild("ipady")) == null) return constraint;
                constraint.ipady = Integer.parseInt(child.getTextTrim());
                return constraint;
            }
            if (!constraintType.equals("flexiblegrid")) throw SwingXMLBuilder.createException("unknown constraint type" + constraintType, pElement);
            Element child = constraintElement.getChild("linebreak");
            if (child == null) return constraintObject;
            String value = child.getTextTrim();
            if (!"no".equalsIgnoreCase(value)) return "LINE_BREAK";
            return "NO_LINE_BREAK";
        }
        String constraint = constraintElement.getTextTrim();
        if ("".equals(constraint)) return constraintObject;
        return constraint;
    }

    private static Insets getInsets(Element pElement) {
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        Element inset = pElement.getChild("top");
        if (inset != null) {
            top = Integer.parseInt(inset.getTextTrim());
        }
        if ((inset = pElement.getChild("left")) != null) {
            left = Integer.parseInt(inset.getTextTrim());
        }
        if ((inset = pElement.getChild("bottom")) != null) {
            bottom = Integer.parseInt(inset.getTextTrim());
        }
        if ((inset = pElement.getChild("right")) != null) {
            right = Integer.parseInt(inset.getTextTrim());
        }
        Insets insets = new Insets(top, left, bottom, right);
        return insets;
    }

    static {
        sEmptyBorders.put("dlu2", Borders.DLU2);
        sEmptyBorders.put("dlu4", Borders.DLU4);
        sEmptyBorders.put("dlu7", Borders.DLU7);
        sEmptyBorders.put("dlu14", Borders.DLU14);
        sEmptyBorders.put("buttonbar_gap", Borders.BUTTON_BAR_PAD);
        sEmptyBorders.put("dialog", Borders.DIALOG);
        sEmptyBorders.put("tabbed_dialog", Borders.TABBED_DIALOG);
    }

    private static class BuilderAppendRow
    extends PseudoWidget {
        private String mRowSpec;

        public BuilderAppendRow(String pRowSpec) {
            this.mRowSpec = pRowSpec;
        }

        @Override
        public void addToParent(Container pParent) {
            JPanel panel = (JPanel)pParent;
            DefaultFormBuilder builder = (DefaultFormBuilder)panel.getClientProperty("formbuilder");
            builder.appendRow(this.mRowSpec);
        }
    }

    private static class BuilderNextLine
    extends PseudoWidget {
        public static final BuilderNextLine NEXT_LINE = new BuilderNextLine();

        private BuilderNextLine() {
        }

        @Override
        public void addToParent(Container pParent) {
            JPanel panel = (JPanel)pParent;
            DefaultFormBuilder builder = (DefaultFormBuilder)panel.getClientProperty("formbuilder");
            builder.nextLine();
        }
    }

    private static class BuilderAppendSeparator
    extends PseudoWidget {
        private String mText;

        private BuilderAppendSeparator() {
        }

        public void setText(String pText) {
            this.mText = pText;
        }

        @Override
        public void addToParent(Container pParent) {
            JPanel panel = (JPanel)pParent;
            DefaultFormBuilder builder = (DefaultFormBuilder)panel.getClientProperty("formbuilder");
            builder.appendSeparator(this.mText);
        }
    }

    private static abstract class PseudoWidget {
        private PseudoWidget() {
        }

        public abstract void addToParent(Container var1);
    }

    private static class WidgetElement {
        private Container mComponent;
        private Object mConstraint;
        private PseudoWidget mPseudoWidget;

        public WidgetElement(Container pComponent, Object pConstraint) {
            this.mComponent = pComponent;
            this.mConstraint = pConstraint;
            this.mPseudoWidget = null;
        }

        public WidgetElement(PseudoWidget pPseudoWidget) {
            this.mComponent = null;
            this.mConstraint = null;
            this.mPseudoWidget = pPseudoWidget;
        }

        public Container getComponent() {
            return this.mComponent;
        }

        public Object getConstraint() {
            return this.mConstraint;
        }

        public boolean isPseudoWidget() {
            return this.mPseudoWidget != null;
        }

        public PseudoWidget getPseudoWidget() {
            return this.mPseudoWidget;
        }

        public Object getWidget() {
            if (this.isPseudoWidget()) {
                return this.getPseudoWidget();
            }
            return this.getComponent();
        }
    }
}

