/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import net.sf.cuf.ui.DispatcherAction;
import net.sf.cuf.ui.SwingDecoratorFunctionality;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import org.jdom2.Attribute;
import org.jdom2.Element;

class NonVisualBuilderDelegate
implements SwingXMLBuilder.BuilderDelegate {
    private SwingXMLBuilder mBuilder = null;

    NonVisualBuilderDelegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(SwingXMLBuilder pBuilder, Element pElement) {
        this.mBuilder = pBuilder;
        try {
            List<Element> objects = pElement.getChildren();
            Iterator<Element> i$ = objects.iterator();
            while (i$.hasNext()) {
                Element object1;
                Element element = object1 = i$.next();
                String objectType = element.getName();
                Object object = null;
                Attribute idAttribute = element.getAttribute("id");
                if (idAttribute == null) {
                    if (objectType.equals("resource")) {
                        idAttribute = new Attribute("id", "ResourceBundle");
                    } else {
                        throw SwingXMLBuilder.createException("a non visual element needs a id attribute", pElement);
                    }
                }
                String id = idAttribute.getValue();
                if (this.mBuilder.getNameToNonVisual().containsKey(id)) continue;
                if (objectType.equals("object")) {
                    object = this.createObject(element);
                } else if (objectType.equals("action")) {
                    object = this.createAction(element);
                    SwingDecoratorFunctionality decorator = this.mBuilder.getSwingDecorator();
                    if (decorator != null) {
                        decorator.initialize((Action)object, id);
                    }
                } else if (objectType.equals("resource")) {
                    object = this.createResource(element);
                }
                this.mBuilder.getNameToNonVisual().put(id, object);
            }
        }
        finally {
            this.mBuilder = null;
        }
    }

    private Object createObject(Element pElement) throws IllegalArgumentException {
        Object object;
        Attribute classAttribute = pElement.getAttribute("class");
        if (classAttribute == null) {
            throw SwingXMLBuilder.createException("a non visual element needs a class attribute", pElement);
        }
        String constantValue = pElement.getAttributeValue("constant");
        if (constantValue == null) {
            String objectClassName = classAttribute.getValue();
            try {
                Class<?> objectClass = Class.forName(objectClassName);
                object = objectClass.newInstance();
            }
            catch (Exception e) {
                throw SwingXMLBuilder.createException("could not create a object of class " + objectClassName + " not found", e, pElement);
            }
        }
        String objectClassName = classAttribute.getValue();
        try {
            Class<?> objectClass = Class.forName(objectClassName);
            Field field = objectClass.getField(constantValue);
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) {
                throw SwingXMLBuilder.createException("field " + field + " is not public static final", pElement);
            }
            object = field.get(null);
        }
        catch (Exception e) {
            throw SwingXMLBuilder.createException("could not access public static final attribute of class " + objectClassName, e, pElement);
        }
        if (object instanceof SwingXMLBuilder.Backlink) {
            ((SwingXMLBuilder.Backlink)object).setSwingXMLBuilder(this.mBuilder);
        }
        return object;
    }

    private Action createAction(Element pElement) {
        Action action;
        String name = null;
        String accelerator = null;
        String mnemonic = null;
        String tooltip = null;
        String iconRelName = null;
        for (Element o5 : pElement.getChildren("text")) {
            Element textElement = o5;
            if (!this.mBuilder.isSameLanguage(textElement)) continue;
            name = textElement.getTextTrim();
        }
        for (Element o4 : pElement.getChildren("accelerator")) {
            Element acceleratorElement = o4;
            if (!this.mBuilder.isSameLanguage(acceleratorElement)) continue;
            accelerator = acceleratorElement.getTextTrim();
        }
        for (Element o3 : pElement.getChildren("mnemonic")) {
            Element mnemonicElement = o3;
            if (!this.mBuilder.isSameLanguage(mnemonicElement)) continue;
            mnemonic = mnemonicElement.getTextTrim();
        }
        for (Element o2 : pElement.getChildren("tooltip")) {
            Element tooltipElement = o2;
            if (!this.mBuilder.isSameLanguage(tooltipElement)) continue;
            tooltip = tooltipElement.getTextTrim();
        }
        for (Element o1 : pElement.getChildren("icon")) {
            Element iconRelNameElement = o1;
            if (!this.mBuilder.isSameLanguage(iconRelNameElement)) continue;
            iconRelName = iconRelNameElement.getAttributeValue("name");
        }
        ImageIcon icon = this.mBuilder.getIconCache().getIcon(iconRelName, "");
        String className = pElement.getAttributeValue("class");
        if (className == null) {
            boolean isToogle = pElement.getChild("isToggle") != null;
            action = new DispatcherAction(name, accelerator, mnemonic, tooltip, icon, isToogle);
        } else {
            try {
                action = (Action)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw SwingXMLBuilder.createException("could not create a object of class " + className, e, pElement);
            }
            Integer mnemonicInteger = null;
            if (mnemonic != null && mnemonic.length() > 0) {
                mnemonicInteger = Character.toUpperCase(mnemonic.charAt(0));
            }
            KeyStroke keyStroke = null;
            if (accelerator != null && accelerator.length() > 0) {
                keyStroke = KeyStroke.getKeyStroke(accelerator);
            }
            action.putValue("Name", name);
            action.putValue("AcceleratorKey", keyStroke);
            action.putValue("MnemonicKey", mnemonicInteger);
            action.putValue("ShortDescription", tooltip);
            action.putValue("SmallIcon", icon);
        }
        if (action instanceof SwingXMLBuilder.Backlink) {
            ((SwingXMLBuilder.Backlink)((Object)action)).setSwingXMLBuilder(this.mBuilder);
        }
        for (Element o : pElement.getChildren("property")) {
            Element element = o;
            String key = element.getAttributeValue("key");
            if (key == null) {
                throw SwingXMLBuilder.createException("invalid null key", element);
            }
            Object value = NonVisualBuilderDelegate.getValue(this.mBuilder, element, key);
            action.putValue(key, value);
        }
        return action;
    }

    static Object getValue(SwingXMLBuilder pBuilder, Element pElement, String pKey) {
        Object value;
        if (pElement.getAttribute("value") != null) {
            value = pElement.getAttributeValue("value");
        } else if (pElement.getAttribute("boolean") != null) {
            value = "true".equals(pElement.getAttributeValue("boolean")) ? Boolean.TRUE : Boolean.FALSE;
        } else if (pElement.getAttribute("int") != null) {
            String intString = pElement.getAttributeValue("int");
            try {
                int intValue = Integer.parseInt(intString);
                value = intValue;
            }
            catch (NumberFormatException e) {
                throw SwingXMLBuilder.createException("invalid int value " + intString, e, pElement);
            }
        } else if (pElement.getAttribute("ref") != null) {
            String objRef = pElement.getAttributeValue("ref");
            value = pBuilder.getNonVisualObject(objRef);
            if (value == null) {
                throw SwingXMLBuilder.createException("non non-visual object found for ref " + objRef, pElement);
            }
        } else {
            throw SwingXMLBuilder.createException("non value for key " + pKey, pElement);
        }
        return value;
    }

    private ResourceBundle createResource(Element pElement) {
        ResourceBundle bundle;
        Attribute basenameAttribute = pElement.getAttribute("basename");
        if (basenameAttribute == null) {
            throw SwingXMLBuilder.createException("a non visual element needs a basename attribute", pElement);
        }
        String basename = basenameAttribute.getValue();
        try {
            bundle = ResourceBundle.getBundle(basename, this.mBuilder.getLocale());
            if (bundle instanceof SwingXMLBuilder.Backlink) {
                ((SwingXMLBuilder.Backlink)((Object)bundle)).setSwingXMLBuilder(this.mBuilder);
            }
        }
        catch (Exception e) {
            throw SwingXMLBuilder.createException("could not load resource bundle with base name " + basename, e, pElement);
        }
        return bundle;
    }
}

