/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.builder;

import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import net.sf.cuf.ui.DispatcherAction;
import net.sf.cuf.ui.SwingConnectionManager;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import org.jdom2.Attribute;
import org.jdom2.Element;

class ConnectionBuilderDelegate
implements SwingXMLBuilder.BuilderDelegate {
    ConnectionBuilderDelegate() {
    }

    @Override
    public void build(SwingXMLBuilder pBuilder, Element pConnectElement) throws IllegalArgumentException {
        List<Element> connections = pConnectElement.getChildren();
        for (Element connection : connections) {
            try {
                JComponent source;
                JComponent component;
                JComponent source2;
                String connectionType = connection.getName();
                Attribute sourceAttribute = connection.getAttribute("source");
                Attribute targetAttribute = connection.getAttribute("target");
                Attribute methodAttribute = connection.getAttribute("method");
                if (sourceAttribute == null) {
                    throw SwingXMLBuilder.createException("a connection element needs a source attribute", connection);
                }
                if (targetAttribute == null) {
                    throw SwingXMLBuilder.createException("a connection element needs a target attribute", connection);
                }
                if (methodAttribute == null) {
                    throw SwingXMLBuilder.createException("a connection element needs a method attribute", connection);
                }
                String targetName = targetAttribute.getValue();
                Object target = pBuilder.getNonVisualObject(targetName);
                String method = methodAttribute.getValue();
                if (target == null) {
                    throw SwingXMLBuilder.createException("no target found for target name " + targetAttribute.getValue(), connection);
                }
                if (method == null || "".equals(method)) {
                    throw SwingXMLBuilder.createException("no valid method for target name " + targetAttribute.getValue(), connection);
                }
                if (connectionType.equals("buttonAction") || connectionType.equals("comboboxAction") || connectionType.equals("textfieldAction") || connectionType.equals("menuAction") || connectionType.equals("actionAction")) {
                    String sourceId = sourceAttribute.getValue();
                    Object actionObject = pBuilder.getNonVisualObject(sourceId);
                    if (actionObject instanceof DispatcherAction) {
                        DispatcherAction source3 = (DispatcherAction)actionObject;
                        SwingConnectionManager.createActionConnection(source3, target, method);
                        continue;
                    }
                    if (actionObject == null) {
                        JComponent source4;
                        JComponent component2 = pBuilder.getComponentByAnyName(sourceId);
                        if (component2 instanceof AbstractButton) {
                            source4 = (AbstractButton)component2;
                            SwingConnectionManager.createActionConnection(source4, target, method);
                            continue;
                        }
                        if (component2 instanceof JComboBox) {
                            source4 = (JComboBox)component2;
                            SwingConnectionManager.createActionConnection((JComboBox)source4, target, method);
                            continue;
                        }
                        if (component2 instanceof JTextField) {
                            source4 = (JTextField)component2;
                            SwingConnectionManager.createActionConnection((JTextField)source4, target, method);
                            continue;
                        }
                        if (component2 instanceof JMenuItem) {
                            source4 = (JMenuItem)component2;
                            SwingConnectionManager.createActionConnection(source4, target, method);
                            continue;
                        }
                        throw new IllegalArgumentException("component (id= " + sourceId + "), object= " + component2 + " can't be used to create an actionAction");
                    }
                    throw new IllegalArgumentException("action (id= " + sourceId + "), object= " + actionObject + " can't be used to create an actionAction " + "(no DispatcherAction)");
                }
                if (connectionType.equals("caretAction")) {
                    source2 = (JTextComponent)pBuilder.getComponentByAnyName(sourceAttribute.getValue());
                    SwingConnectionManager.createCaretConnection(source2, target, method);
                    continue;
                }
                if (connectionType.equals("changeAction")) {
                    component = pBuilder.getComponentByAnyName(sourceAttribute.getValue());
                    if (component instanceof AbstractButton) {
                        source = (AbstractButton)component;
                        SwingConnectionManager.createChangeConnection(source, target, method);
                        continue;
                    }
                    if (component instanceof JSlider) {
                        source = (JSlider)component;
                        SwingConnectionManager.createChangeConnection((JSlider)source, target, method);
                        continue;
                    }
                    if (component instanceof JTabbedPane) {
                        source = (JTabbedPane)component;
                        SwingConnectionManager.createChangeConnection((JTabbedPane)source, target, method);
                        continue;
                    }
                    if (component instanceof JSpinner) {
                        source = (JSpinner)component;
                        SwingConnectionManager.createChangeConnection((JSpinner)source, target, method);
                        continue;
                    }
                    throw new IllegalArgumentException("component " + component + " can't be used to create an changeAction");
                }
                if (connectionType.equals("focusAction")) {
                    source2 = pBuilder.getComponentByAnyName(sourceAttribute.getValue());
                    SwingConnectionManager.createFocusConnection(source2, target, method);
                    continue;
                }
                if (connectionType.equals("listSelectionAction")) {
                    component = pBuilder.getComponentByAnyName(sourceAttribute.getValue());
                    if (component instanceof JList) {
                        source = (JList)component;
                        SwingConnectionManager.createListSelectionConnection((JList)source, target, method);
                        continue;
                    }
                    if (component instanceof JTable) {
                        source = (JTable)component;
                        SwingConnectionManager.createListSelectionConnection((JTable)source, target, method);
                        continue;
                    }
                    throw new IllegalArgumentException("component " + component + " can't be used to create an listSelectionAction");
                }
                if (connectionType.equals("propertyChangeAction")) {
                    source2 = pBuilder.getComponentByAnyName(sourceAttribute.getValue());
                    SwingConnectionManager.createPropertyChangeConnection(source2, target, method);
                    continue;
                }
                if (connectionType.equals("treeSelectionAction")) {
                    source2 = (JTree)pBuilder.getComponentByAnyName(sourceAttribute.getValue());
                    SwingConnectionManager.createTreeSelectionConnection((JTree)source2, target, method);
                    continue;
                }
                if (connectionType.equals("documentAction")) {
                    source2 = (JTextComponent)pBuilder.getNonVisualObject(sourceAttribute.getValue());
                    SwingConnectionManager.createDocumentConnection(source2, target, method);
                    continue;
                }
                throw new IllegalArgumentException("unknown connection type " + connectionType);
            }
            catch (Exception e) {
                throw SwingXMLBuilder.createException("could not create connection", e, connection);
            }
        }
    }
}

