/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import net.sf.cuf.model.SelectionInList;
import net.sf.cuf.model.ui.ColumnAlignmentRenderer;
import net.sf.cuf.model.ui.ListTableMapperBase;
import net.sf.cuf.model.ui.NewTableSorter;

public class TableSelectionModel
extends ListTableMapperBase {
    private Class mListEntryClass;
    private List<Mapping> mColumnMapping;
    private static final Map PRIMITVE_MAPPER = new HashMap(9);
    private static final Class[] NO_CLASS_ARGS;
    private static final Object[] NO_ARGS;

    public TableSelectionModel(JTable pTable, SelectionInList pValueModel, Class pListEntry, List<Mapping> pMapping) {
        if (pListEntry == null) {
            throw new IllegalArgumentException("the list entry class must not be null");
        }
        if (!Modifier.isPublic(pListEntry.getModifiers())) {
            throw new IllegalArgumentException("the list entry class must be public");
        }
        this.mListEntryClass = pListEntry;
        this.mColumnMapping = Collections.emptyList();
        this.init(pTable, pValueModel);
        this.setColumnMapping(pTable, pMapping, false);
    }

    public TableSelectionModel(JTable pTable, SelectionInList pValueModel, Class pListEntry, List<Mapping> pMapping, boolean pSortable) {
        if (pListEntry == null) {
            throw new IllegalArgumentException("the list entry class must not be null");
        }
        if (!Modifier.isPublic(pListEntry.getModifiers())) {
            throw new IllegalArgumentException("the list entry class must be public");
        }
        this.mListEntryClass = pListEntry;
        this.mColumnMapping = Collections.emptyList();
        this.init(pTable, pValueModel);
        this.setColumnMapping(pTable, pMapping, pSortable);
    }

    private void setColumnMapping(JTable pTable, List<Mapping> pMapping, boolean pSortable) {
        if (pMapping == null) {
            throw new IllegalArgumentException("mapping must not be null");
        }
        if (pSortable) {
            NewTableSorter sorter = new NewTableSorter(pTable.getModel());
            sorter.setTableHeader(pTable.getTableHeader());
            pTable.setModel(sorter);
            this.setIndexConverter(sorter);
        }
        try {
            ArrayList<Mapping> columnMapping = new ArrayList<Mapping>(pMapping.size());
            int n = pMapping.size();
            for (int i = 0; i < n; ++i) {
                Method getter;
                Mapping mapping = pMapping.get(i);
                String attributeName = mapping.getAttributeName();
                String getterName = new StringBuffer("get").append(attributeName.substring(0, 1).toUpperCase()).append(attributeName.substring(1)).toString();
                try {
                    getter = this.mListEntryClass.getMethod(getterName, NO_CLASS_ARGS);
                }
                catch (Exception e) {
                    getterName = new StringBuffer("is").append(attributeName.substring(0, 1).toUpperCase()).append(attributeName.substring(1)).toString();
                    try {
                        getter = this.mListEntryClass.getMethod(getterName, NO_CLASS_ARGS);
                    }
                    catch (Exception e1) {
                        getterName = new StringBuffer("has").append(attributeName.substring(0, 1).toUpperCase()).append(attributeName.substring(1)).toString();
                        try {
                            getter = this.mListEntryClass.getMethod(getterName, NO_CLASS_ARGS);
                        }
                        catch (Exception e2) {
                            IllegalArgumentException iae = new IllegalArgumentException(e.getMessage());
                            iae.initCause(e);
                            throw iae;
                        }
                    }
                }
                Class columnClassForModel = mapping.getColumnClass();
                if (columnClassForModel == null && (columnClassForModel = getter.getReturnType()).isPrimitive()) {
                    columnClassForModel = (Class)PRIMITVE_MAPPER.get(columnClassForModel);
                }
                Method setter = null;
                if (mapping.isEditable()) {
                    try {
                        String setterName = new StringBuffer("set").append(attributeName.substring(0, 1).toUpperCase()).append(attributeName.substring(1)).toString();
                        setter = this.mListEntryClass.getMethod(setterName, getter.getReturnType());
                    }
                    catch (Exception e) {
                        IllegalArgumentException iae = new IllegalArgumentException(e.getMessage());
                        iae.initCause(e);
                        throw iae;
                    }
                }
                Mapping myMapping = new Mapping();
                myMapping.setAttributeName(mapping.getAttributeName());
                myMapping.setColumnName(mapping.getColumnName());
                myMapping.setColumnAlignment(mapping.getColumnAlignment());
                myMapping.setColumnClass(columnClassForModel);
                myMapping.setColumnGetter(getter);
                if (setter != null) {
                    myMapping.setEditable(true);
                    myMapping.setColumnSetter(setter);
                }
                columnMapping.add(myMapping);
            }
            this.mColumnMapping = columnMapping;
            TableModelEvent e = new TableModelEvent(this, -1);
            this.fireTableChanged(e);
            int n2 = pMapping.size();
            for (int i = 0; i < n2; ++i) {
                Mapping mapping = pMapping.get(i);
                if (mapping.getColumnAlignment() == null) continue;
                pTable.getColumnModel().getColumn(i).setCellRenderer(new ColumnAlignmentRenderer(mapping.getColumnAlignment()));
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public int getColumnCount() {
        return this.mColumnMapping.size();
    }

    @Override
    public String getColumnName(int pColumnIndex) {
        return this.mColumnMapping.get(pColumnIndex).getColumnName();
    }

    public Class getColumnClass(int pColumnIndex) {
        return this.mColumnMapping.get(pColumnIndex).getColumnClass();
    }

    @Override
    public Object getValueAt(int pRowIndex, int pColumnIndex) {
        Object back;
        Object list = this.mSelectionInList.getValue();
        Object listEntry = list.get(pRowIndex);
        Mapping columnMapping = this.mColumnMapping.get(pColumnIndex);
        Method getter = columnMapping.getColumnGetter();
        try {
            back = getter.invoke(listEntry, NO_ARGS);
        }
        catch (Exception e) {
            throw new RuntimeException("problems during getting value using " + getter, e);
        }
        return back;
    }

    @Override
    public boolean isCellEditable(int pRowIndex, int pColumnIndex) {
        Mapping columnMapping = this.mColumnMapping.get(pColumnIndex);
        return columnMapping.isEditable();
    }

    @Override
    public void setValueAt(Object pValue, int pRowIndex, int pColumnIndex) {
        Object list = this.mSelectionInList.getValue();
        Object listEntry = list.get(pRowIndex);
        Mapping columnMapping = this.mColumnMapping.get(pColumnIndex);
        Method setter = columnMapping.getColumnSetter();
        try {
            setter.invoke(listEntry, pValue);
        }
        catch (Exception e) {
            throw new RuntimeException("problems during setting value using " + setter, e);
        }
        this.mSelectionInList.signalExternalUpdate();
    }

    static {
        PRIMITVE_MAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITVE_MAPPER.put(Character.TYPE, Character.class);
        PRIMITVE_MAPPER.put(Byte.TYPE, Byte.class);
        PRIMITVE_MAPPER.put(Short.TYPE, Short.class);
        PRIMITVE_MAPPER.put(Integer.TYPE, Integer.class);
        PRIMITVE_MAPPER.put(Long.TYPE, Long.class);
        PRIMITVE_MAPPER.put(Float.TYPE, Float.class);
        PRIMITVE_MAPPER.put(Double.TYPE, Double.class);
        PRIMITVE_MAPPER.put(Void.TYPE, Void.class);
        NO_CLASS_ARGS = new Class[0];
        NO_ARGS = new Object[0];
    }

    public static class Mapping {
        private String mAttributeName = "";
        private String mColumnName = "";
        private String mColumnAlignment = null;
        private Class mColumnClass = null;
        private Method mColumnGetter = null;
        private Method mColumnSetter = null;
        private boolean mIsEditable = false;

        public Mapping() {
        }

        public Mapping(String pAttributeName, String pColumnName) {
            this();
            this.setAttributeName(pAttributeName);
            this.setColumnName(pColumnName);
        }

        public Mapping(String pAttributeName, String pColumnName, Class pColumnClass) {
            this();
            this.setAttributeName(pAttributeName);
            this.setColumnName(pColumnName);
            this.setColumnClass(pColumnClass);
        }

        public Mapping(String pAttributeName, boolean pIsEditable, String pColumnName, String pColumnAlignment, Class pColumnClass) {
            this();
            this.setAttributeName(pAttributeName);
            this.setEditable(pIsEditable);
            this.setColumnName(pColumnName);
            this.setColumnAlignment(pColumnAlignment);
            this.setColumnClass(pColumnClass);
        }

        public String getAttributeName() {
            return this.mAttributeName;
        }

        public void setAttributeName(String pAttributeName) {
            if (pAttributeName == null || "".equals(pAttributeName)) {
                throw new IllegalArgumentException("attribute name must not be null or empty");
            }
            this.mAttributeName = pAttributeName;
        }

        public boolean isEditable() {
            return this.mIsEditable;
        }

        public void setEditable(boolean pEditable) {
            this.mIsEditable = pEditable;
        }

        public String getColumnName() {
            return this.mColumnName;
        }

        public void setColumnName(String pColumnName) {
            if (pColumnName == null) {
                throw new IllegalArgumentException("column name must not be null");
            }
            this.mColumnName = pColumnName;
        }

        public String getColumnAlignment() {
            return this.mColumnAlignment;
        }

        public void setColumnAlignment(String pColumnAlignment) {
            this.mColumnAlignment = pColumnAlignment;
        }

        private Class getColumnClass() {
            return this.mColumnClass;
        }

        private void setColumnClass(Class pColumnClass) {
            this.mColumnClass = pColumnClass;
        }

        private Method getColumnGetter() {
            return this.mColumnGetter;
        }

        private void setColumnGetter(Method pColumnGetter) {
            this.mColumnGetter = pColumnGetter;
        }

        public Method getColumnSetter() {
            return this.mColumnSetter;
        }

        public void setColumnSetter(Method pColumnSetter) {
            this.mColumnSetter = pColumnSetter;
        }

        public boolean equals(Object pObject) {
            if (this == pObject) {
                return true;
            }
            if (pObject == null || this.getClass() != pObject.getClass()) {
                return false;
            }
            Mapping mapping = (Mapping)pObject;
            if (this.mIsEditable != mapping.mIsEditable) {
                return false;
            }
            if (this.mAttributeName != null ? !this.mAttributeName.equals(mapping.mAttributeName) : mapping.mAttributeName != null) {
                return false;
            }
            if (this.mColumnAlignment != null ? !this.mColumnAlignment.equals(mapping.mColumnAlignment) : mapping.mColumnAlignment != null) {
                return false;
            }
            if (this.mColumnClass != null ? !this.mColumnClass.equals(mapping.mColumnClass) : mapping.mColumnClass != null) {
                return false;
            }
            if (this.mColumnGetter != null ? !this.mColumnGetter.equals(mapping.mColumnGetter) : mapping.mColumnGetter != null) {
                return false;
            }
            if (this.mColumnName != null ? !this.mColumnName.equals(mapping.mColumnName) : mapping.mColumnName != null) {
                return false;
            }
            return !(this.mColumnSetter != null ? !this.mColumnSetter.equals(mapping.mColumnSetter) : mapping.mColumnSetter != null);
        }

        public int hashCode() {
            int result = this.mAttributeName != null ? this.mAttributeName.hashCode() : 0;
            result = 29 * result + (this.mColumnName != null ? this.mColumnName.hashCode() : 0);
            result = 29 * result + (this.mColumnAlignment != null ? this.mColumnAlignment.hashCode() : 0);
            result = 29 * result + (this.mColumnClass != null ? this.mColumnClass.hashCode() : 0);
            result = 29 * result + (this.mColumnGetter != null ? this.mColumnGetter.hashCode() : 0);
            result = 29 * result + (this.mColumnSetter != null ? this.mColumnSetter.hashCode() : 0);
            result = 29 * result + (this.mIsEditable ? 1 : 0);
            return result;
        }

        public String toString() {
            return "Mapping{AttributeName='" + this.mAttributeName + '\'' + ", ColumnName='" + this.mColumnName + '\'' + ", ColumnAlignment='" + this.mColumnAlignment + '\'' + ", ColumnClass=" + this.mColumnClass + ", ColumnGetter=" + this.mColumnGetter + ", ColumnSetter=" + this.mColumnSetter + ", IsEditable=" + this.mIsEditable + '}';
        }
    }
}

