/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.sf.cuf.model.ui.IndexConverter;
import net.sf.cuf.model.ui.ListTableMapper;

public class NewTableSorter
extends AbstractTableModel
implements IndexConverter {
    protected TableModel mTableModel;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    private static final Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    public static final Comparator COMPARABLE_COMAPRATOR = new Comparator(){

        public int compare(Object pO1, Object pO2) {
            return ((Comparable)pO1).compareTo(pO2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object pO1, Object pO2) {
            String[] s2;
            String[] s1;
            if (pO1 instanceof String[] && pO2 instanceof String[]) {
                s1 = (String[])pO1;
                s2 = (String[])pO2;
                if (s1 != null && s1.length > 0 && s2 != null && s2.length > 0) {
                    return s1[0].compareTo(s2[0]);
                }
            }
            if ((s1 = pO1.toString()) == (s2 = pO2.toString())) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo((String)s2);
        }
    };
    private Row[] mViewToModel;
    private int[] mModelToView;
    private JTableHeader mTableHeader;
    private MouseListener mMouseListener;
    private TableModelListener mTableModelListener;
    private Map mColumnComparators = new HashMap();
    private List mSortingColumns = new ArrayList();
    private List mSortingColumnsReverse = new ArrayList();
    private boolean mAttemptRestoreSelectionAfterSort = true;

    private NewTableSorter() {
        this.mMouseListener = new MouseHandler();
        this.mTableModelListener = new TableModelHandler();
        this.mColumnComparators = new HashMap();
        this.mSortingColumns = new ArrayList();
        this.mSortingColumnsReverse = new ArrayList();
    }

    public NewTableSorter(TableModel pTableModel) {
        this();
        this.setTableModel(pTableModel);
    }

    public NewTableSorter(TableModel pTableModel, JTableHeader pTableHeader) {
        this();
        this.setTableHeader(pTableHeader);
        this.setTableModel(pTableModel);
    }

    public boolean isAttemptRestoreSelectionAfterSort() {
        return this.mAttemptRestoreSelectionAfterSort;
    }

    public void setAttemptRestoreSelectionAfterSort(boolean pAttemptRestoreSelectionAfterSort) {
        this.mAttemptRestoreSelectionAfterSort = pAttemptRestoreSelectionAfterSort;
    }

    private void clearSortingState() {
        this.mViewToModel = null;
        this.mModelToView = null;
    }

    public TableModel getTableModel() {
        return this.mTableModel;
    }

    public void setTableModel(TableModel pTableModel) {
        if (this.mTableModel != null) {
            this.mTableModel.removeTableModelListener(this.mTableModelListener);
        }
        this.mTableModel = pTableModel;
        if (this.mTableModel != null) {
            this.mTableModel.addTableModelListener(this.mTableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.mTableHeader;
    }

    public void setTableHeader(JTableHeader pTableHeader) {
        if (this.mTableHeader != null) {
            this.mTableHeader.removeMouseListener(this.mMouseListener);
            TableCellRenderer defaultRenderer = this.mTableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.mTableHeader.setDefaultRenderer(((SortableHeaderRenderer)defaultRenderer).mTableCellRenderer);
            }
        }
        this.mTableHeader = pTableHeader;
        if (this.mTableHeader != null) {
            this.mTableHeader.addMouseListener(this.mMouseListener);
            this.mTableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.mTableHeader.getDefaultRenderer()));
        }
    }

    public boolean isSorting() {
        return !this.mSortingColumns.isEmpty();
    }

    private Directive getDirective(int pColumn) {
        for (Object mSortingColumn : this.mSortingColumns) {
            Directive directive = (Directive)mSortingColumn;
            if (directive.mColumn != pColumn) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getSortingStatus(int pColumn) {
        return this.getDirective(pColumn).mDirection;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.mTableHeader != null) {
            this.mTableHeader.repaint();
        }
    }

    public void setSortingStatus(int pColumn, int pStatus) {
        Directive directive = this.getDirective(pColumn);
        if (directive != EMPTY_DIRECTIVE) {
            this.mSortingColumns.remove(directive);
        }
        if (pStatus != 0) {
            this.mSortingColumns.add(new Directive(pColumn, pStatus));
        }
        this.mSortingColumnsReverse.clear();
        this.mSortingColumnsReverse.addAll(this.mSortingColumns);
        Collections.reverse(this.mSortingColumnsReverse);
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int pColumn, int pSize) {
        Directive directive = this.getDirective(pColumn);
        int priority = this.mSortingColumnsReverse.indexOf(directive);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.mDirection == -1, pSize, priority);
    }

    private void cancelSorting() {
        this.mSortingColumns.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class pType, Comparator pComparator) {
        if (pComparator == null) {
            this.mColumnComparators.remove(pType);
        } else {
            this.mColumnComparators.put(pType, pComparator);
        }
    }

    protected Comparator getComparator(int pColumn) {
        Class<?> columnType = this.mTableModel.getColumnClass(pColumn);
        Comparator comparator = (Comparator)this.mColumnComparators.get(columnType);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(columnType)) {
            return COMPARABLE_COMAPRATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    private Row[] getViewToModel() {
        if (this.mViewToModel == null) {
            int tableModelRowCount = this.mTableModel.getRowCount();
            this.mViewToModel = new Row[tableModelRowCount];
            for (int row = 0; row < tableModelRowCount; ++row) {
                this.mViewToModel[row] = new Row(row);
            }
            if (this.isSorting()) {
                Arrays.sort(this.mViewToModel);
            }
        }
        return this.mViewToModel;
    }

    public int modelIndex(int pViewIndex) {
        if (pViewIndex == -1) {
            return -1;
        }
        if (pViewIndex >= this.getViewToModel().length) {
            return -1;
        }
        return this.getViewToModel()[pViewIndex].mModelIndex;
    }

    private int[] getModelToView() {
        if (this.mModelToView == null) {
            int n = this.getViewToModel().length;
            this.mModelToView = new int[n];
            for (int i = 0; i < n; ++i) {
                this.mModelToView[this.modelIndex((int)i)] = i;
            }
        }
        return this.mModelToView;
    }

    public int viewIndex(int pModelIndex) {
        if (pModelIndex == -1) {
            return -1;
        }
        if (pModelIndex >= this.getModelToView().length) {
            return -1;
        }
        return this.getModelToView()[pModelIndex];
    }

    public void forceInitialSorting(int pColumn) {
        this.triggerSorting(pColumn, false, false);
    }

    private void triggerSorting(int pColumn, boolean pControlDown, boolean pShiftDown) {
        if (pColumn != -1) {
            int status = this.getSortingStatus(pColumn);
            if (pControlDown) {
                this.cancelSorting();
            }
            status += pShiftDown ? -1 : 1;
            status = (status + 4) % 3 - 1;
            this.setSortingStatus(pColumn, status);
        }
    }

    @Override
    public int convert2ModelIndex(int pViewIndex) {
        return this.modelIndex(pViewIndex);
    }

    @Override
    public int convert2ViewIndex(int pModelIndex) {
        return this.viewIndex(pModelIndex);
    }

    @Override
    public int getRowCount() {
        return this.mTableModel == null ? 0 : this.mTableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.mTableModel == null ? 0 : this.mTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int pColumn) {
        return this.mTableModel.getColumnName(pColumn);
    }

    public Class getColumnClass(int pColumn) {
        return this.mTableModel.getColumnClass(pColumn);
    }

    @Override
    public boolean isCellEditable(int pRow, int pColumn) {
        return this.mTableModel.isCellEditable(this.modelIndex(pRow), pColumn);
    }

    @Override
    public Object getValueAt(int pRow, int pColumn) {
        return this.mTableModel.getValueAt(this.modelIndex(pRow), pColumn);
    }

    @Override
    public void setValueAt(Object pValue, int pRow, int pColumn) {
        this.mTableModel.setValueAt(pValue, this.modelIndex(pRow), pColumn);
    }

    private static class Directive {
        private int mColumn;
        private int mDirection;

        public Directive(int pColumn, int pDirection) {
            this.mColumn = pColumn;
            this.mDirection = pDirection;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer mTableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer pTableCellRenderer) {
            this.mTableCellRenderer = pTableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable pTable, Object pValue, boolean pIsSelected, boolean pHasFocus, int pRow, int pColumn) {
            Component c = this.mTableCellRenderer.getTableCellRendererComponent(pTable, pValue, pIsSelected, pHasFocus, pRow, pColumn);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setHorizontalTextPosition(2);
                int modelColumn = pTable.convertColumnIndexToModel(pColumn);
                l.setIcon(NewTableSorter.this.getHeaderRendererIcon(modelColumn, l.getFont().getSize()));
            }
            return c;
        }
    }

    private static class Arrow
    implements Icon {
        private boolean mDescending;
        private int mSize;
        private int mPriority;

        public Arrow(boolean pDescending, int pSize, int pPriority) {
            this.mDescending = pDescending;
            this.mSize = pSize;
            this.mPriority = pPriority;
        }

        @Override
        public void paintIcon(Component pComponent, Graphics pGraphics, int pX, int pY) {
            Color color = pComponent == null ? Color.GRAY : pComponent.getBackground();
            int dx = (int)((double)(this.mSize / 2) * Math.pow(0.8, this.mPriority));
            int dy = this.mDescending ? dx : -dx;
            pY = pY + 5 * this.mSize / 6 + (this.mDescending ? -dy : 0);
            int shift = this.mDescending ? 1 : -1;
            pGraphics.translate(pX, pY);
            pGraphics.setColor(color.darker());
            pGraphics.drawLine(dx / 2, dy, 0, 0);
            pGraphics.drawLine(dx / 2, dy + shift, 0, shift);
            pGraphics.setColor(color.brighter());
            pGraphics.drawLine(dx / 2, dy, dx, 0);
            pGraphics.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.mDescending) {
                pGraphics.setColor(color.darker().darker());
            } else {
                pGraphics.setColor(color.brighter().brighter());
            }
            pGraphics.drawLine(dx, 0, 0, 0);
            pGraphics.setColor(color);
            pGraphics.translate(-pX, -pY);
        }

        @Override
        public int getIconWidth() {
            return this.mSize;
        }

        @Override
        public int getIconHeight() {
            return this.mSize;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent pEvent) {
            if (NewTableSorter.this.getTableHeader().getCursor().getType() != 0) {
                return;
            }
            JTableHeader h = (JTableHeader)pEvent.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(pEvent.getX());
            if (viewColumn < 0) {
                return;
            }
            int column = columnModel.getColumn(viewColumn).getModelIndex();
            int[] selectedRows = null;
            if (NewTableSorter.this.mAttemptRestoreSelectionAfterSort) {
                selectedRows = h.getTable().getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    selectedRows[i] = NewTableSorter.this.modelIndex(selectedRows[i]);
                }
            }
            NewTableSorter.this.triggerSorting(column, pEvent.isControlDown(), pEvent.isShiftDown());
            if (NewTableSorter.this.mAttemptRestoreSelectionAfterSort) {
                for (int selectedRow : selectedRows) {
                    int viewIndex = NewTableSorter.this.viewIndex(selectedRow);
                    h.getTable().getSelectionModel().addSelectionInterval(viewIndex, viewIndex);
                }
            }
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent pEvent) {
            if (!NewTableSorter.this.isSorting()) {
                NewTableSorter.this.clearSortingState();
                NewTableSorter.this.fireTableChanged(pEvent);
                return;
            }
            if (pEvent.getFirstRow() == -1) {
                NewTableSorter.this.cancelSorting();
                NewTableSorter.this.fireTableChanged(pEvent);
                return;
            }
            int column = pEvent.getColumn();
            if (pEvent.getFirstRow() == pEvent.getLastRow() && column != -1 && NewTableSorter.this.getSortingStatus(column) == 0 && NewTableSorter.this.mModelToView != null) {
                int viewIndex = NewTableSorter.this.getModelToView()[pEvent.getFirstRow()];
                NewTableSorter.this.fireTableChanged(new TableModelEvent(NewTableSorter.this, viewIndex, viewIndex, column, pEvent.getType()));
                return;
            }
            NewTableSorter.this.clearSortingState();
            NewTableSorter.this.fireTableDataChanged();
        }
    }

    private class Row
    implements Comparable {
        private int mModelIndex;
        private Object[] mValueCache;

        public Row(int pIndex) {
            this.mModelIndex = pIndex;
            this.mValueCache = new Object[NewTableSorter.this.mTableModel.getColumnCount()];
        }

        public int compareTo(Object pOther) {
            Row rowOther = (Row)pOther;
            int row1 = this.mModelIndex;
            int row2 = rowOther.mModelIndex;
            for (Object aMSortingColumnsReverse : NewTableSorter.this.mSortingColumnsReverse) {
                int comparison;
                Object o2;
                Object o1;
                Directive directive = (Directive)aMSortingColumnsReverse;
                int column = directive.mColumn;
                if (this.mValueCache[column] != null) {
                    o1 = this.mValueCache[column];
                } else {
                    o1 = NewTableSorter.this.mTableModel instanceof ListTableMapper && ((ListTableMapper)NewTableSorter.this.mTableModel).isColumnSortable(column) ? ((ListTableMapper)NewTableSorter.this.mTableModel).getValueForSortingAt(row1, column) : NewTableSorter.this.mTableModel.getValueAt(row1, column);
                    this.mValueCache[column] = o1;
                }
                if (rowOther.mValueCache[column] != null) {
                    o2 = rowOther.mValueCache[column];
                } else {
                    o2 = NewTableSorter.this.mTableModel instanceof ListTableMapper && ((ListTableMapper)NewTableSorter.this.mTableModel).isColumnSortable(column) ? ((ListTableMapper)NewTableSorter.this.mTableModel).getValueForSortingAt(row2, column) : NewTableSorter.this.mTableModel.getValueAt(row2, column);
                    rowOther.mValueCache[column] = o2;
                }
                if ((comparison = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : (Comparable.class.isAssignableFrom(o1.getClass()) && Comparable.class.isAssignableFrom(o2.getClass()) ? ((Comparable)o1).compareTo(o2) : NewTableSorter.this.getComparator(column).compare(o1, o2))))) == 0) continue;
                return directive.mDirection == -1 ? -comparison : comparison;
            }
            return 0;
        }
    }
}

