/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sf.cuf.model.SelectionInList;
import net.sf.cuf.model.ui.IndexConverter;

public abstract class ListTableMapperBase<T>
implements TableModel,
ListSelectionListener {
    private JTable mTable;
    protected SelectionInList<T> mSelectionInList;
    private EventListenerList mListenerList;
    private boolean mInSelectionChange;
    private IndexConverter mIndexConverter;
    private static final IndexConverter IDENTITY_CONVERTER = new IdentityIndexConverter();

    protected void init(JTable pTable, SelectionInList<T> pValueModel) {
        if (pTable == null) {
            throw new IllegalArgumentException("the table must not be null");
        }
        if (pValueModel == null) {
            throw new IllegalArgumentException("the value model must not be null");
        }
        this.mTable = pTable;
        this.mSelectionInList = pValueModel;
        this.mListenerList = new EventListenerList();
        this.mInSelectionChange = false;
        this.mIndexConverter = IDENTITY_CONVERTER;
        pTable.getSelectionModel().setSelectionMode(0);
        this.mSelectionInList.onChangeSend(this, "vmDataChanged");
        this.mSelectionInList.selectionHolder().onChangeSend(this, "vmSelectionChanged");
        pTable.setModel(this);
        pTable.getSelectionModel().addListSelectionListener(this);
    }

    protected void setIndexConverter(IndexConverter pIndexConverter) {
        if (pIndexConverter == null) {
            throw new IllegalArgumentException("IndexConverter must not be null");
        }
        this.mIndexConverter = pIndexConverter;
        this.vmSelectionChanged(new ChangeEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmDataChanged(ChangeEvent pEvent) {
        if (this.mInSelectionChange) {
            return;
        }
        int modelIndex = this.mSelectionInList.selectionHolder().intValue();
        this.mInSelectionChange = true;
        try {
            TableModelEvent e = new TableModelEvent(this);
            this.fireTableChanged(e);
            this.setTableSelection(modelIndex);
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmSelectionChanged(ChangeEvent pEvent) {
        if (this.mInSelectionChange) {
            return;
        }
        this.mInSelectionChange = true;
        try {
            int modelIndex = this.mSelectionInList.selectionHolder().intValue();
            this.setTableSelection(modelIndex);
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    private void setTableSelection(int pModelIndex) {
        int viewIndex = this.mIndexConverter.convert2ViewIndex(pModelIndex);
        if (viewIndex == -1) {
            this.mTable.getSelectionModel().clearSelection();
        } else {
            this.mTable.getSelectionModel().setSelectionInterval(viewIndex, viewIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent pEvent) {
        if (this.mInSelectionChange) {
            return;
        }
        if (pEvent.getValueIsAdjusting()) {
            return;
        }
        this.mInSelectionChange = true;
        try {
            int viewIndex = this.mTable.getSelectedRow();
            if (this.mTable.getRowCount() <= viewIndex) {
                return;
            }
            Integer modelIndex = viewIndex < 0 ? SelectionInList.NO_SELECTION : Integer.valueOf(this.mIndexConverter.convert2ModelIndex(viewIndex));
            this.mSelectionInList.selectionHolder().setValueForced(modelIndex);
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    @Override
    public int getRowCount() {
        Object list = this.mSelectionInList.getValue();
        return list == null ? 0 : list.size();
    }

    @Override
    public boolean isCellEditable(int pRowIndex, int pColumnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object pValue, int pRowIndex, int pColumnIndex) {
        throw new UnsupportedOperationException("this is a read-only table model");
    }

    @Override
    public void addTableModelListener(TableModelListener pTableModelListener) {
        this.mListenerList.add(TableModelListener.class, pTableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener pTableModelListener) {
        this.mListenerList.remove(TableModelListener.class, pTableModelListener);
    }

    protected void fireTableChanged(TableModelEvent pEvent) {
        Object[] listeners = this.mListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(pEvent);
        }
    }

    public static class IdentityIndexConverter
    implements IndexConverter {
        @Override
        public int convert2ModelIndex(int pViewIndex) {
            return pViewIndex;
        }

        @Override
        public int convert2ViewIndex(int pModelIndex) {
            return pModelIndex;
        }
    }
}

