/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import javax.swing.ComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.sf.cuf.model.ValueModel;

public class ComboBoxModelAdapter
implements ListDataListener,
ChangeListener {
    private ValueModel<Integer> mSelectionHolder;
    private ComboBoxModel mComboBoxModel;
    private boolean mInCallback;
    public static final Integer NO_SELECTION = -1;

    public ComboBoxModelAdapter(ValueModel<Integer> pSelectionHolder, ComboBoxModel pComboBoxModel) {
        if (pSelectionHolder == null) {
            throw new IllegalArgumentException("selection holder must not be null");
        }
        if (pComboBoxModel == null) {
            throw new IllegalArgumentException("combobox model must not be null");
        }
        this.mSelectionHolder = pSelectionHolder;
        this.mComboBoxModel = pComboBoxModel;
        this.mInCallback = false;
        this.mSelectionHolder.addChangeListener(this);
        this.mComboBoxModel.addListDataListener(this);
        this.adjustCombobox();
    }

    @Override
    public void intervalAdded(ListDataEvent pEvent) {
        this.handleComboboxModelChange();
    }

    @Override
    public void intervalRemoved(ListDataEvent pEvent) {
        this.handleComboboxModelChange();
    }

    @Override
    public void contentsChanged(ListDataEvent pEvent) {
        this.handleComboboxModelChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleComboboxModelChange() {
        if (this.mInCallback) {
            return;
        }
        Object selectedItem = this.mComboBoxModel.getSelectedItem();
        Integer index = NO_SELECTION;
        if (selectedItem != null) {
            int n = this.mComboBoxModel.getSize();
            for (int i = 0; i < n; ++i) {
                Object item = this.mComboBoxModel.getElementAt(i);
                if (item != selectedItem) continue;
                index = i;
                break;
            }
        }
        try {
            this.mInCallback = true;
            this.mSelectionHolder.setValue(index);
        }
        finally {
            this.mInCallback = false;
        }
    }

    @Override
    public void stateChanged(ChangeEvent pEvent) {
        if (this.mInCallback) {
            return;
        }
        this.adjustCombobox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustCombobox() {
        Integer index = this.mSelectionHolder.getValue();
        if (index == null) {
            index = NO_SELECTION;
        }
        try {
            this.mInCallback = true;
            if (index.equals(NO_SELECTION)) {
                this.mComboBoxModel.setSelectedItem(null);
            } else {
                Object item = this.mComboBoxModel.getElementAt(index);
                this.mComboBoxModel.setSelectedItem(item);
            }
        }
        finally {
            this.mInCallback = false;
        }
    }
}

