/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.ValueModel;

public class ButtonModelAdapter
implements ChangeListener {
    private ValueModel<?> mValueModel;
    private ButtonModel mButtonModel;
    private boolean mWasSelected;
    private boolean mInStateChanged;
    private boolean mInvert;

    public ButtonModelAdapter(ValueModel<?> pValueModel, ButtonModel pButtonModel) {
        this(pValueModel, pButtonModel, false);
    }

    public ButtonModelAdapter(ValueModel<?> pValueModel, ButtonModel pButtonModel, boolean pInvert) {
        if (pValueModel == null) {
            throw new IllegalArgumentException("value model must not be null");
        }
        if (pButtonModel == null) {
            throw new IllegalArgumentException("button model must not be null");
        }
        this.mValueModel = pValueModel;
        this.mButtonModel = pButtonModel;
        this.mInvert = pInvert;
        this.mButtonModel.setSelected(this.isValueModelSelected());
        this.mWasSelected = this.mButtonModel.isSelected();
        this.mInStateChanged = false;
        this.mButtonModel.addChangeListener(this);
        this.mValueModel.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent pEvent) {
        block7: {
            if (this.mInStateChanged) {
                return;
            }
            this.mInStateChanged = true;
            try {
                Object source = pEvent.getSource();
                if (source == this.mValueModel) {
                    boolean isSelected = this.isValueModelSelected();
                    this.mButtonModel.setSelected(isSelected);
                    this.mWasSelected = isSelected;
                    break block7;
                }
                if (source == this.mButtonModel) {
                    boolean isSelected = this.isButtonModelSelected();
                    if (isSelected != this.mWasSelected) {
                        this.mValueModel.setValue(isSelected);
                        this.mWasSelected = isSelected;
                    }
                    break block7;
                }
                throw new IllegalStateException("stateChanged with wrong source" + source);
            }
            finally {
                this.mInStateChanged = false;
            }
        }
    }

    private boolean isButtonModelSelected() {
        boolean isSelected = this.mButtonModel.isSelected();
        if (this.mInvert) {
            isSelected = !isSelected;
        }
        return isSelected;
    }

    private boolean isValueModelSelected() {
        boolean isSelected = this.mValueModel.booleanValue();
        if (this.mInvert) {
            isSelected = !isSelected;
        }
        return isSelected;
    }
}

