/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.converter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.model.converter.AbstractTypeConverter;
import net.sf.cuf.model.converter.ConversionException;
import net.sf.cuf.model.converter.TypeConverter;

public class RegExpConverter
extends AbstractTypeConverter<String, String>
implements TypeConverter<String, String> {
    private Pattern mPattern;
    private boolean mBlockValue;

    public RegExpConverter(ValueModel<String> pSubject, String pRegExp) {
        this(pSubject, pRegExp, true);
    }

    public RegExpConverter(ValueModel<String> pSubject, String pRegExp, boolean pBlockValue) {
        super(pSubject, false);
        if (pRegExp == null) {
            throw new IllegalArgumentException("regExp must not be null");
        }
        this.mPattern = Pattern.compile(pRegExp);
        this.mBlockValue = pBlockValue;
    }

    public boolean getBlockValue() {
        return this.mBlockValue;
    }

    public void setBlockValue(boolean pBlockValue) {
        this.mBlockValue = pBlockValue;
    }

    @Override
    public String convertSubjectToOwnValue(String pSubjectValue) throws ConversionException {
        if (pSubjectValue == null) {
            return null;
        }
        Matcher matcher = this.mPattern.matcher(pSubjectValue);
        if (matcher.matches()) {
            return pSubjectValue;
        }
        if (this.mBlockValue) {
            throw new ConversionException("subject value does not match pattern", null);
        }
        throw new ConversionException("subject value does not match pattern", null, pSubjectValue);
    }

    @Override
    public String convertOwnToSubjectValue(String pOwnValue) throws ConversionException {
        if (pOwnValue == null) {
            return null;
        }
        Matcher matcher = this.mPattern.matcher(pOwnValue);
        if (!matcher.matches()) {
            if (this.mBlockValue) {
                throw new ConversionException("string " + pOwnValue + " doesn't match pattern " + this.mPattern.pattern(), null);
            }
            throw new ConversionException("string " + pOwnValue + " doesn't match pattern " + this.mPattern.pattern(), null, pOwnValue);
        }
        return pOwnValue;
    }
}

