/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model;

import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.AbstractValueModel;
import net.sf.cuf.model.ExternalUpdate;
import net.sf.cuf.model.IndexProvider;
import net.sf.cuf.model.IndexValidHolder;
import net.sf.cuf.model.SelectionInList;
import net.sf.cuf.model.ValueModel;

public class IndexedAdapter<T>
extends AbstractValueModel<T>
implements ValueModel<T>,
ExternalUpdate,
ChangeListener {
    private ValueModel<List<T>> mTrigger;
    private IndexProvider mIndexProvider;
    private SelectionInList<T> mSelectionInList;
    private List<T> mSource;
    private int mIndex;
    private IndexValidHolder mIndexInList;

    public IndexedAdapter(ValueModel<List<T>> pTrigger) {
        this(pTrigger, -1);
    }

    public IndexedAdapter(ValueModel<List<T>> pTrigger, int pIndex) {
        if (pTrigger == null) {
            throw new IllegalArgumentException("trigger must not be null");
        }
        List<T> value = pTrigger.getValue();
        if (value != null && !(value instanceof List)) {
            throw new IllegalArgumentException("trigger value must be null or a List, not a " + value.getClass().getName());
        }
        this.init(pTrigger.getValue(), pTrigger, pIndex);
    }

    public IndexedAdapter(List<T> pSource) {
        this(pSource, -1);
    }

    public IndexedAdapter(List<T> pSource, int pIndex) {
        if (pSource == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.init(pSource, null, pIndex);
    }

    private void init(List<T> pSource, ValueModel<List<T>> pTrigger, int pIndex) {
        this.mSource = pSource;
        this.mTrigger = pTrigger;
        this.mIndex = pIndex;
        this.setInSetValue(false, false);
        if (this.mTrigger instanceof IndexProvider) {
            this.mIndexProvider = (IndexProvider)((Object)this.mTrigger);
            this.mIndex = this.mIndexProvider.getIndex();
        } else {
            this.mIndexProvider = null;
        }
        IndexedAdapter.checkIndex(this.mIndex, this.mSource);
        this.mIndexInList = new IndexValidHolder(this.mIndex);
        if (this.mTrigger != null) {
            this.mTrigger.addChangeListener(this);
            if (this.mTrigger instanceof SelectionInList) {
                this.mSelectionInList = (SelectionInList)this.mTrigger;
                ValueModel<Integer> indexProvider = this.mSelectionInList.selectionHolder();
                indexProvider.onChangeSend(this, "indexChanged");
            }
        }
    }

    public ValueModel<List<T>> getTrigger() {
        return this.mTrigger;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mTrigger != null && !this.mTrigger.isDisposed()) {
            this.mTrigger.removeChangeListener(this);
        }
        if (this.mSelectionInList != null && !this.mSelectionInList.isDisposed()) {
            this.mSelectionInList.selectionHolder().retractInterestsFor(this);
        }
        this.mIndexInList.dispose();
    }

    private static void checkIndex(int pIndex, List<?> pSource) {
        int maxSize = -1;
        if (pSource != null) {
            maxSize = pSource.size();
        }
        if (pIndex != -1 && (pIndex < -1 || pIndex >= maxSize)) {
            throw new IllegalArgumentException("index out of range, got " + pIndex + ", but list size is " + maxSize);
        }
    }

    private List<T> getSource() {
        if (this.mSelectionInList != null) {
            this.mSource = this.mSelectionInList.getValue();
        }
        return this.mSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(T pValue, boolean pIsSetForced) {
        this.checkDisposed();
        if (this.getSource() == null || this.mIndex == -1) {
            return;
        }
        this.setInSetValue(true, pIsSetForced);
        try {
            this.mSource.set(this.mIndex, pValue);
            this.fireStateChanged();
        }
        finally {
            this.setInSetValue(false, false);
        }
    }

    @Override
    public T getValue() {
        this.checkDisposed();
        if (this.getSource() == null || this.mIndex == -1) {
            return null;
        }
        return this.mSource.get(this.mIndex);
    }

    public void setIndex(int pIndex) {
        this.checkDisposed();
        IndexedAdapter.checkIndex(pIndex, this.getSource());
        this.mIndex = pIndex;
        this.mIndexInList.setIndex(this.mIndex);
        this.fireStateChanged();
    }

    public int getIndex() {
        this.checkDisposed();
        return this.mIndex;
    }

    public void indexChanged(ChangeEvent pEvent) {
        Integer index = this.mSelectionInList.selectionHolder().getValue();
        this.setIndex(index);
    }

    public ValueModel<Boolean> isIndexInList() {
        this.checkDisposed();
        return this.mIndexInList;
    }

    @Override
    public void signalExternalUpdate() {
        if (this.mTrigger instanceof ExternalUpdate) {
            ((ExternalUpdate)((Object)this.mTrigger)).signalExternalUpdate();
        } else {
            super.signalExternalUpdate();
        }
    }

    @Override
    public void stateChanged(ChangeEvent pEvent) {
        this.checkDisposed();
        if (this.isInSetValue()) {
            return;
        }
        if (this.mTrigger == null) {
            throw new IllegalStateException("got a callback with no trigger");
        }
        List<T> newList = this.mTrigger.getValue();
        int newIndex = -1;
        if (this.mIndexProvider != null) {
            newIndex = this.mIndexProvider.getIndex();
        } else if (this.mIndex != -1 && newList != null && this.mIndex >= 0 && this.mIndex < newList.size()) {
            newIndex = this.mIndex;
        }
        IndexedAdapter.checkIndex(newIndex, newList);
        this.mSource = newList;
        this.mIndex = newIndex;
        this.mIndexInList.setIndex(this.mIndex);
        this.fireStateChanged();
    }
}

