/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model;

import java.lang.reflect.Constructor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.AbstractValueModel;
import net.sf.cuf.model.ExternalUpdate;
import net.sf.cuf.model.ValueModel;

public class BufferedValueHolder<T>
extends AbstractValueModel<T>
implements ValueModel<T>,
ExternalUpdate,
ChangeListener {
    public static final Boolean READ_FROM_SUBJECT = Boolean.FALSE;
    public static final Boolean WRITE_TO_SUBJECT = Boolean.TRUE;
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private ValueModel<T> mSubject;
    private T mBufferedValue;
    private ValueModel<?> mTrigger;
    private boolean mCloneSubjectValue;

    public BufferedValueHolder(ValueModel<T> pSubject, ValueModel<?> pTrigger) {
        this(pSubject, pTrigger, false);
    }

    public BufferedValueHolder(ValueModel<T> pSubject, ValueModel<?> pTrigger, boolean pCopySubjectValue) {
        if (pSubject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (pTrigger == null) {
            throw new IllegalArgumentException("trigger must not be null");
        }
        this.mSubject = pSubject;
        this.mCloneSubjectValue = pCopySubjectValue;
        this.mBufferedValue = this.getSubjectValue();
        this.mTrigger = pTrigger;
        this.setInSetValue(false, false);
        this.mTrigger.addChangeListener(this);
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (!this.mTrigger.isDisposed()) {
            this.mTrigger.removeChangeListener(this);
        }
    }

    private T getSubjectValue() {
        Object value = this.mSubject.getValue();
        if (this.mCloneSubjectValue && value != null) {
            Class<?> valueClass = value.getClass();
            try {
                Constructor<?> constructor = valueClass.getConstructor(valueClass);
                value = constructor.newInstance(value);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("can't clone because copy constructor is missing: " + e.getMessage());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("can't clone value: " + e.getMessage());
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(T pValue, boolean pIsSetForced) {
        this.checkDisposed();
        if (!pIsSetForced && (this.mBufferedValue == pValue || (this.mBufferedValue != null ? this.mBufferedValue.equals(pValue) : pValue.equals(this.mBufferedValue)))) {
            return;
        }
        try {
            this.setInSetValue(true, pIsSetForced);
            this.mBufferedValue = pValue;
            this.fireStateChanged();
        }
        finally {
            this.setInSetValue(false, false);
        }
    }

    @Override
    public T getValue() {
        this.checkDisposed();
        return this.mBufferedValue;
    }

    public boolean isBufferEqual() {
        this.checkDisposed();
        T originalValue = this.mSubject.getValue();
        return originalValue == null ? this.mBufferedValue == null : originalValue.equals(this.mBufferedValue);
    }

    @Override
    public void stateChanged(ChangeEvent pEvent) {
        this.checkDisposed();
        if (this.isInSetValue()) {
            throw new IllegalStateException("trigger fired during a setValue()");
        }
        Object newTriggerValue = this.mTrigger.getValue();
        if (newTriggerValue == null) {
            return;
        }
        if (!(newTriggerValue instanceof Boolean || TRUE.equals(newTriggerValue) || FALSE.equals(newTriggerValue))) {
            throw new IllegalArgumentException("boolean value expected, got " + newTriggerValue);
        }
        boolean doWrite = newTriggerValue instanceof Boolean ? ((Boolean)newTriggerValue).booleanValue() : Boolean.valueOf((String)newTriggerValue).booleanValue();
        if (doWrite) {
            this.mSubject.setValue(this.mBufferedValue, this.mTrigger.isSetForced());
        } else {
            this.setValue(this.getSubjectValue(), this.mTrigger.isSetForced());
        }
    }
}

