/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.debug;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.List;
import net.sf.cuf.state.SimpleStateExpression;
import net.sf.cuf.state.State;
import net.sf.cuf.state.StateExpression;
import org.w3c.dom.Node;

public class StateInfo {
    private String mId;
    private Node mStateNode;
    private State mState;

    public StateInfo(String pId, State pState) {
        this(pId, null, pState);
    }

    public StateInfo(String pId, Node pStateNode, State pState) {
        this.mId = pId;
        this.mStateNode = pStateNode;
        this.mState = pState;
    }

    public String getId() {
        return this.mId;
    }

    public Node getStateNode() {
        return this.mStateNode;
    }

    public State getState() {
        return this.mState;
    }

    public String getDetails() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.getDetails(pw, "", this.mState);
        pw.close();
        return sw.toString();
    }

    private void getDetails(PrintWriter pOut, String pIndent, State pState) {
        if (pState instanceof StateExpression) {
            pOut.println(pIndent + "Expression " + pState.getName() + ": " + StateInfo.getIniEnString(pState));
            if (pState instanceof SimpleStateExpression) {
                SimpleStateExpression expression = (SimpleStateExpression)pState;
                List states = (List)StateInfo.getPrivateValue(expression, "mStates");
                List inverts = (List)StateInfo.getPrivateValue(expression, "mInverts");
                List operations = (List)StateInfo.getPrivateValue(expression, "mOperations");
                for (int i = 0; i < states.size(); ++i) {
                    pOut.println(pIndent + "  " + operations.get(i) + (Boolean.TRUE.equals(inverts.get(i)) ? " not" : ""));
                    this.getDetails(pOut, pIndent + "    ", (State)states.get(i));
                }
            }
        } else {
            pOut.println(pIndent + "State " + pState.getName() + ": " + StateInfo.getIniEnString(pState));
        }
    }

    private static Object getPrivateValue(Object pObj, String pAttr) {
        try {
            Field field = pObj.getClass().getDeclaredField(pAttr);
            field.setAccessible(true);
            Object result = field.get(pObj);
            field.setAccessible(false);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getIniEnString(State pState) {
        return (pState.isInitialized() ? "initialized" : "not initialized") + (pState.isEnabled() ? " enabled" : " disabled");
    }
}

