/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.appevent;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cuf.appevent.AppEvent;

public class BindEvent
extends AppEvent {
    private Method mMethodToCallBack;
    private Class<? extends AppEvent> mAppEventToBindTo;
    private int mHopCount;

    public BindEvent(Object pSource, String pMethodToCallBack, Class<? extends AppEvent> pAppEventToBindTo) {
        this(pSource, pMethodToCallBack, pAppEventToBindTo, 0);
    }

    public BindEvent(Object pSource, String pMethodToCallBack, Class<? extends AppEvent> pAppEventToBindTo, int pHopCount) {
        super(pSource);
        if (pSource == null) {
            throw new IllegalArgumentException("pSource must not be null");
        }
        if (pMethodToCallBack == null) {
            throw new IllegalArgumentException("pMethodToCallBack must not be null");
        }
        if (pAppEventToBindTo == null) {
            throw new IllegalArgumentException("pAppEventToBindTo must not be null");
        }
        if (!AppEvent.class.isAssignableFrom(pAppEventToBindTo)) {
            throw new IllegalArgumentException(pAppEventToBindTo.getName() + " is not derived from AppEvent");
        }
        if (pHopCount < 0) {
            throw new IllegalArgumentException("pHopCount must be >= 0");
        }
        if (!Modifier.isPublic(pSource.getClass().getModifiers())) {
            throw new IllegalArgumentException("pSource must be an object from a public class");
        }
        try {
            this.mMethodToCallBack = pSource.getClass().getMethod(pMethodToCallBack, pAppEventToBindTo);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (!Modifier.isPublic(this.mMethodToCallBack.getModifiers())) {
            throw new IllegalArgumentException(pMethodToCallBack + " isn't a public method");
        }
        this.mAppEventToBindTo = pAppEventToBindTo;
        this.mHopCount = pHopCount;
        if (this.mHopCount == 0) {
            this.mHopCount = -1;
        }
    }

    @Override
    public void forward() {
        if (this.mHopCount < 0) {
            return;
        }
        if (this.mHopCount < 1) {
            this.consume();
        }
        --this.mHopCount;
    }

    public Object getTarget() {
        return this.source;
    }

    public Method getMethod() {
        return this.mMethodToCallBack;
    }

    public Class<? extends AppEvent> getTriggerClass() {
        return this.mAppEventToBindTo;
    }
}

