/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import net.sf.cuf.ui.SwingDecorator;
import net.sf.cuf.ui.table.BasicDialog;

public class VisibilityDialog
extends BasicDialog {
    private JList mColumnHeaders;
    private boolean[] mResult;

    public VisibilityDialog(Frame pOwner) {
        super(pOwner, "TABLEVIS_DIALOG");
        this.addComponents();
    }

    private void addComponents() {
        Container pane = this.getContentPane();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        Insets insetsList = new Insets(2, 4, 2, 4);
        Insets insetsManipulationButtons = new Insets(2, 10, 2, 4);
        Insets insetsButtons = new Insets(15, 4, 2, 4);
        this.mColumnHeaders = new JList();
        this.mColumnHeaders.setCellRenderer(new ColumnListCellRenderer());
        this.mColumnHeaders.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent pEvent) {
                if (pEvent.getClickCount() == 2 && pEvent.getModifiers() == 16) {
                    VisibilityDialog.this.processColumnToggle(VisibilityDialog.this.mColumnHeaders.locationToIndex(pEvent.getPoint()));
                    pEvent.consume();
                } else {
                    super.mouseClicked(pEvent);
                }
            }
        });
        gbc.gridheight = 4;
        gbc.insets = insetsList;
        pane.add((Component)new JScrollPane(this.mColumnHeaders, 22, 31), gbc);
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.insets = insetsManipulationButtons;
        JButton buttonShow = new JButton();
        SwingDecorator.initialize(buttonShow, "TABLEVIS_DIALOG_SHOW");
        buttonShow.setDefaultCapable(false);
        buttonShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                VisibilityDialog.this.processColumnsShowHide(true);
            }
        });
        gbc.gridx = 1;
        pane.add((Component)buttonShow, gbc);
        JButton buttonHide = new JButton();
        SwingDecorator.initialize(buttonHide, "TABLEVIS_DIALOG_HIDE");
        buttonHide.setDefaultCapable(false);
        buttonHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                VisibilityDialog.this.processColumnsShowHide(false);
            }
        });
        ++gbc.gridy;
        gbc.weighty = 100.0;
        gbc.anchor = 18;
        pane.add((Component)buttonHide, gbc);
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        JButton buttonSelectAll = new JButton();
        SwingDecorator.initialize(buttonSelectAll, "TABLEVIS_DIALOG_SELECTALL");
        buttonSelectAll.setDefaultCapable(false);
        buttonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                VisibilityDialog.this.mColumnHeaders.setSelectionInterval(0, VisibilityDialog.this.mColumnHeaders.getModel().getSize() - 1);
            }
        });
        ++gbc.gridy;
        pane.add((Component)buttonSelectAll, gbc);
        JButton buttonSelectNone = new JButton();
        SwingDecorator.initialize(buttonSelectNone, "TABLEVIS_DIALOG_SELECTNONE");
        buttonSelectNone.setDefaultCapable(false);
        buttonSelectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                VisibilityDialog.this.mColumnHeaders.clearSelection();
            }
        });
        ++gbc.gridy;
        pane.add((Component)buttonSelectNone, gbc);
        gbc.fill = 0;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 14;
        gbc.insets = insetsButtons;
        pane.add((Component)this.createOkCancelButtons(), gbc);
    }

    public boolean[] show(TableModel pTableModel, boolean[] pVisible) {
        if (pTableModel == null) {
            throw new IllegalArgumentException("tableModel must not be null");
        }
        if (pVisible == null) {
            throw new IllegalArgumentException("tableSortInfoList must not be null");
        }
        if (pTableModel.getColumnCount() != pVisible.length) {
            throw new IllegalArgumentException("tableModel and visibility must contain the same number of elements");
        }
        this.mColumnHeaders.setModel(new ColumnListModel(this.fetchColumnHeaders(pTableModel, 0), pVisible));
        this.mColumnHeaders.setSelectionModel(new DefaultListSelectionModel());
        this.mColumnHeaders.ensureIndexIsVisible(0);
        this.mColumnHeaders.requestFocus();
        this.showDialog();
        return this.mResult;
    }

    @Override
    protected void processDialogOk() {
        this.setVisible(false);
        ColumnListModel columns = (ColumnListModel)this.mColumnHeaders.getModel();
        this.mResult = new boolean[columns.getSize()];
        for (int i = 0; i < columns.getSize(); ++i) {
            this.mResult[i] = ((ColumnListElement)columns.getElementAt((int)i)).mVisible;
        }
    }

    @Override
    protected void processDialogCancel() {
        this.setVisible(false);
        this.mResult = null;
    }

    private void processColumnsShowHide(boolean pShow) {
        Object[] selected;
        for (Object aSelected : selected = this.mColumnHeaders.getSelectedValues()) {
            ((ColumnListElement)aSelected).mVisible = pShow;
        }
        ((ColumnListModel)this.mColumnHeaders.getModel()).notifyListeners();
    }

    private void processColumnToggle(int pIndex) {
        if (pIndex != -1) {
            ColumnListElement elem = (ColumnListElement)this.mColumnHeaders.getModel().getElementAt(pIndex);
            elem.mVisible = !elem.mVisible;
            ((ColumnListModel)this.mColumnHeaders.getModel()).notifyListeners(pIndex);
        }
    }

    private static class ColumnListCellRenderer
    extends DefaultListCellRenderer {
        private static Icon sIconVisible = null;
        private static Icon sIconInvisible = null;

        public ColumnListCellRenderer() {
            ColumnListCellRenderer.loadIcons();
            this.setVerticalTextPosition(0);
            this.setHorizontalTextPosition(4);
        }

        private static synchronized void loadIcons() {
            if (sIconVisible == null) {
                sIconVisible = SwingDecorator.getIcon("TABLEVIS_DIALOG_VISIBLE");
                sIconInvisible = SwingDecorator.getIcon("TABLEVIS_DIALOG_INVISIBLE");
            }
        }

        @Override
        public Component getListCellRendererComponent(JList pList, Object pValue, int pIndex, boolean pIsSelected, boolean pCellHasFocus) {
            ColumnListElement elem = (ColumnListElement)pValue;
            super.getListCellRendererComponent((JList<?>)pList, elem.mName, pIndex, pIsSelected, pCellHasFocus);
            this.setIcon(elem.mVisible ? sIconVisible : sIconInvisible);
            return this;
        }
    }

    private static class ColumnListElement {
        public String mName;
        public boolean mVisible;

        public ColumnListElement(String pName, boolean pVisible) {
            this.mName = pName;
            this.mVisible = pVisible;
        }

        public String toString() {
            return this.mName + " (" + (this.mVisible ? "" : "in") + "visible)";
        }
    }

    private static class ColumnListModel
    extends AbstractListModel {
        private List<ColumnListElement> mColumns;

        public ColumnListModel(Object[] pHeaders, boolean[] pVisible) {
            int count = pHeaders.length;
            this.mColumns = new ArrayList<ColumnListElement>(count);
            for (int i = 0; i < count; ++i) {
                this.mColumns.add(new ColumnListElement(pHeaders[i].toString(), pVisible[i]));
            }
        }

        @Override
        public Object getElementAt(int pIndex) {
            return this.mColumns.get(pIndex);
        }

        @Override
        public int getSize() {
            return this.mColumns.size();
        }

        public void notifyListeners() {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void notifyListeners(int pIndex) {
            this.fireContentsChanged(this, pIndex, pIndex);
        }
    }
}

