/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class OptimalColumnWidthSupport
extends MouseAdapter
implements PropertyChangeListener {
    private static final String TABLE_PROPERTY_TABLEHEADER = "tableHeader";
    private JTable mTable;

    public OptimalColumnWidthSupport(JTable pTable) {
        if (pTable == null) {
            throw new IllegalArgumentException("table must not be null");
        }
        this.mTable = pTable;
        pTable.getTableHeader().addMouseListener(this);
        pTable.addPropertyChangeListener(TABLE_PROPERTY_TABLEHEADER, this);
    }

    public void dispose() {
        this.mTable.getTableHeader().removeMouseListener(this);
        this.mTable.removePropertyChangeListener(TABLE_PROPERTY_TABLEHEADER, this);
        this.mTable = null;
    }

    public static void adjustToOptimalColumnWidth(JTable pTable) {
        if (pTable == null) {
            throw new IllegalArgumentException("table must not be null");
        }
        for (int i = 0; i < pTable.getColumnCount(); ++i) {
            OptimalColumnWidthSupport.adjustToOptimalColumnWidth(pTable, i);
        }
    }

    public static void adjustToOptimalColumnWidth(JTable pTable, int pViewIndex) {
        if (pTable == null) {
            throw new IllegalArgumentException("table must not be null");
        }
        if (pViewIndex >= 0 && pViewIndex < pTable.getColumnCount()) {
            OptimalColumnWidthSupport.adjustToOptimalColumnWidth(pTable, pTable.getColumnModel().getColumn(pViewIndex));
        }
    }

    private static void adjustToOptimalColumnWidth(JTable pTable, TableColumn pColumn) {
        int modelIndex = pColumn.getModelIndex();
        int viewIndex = pTable.convertColumnIndexToView(modelIndex);
        int margin = pTable.getColumnModel().getColumnMargin();
        TableCellRenderer r = pColumn.getHeaderRenderer();
        if (r == null) {
            r = pTable.getTableHeader().getDefaultRenderer();
        }
        int width = OptimalColumnWidthSupport.determineCellWidth(r, pTable, pColumn.getHeaderValue(), -1, viewIndex);
        TableModel model = pTable.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            width = Math.max(width, OptimalColumnWidthSupport.determineCellWidth(pTable.getCellRenderer(row, viewIndex), pTable, model.getValueAt(row, modelIndex), row, viewIndex));
        }
        width += margin;
        width = Math.max(width, pColumn.getMinWidth());
        width = Math.min(width, pColumn.getMaxWidth());
        pColumn.setWidth(width);
        pColumn.setPreferredWidth(width);
        pTable.revalidate();
        pTable.getTableHeader().resizeAndRepaint();
    }

    private static int determineCellWidth(TableCellRenderer pRenderer, JTable pTable, Object pValue, int pRow, int pColumn) {
        Component c = pRenderer.getTableCellRendererComponent(pTable, pValue, false, false, pRow, pColumn);
        return c.getPreferredSize().width;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pEvent) {
        ((JTableHeader)pEvent.getOldValue()).removeMouseListener(this);
        ((JTableHeader)pEvent.getNewValue()).addMouseListener(this);
    }

    @Override
    public void mousePressed(MouseEvent pEvent) {
        TableColumn column;
        if (pEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(pEvent) && (column = this.mTable.getTableHeader().getResizingColumn()) != null) {
            OptimalColumnWidthSupport.adjustToOptimalColumnWidth(this.mTable, column);
        }
    }
}

