/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.builder;

import java.awt.Component;
import java.awt.Container;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.state.State;
import net.sf.cuf.ui.SwingDecoratorFunctionality;
import net.sf.cuf.ui.builder.ConnectionBuilderDelegate;
import net.sf.cuf.ui.builder.DataBindingBuilderDelegate;
import net.sf.cuf.ui.builder.IconCache;
import net.sf.cuf.ui.builder.NonVisualBuilderDelegate;
import net.sf.cuf.ui.builder.StateHandlingBuilderDelegate;
import net.sf.cuf.ui.builder.VisualBuilderDelegate;
import net.sf.cuf.ui.builder.WidgetFactory;
import net.sf.cuf.ui.builder.WidgetFactoryRegistry;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Parent;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SwingXMLBuilder {
    public static final String SYSTEM_ID_1_4 = "http://www.sdm.com/dtd/xml2swing-1.4.dtd";
    private static final String SYSTEM_ID_1_4_FILE = "xml2swing-1.4.dtd";
    public static final String SYSTEM_ID_1_5 = "http://www.sdm.com/dtd/xml2swing-1.5.dtd";
    private static final String SYSTEM_ID_1_5_FILE = "xml2swing-1.5.dtd";
    public static final String SYSTEM_ID_1_6 = "http://www.sdm.com/dtd/xml2swing-1.6.dtd";
    private static final String SYSTEM_ID_1_6_FILE = "xml2swing-1.6.dtd";
    public static final String SYSTEM_ID_1_7 = "http://www.sdm.com/dtd/xml2swing-1.7.dtd";
    private static final String SYSTEM_ID_1_7_FILE = "xml2swing-1.7.dtd";
    public static final String SYSTEM_ID_1_8 = "http://www.sdm.com/dtd/xml2swing-1.8.dtd";
    private static final String SYSTEM_ID_1_8_FILE = "xml2swing-1.8.dtd";
    public static final String SYSTEM_ID_1_9 = "http://www.sdm.com/dtd/xml2swing-1.9.dtd";
    private static final String SYSTEM_ID_1_9_FILE = "xml2swing-1.9.dtd";
    public static final String SYSTEM_ID_2_0 = "http://www.sdm.com/dtd/xml2swing-2.0.dtd";
    private static final String SYSTEM_ID_2_0_FILE = "xml2swing-2.0.dtd";
    private static final boolean XML_VALIDATE = true;
    private static WidgetFactoryRegistry sWidgetFactoryRegistry;
    public static final String SEPARATOR = "/";
    public static final String OBJECT_ELEMENT = "object";
    public static final String ACTION_ELEMENT = "action";
    public static final String RESOURCE_ELEMENT = "resource";
    public static final String IS_TOGGLE_ELEMENT = "isToggle";
    public static final String DEFAULT_ID_RESOURCE = "ResourceBundle";
    public static final String FRAME_ELEMENT = "frame";
    public static final String DIALOG_ELEMENT = "dialog";
    public static final String PANEL_ELEMENT = "panel";
    public static final String ANY_ELEMENT = "any";
    public static final String BUTTON_ELEMENT = "button";
    public static final String LABEL_ELEMENT = "label";
    public static final String RADIOBUTTON_ELEMENT = "radiobutton";
    public static final String TOGGLEBUTTON_ELEMENT = "togglebutton";
    public static final String CHECKBOX_ELEMENT = "checkbox";
    public static final String TEXTFIELD_ELEMENT = "textfield";
    public static final String PASSWORDFIELD_ELEMENT = "passwordfield";
    public static final String TEXTAREA_ELEMENT = "textarea";
    public static final String COMBOBOX_ELEMENT = "combobox";
    public static final String SLIDER_ELEMENT = "slider";
    public static final String SPLITPANE_ELEMENT = "splitpane";
    public static final String SCROLLPANE_ELEMENT = "scrollpane";
    public static final String TABBEDPANE_ELEMENT = "tabbedpane";
    public static final String LIST_ELEMENT = "list";
    public static final String TABLE_ELEMENT = "table";
    public static final String TREE_ELEMENT = "tree";
    public static final String SEPARATOR_ELEMENT = "separator";
    public static final String SEPARATORPANEL_ELEMENT = "separatorpanel";
    public static final String MENUBAR_ELEMENT = "menubar";
    public static final String MENU_ELEMENT = "menu";
    public static final String MENU_ITEM_ELEMENT = "menuitem";
    public static final String TOOLBAR_ELEMENT = "toolbar";
    public static final String TOOLBAR_ITEM_ELEMENT = "toolbaritem";
    public static final String POPUP_ELEMENT = "popup";
    public static final String POPUPMENU_ELEMENT = "popupmenu";
    public static final String POPUP_ITEM_ELEMENT = "popupitem";
    public static final String BUILDER_ELEMENT = "builder";
    public static final String SPINNER_ELEMENT = "spinner";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String TEXT_ELEMENT = "text";
    public static final String TITLE_ELEMENT = "title";
    public static final String MNEMONIC_ELEMENT = "mnemonic";
    public static final String SHORTCUT_ELEMENT = "shortcut";
    public static final String ACCELERATOR_ELEMENT = "accelerator";
    public static final String TOOLTIP_ELEMENT = "tooltip";
    public static final String ICON_ELEMENT = "icon";
    public static final String COMBOITEM_ELEMENT = "comboitem";
    public static final String TABMAPPING_ELEMENT = "tabmapping";
    public static final String TABITEM_ELEMENT = "tabitem";
    public static final String POPUPREF_ELEMENT = "popupref";
    public static final String LAYOUTMANAGER_ELEMENT = "layoutmanager";
    public static final String CONSTRAINT_ELEMENT = "constraint";
    public static final String BORDER_ELEMENT = "border";
    public static final String DLU_ELEMENT = "dlu";
    public static final String MINSIZE_ELEMENT = "minsize";
    public static final String MAXSIZE_ELEMENT = "maxsize";
    public static final String PREFSIZE_ELEMENT = "prefsize";
    public static final String BUTTONACTION_ELEMENT = "buttonAction";
    public static final String COMBOBOXACTION_ELEMENT = "comboboxAction";
    public static final String TEXTFIELDACTION_ELEMENT = "textfieldAction";
    public static final String MENUACTION_ELEMENT = "menuAction";
    public static final String ACTIONACTION_ELEMENT = "actionAction";
    public static final String CARETACTION_ELEMENT = "caretAction";
    public static final String CHANGEACTION_ELEMENT = "changeAction";
    public static final String FOCUSACTION_ELEMENT = "focusAction";
    public static final String LISTSELECTIONACTION_ELEMENT = "listSelectionAction";
    public static final String PROPERTYCHANGEACTION_ELEMENT = "propertyChangeAction";
    public static final String TREESELECTIONACTION_ELEMENT = "treeSelectionAction";
    public static final String DOCUMENTACTION_ELEMENT = "documentAction";
    public static final String STATE_ELEMENT = "state";
    public static final String EXPRESSION_ELEMENT = "expression";
    public static final String STATEADAPTER_ELEMENT = "stateAdapter";
    public static final String SETSTATE_ELEMENT = "setstate";
    public static final String ADAPTEE_ELEMENT = "adaptee";
    public static final String VALUEHOLDER_ELEMENT = "valueholder";
    public static final String BUFFEREDHOLDER_ELEMENT = "bufferedholder";
    public static final String ASPECTADAPTER_ELEMENT = "aspectadapter";
    public static final String INDEXEDADAPTER_ELEMENT = "indexedadapter";
    public static final String INDEXINLIST_ELEMENT = "indexinlist";
    public static final String PROPERTIESADAPTER_ELEMENT = "propertiesadapter";
    public static final String TYPECONVERTER_ELEMENT = "typeconverter";
    public static final String FORMATCONVERTER_ELEMENT = "formatconverter";
    public static final String REGEXPCONVERTER_ELEMENT = "regexpconverter";
    public static final String CONVERTERINSYNC_ELEMENT = "converterinsync";
    public static final String SELECTIONINLIST_ELEMENT = "selectioninlist";
    public static final String MULTISELECTIONINLIST_ELEMENT = "multiselectioninlist";
    public static final String SETVALUE_ELEMENT = "setvalue";
    public static final String DOCUMENTADAPTER_ELEMENT = "documentadapter";
    public static final String BUTTONADAPTER_ELEMENT = "buttonadapter";
    public static final String COMBOBOXADAPTER_ELEMENT = "comboboxadapter";
    public static final String TABLEADAPTER_ELEMENT = "tableadapter";
    public static final String LISTADAPTER_ELEMENT = "listadapter";
    public static final String FILTERINGLISTADAPTER_ELEMENT = "filteringlistadapter";
    public static final String COLUMN_ELEMENT = "column";
    public static final String LOVMAPPER_ELEMENT = "lovmapper";
    public static final String TOOLTIPADAPTER_ELEMENT = "tooltipadapter";
    public static final String LABELADAPTER_ELEMENT = "labeladapter";
    public static final String LOVADAPTER_ELEMENT = "lovadapter";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String BOOLEAN_ATTRIBUTE = "boolean";
    public static final String INT_ATTRIBUTE = "int";
    public static final String REF_ATTRIBUTE = "ref";
    public static final String REF2_ATTRIBUTE = "ref2";
    public static final String ID_ATTRIBUTE = "id";
    public static final String MIN_ATTRIBUTE = "min";
    public static final String MAX_ATTRIBUTE = "max";
    public static final String ACTIONREF_ATTRIBUTE = "actionref";
    public static final String CLOSEACTION_ATTRIBUTE = "closeAction";
    public static final String ESCAPEACTION_ATTRIBUTE = "escapeAction";
    public static final String MODAL_ATTRIBUTE = "modal";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String CONSTANT_ATTRIBUTE = "constant";
    public static final String BASENAME_ATTRIBUTE = "basename";
    public static final String DEFAULT_ATTRIBUTE = "default";
    public static final String LANG_ATTRIBUTE = "lang";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ORIENTATION_ATTRIBUTE = "orientation";
    public static final String ONETOUCHEXPANDABLE_ATTRIBUTE = "oneTouchExpandable";
    public static final String TABPLACEMENT_ATTRIBUTE = "tabPlacement";
    public static final String SOURCE_ATTRIBUTE = "source";
    public static final String TARGET_ATTRIBUTE = "target";
    public static final String METHOD_ATTRIBUTE = "method";
    public static final String ENABLED_ATTRIBUTE = "enabled";
    public static final String SELECTED_ATTRIBUTE = "selected";
    public static final String VERTICAL_SCROLLBAR_ATTRIBUTE = "verticalScrollBar";
    public static final String HORIZONTAL_SCROLLBAR_ATTRIBUTE = "horizontalScrollBar";
    public static final String ALIGN_ATTRIBUTE = "align";
    public static final String LABELFOR_ATTRIBUTE = "labelfor";
    public static final String COMMAND_ATTRIBUTE = "command";
    public static final String DOCUMENT_ATTRIBUTE = "document";
    public static final String COLUMNS_ATTRIBUTE = "columns";
    public static final String MASKFORMAT_ATTRIBUTE = "maskFormat";
    public static final String DATEFORMAT_ATTRIBUTE = "dateFormat";
    public static final String NUMBERFORMAT_ATTRIBUTE = "numberFormat";
    public static final String EDITABLE_ATTRIBUTE = "editable";
    public static final String LINEWRAP_ATTRIBUTE = "linewrap";
    public static final String INVERT_ATTRIBUTE = "invert";
    public static final String SUBJECT_ATTRIBUTE = "subject";
    public static final String TRIGGER_ATTRIBUTE = "trigger";
    public static final String DEEPCOPY_ATTRIBUTE = "deepcopy";
    public static final String SETPREFIX_ATTRIBUTE = "setprefix";
    public static final String GETPREFIX_ATTRIBUTE = "getprefix";
    public static final String ACCESS_ATTRIBUTE = "access";
    public static final String ACCESSREF_ATTRIBUTE = "accessref";
    public static final String MODELREF_ATTRIBUTE = "modelref";
    public static final String PREF_WIDTH_ATTRIBUTE = "prefwidth";
    public static final String WIDGETREF_ATTRIBUTE = "widgetref";
    public static final String FORMAT_ATTRIBUTE = "format";
    public static final String BLOCK_ATTRIBUTE = "block";
    public static final String MODIFIERS_ATTRIBUTE = "modifiers";
    public static final String CONDITION_ATTRIBUTE = "condition";
    public static final String SORTABLE_ATTRIBUTE = "sortable";
    public static final String SORTMODELREF_ATTRIBUTE = "sortmodelref";
    public static final String COMPARATORCLASS_ATTRIBUTE = "comparatorclass";
    public static final String INITIAL_SORTING_COLUMN_ATTRIBUTE = "initialsortingcolumn";
    public static final String DEEP_ATTRIBUTE = "deep";
    public static final String LOVSREF_ATTRIBUTE = "lovsref";
    public static final String ITEMSREF_ATTRIBUTE = "itemsref";
    public static final String KEYSREF_ATTRIBUTE = "keysref";
    public static final String ITEMS_ATTRIBUTE = "items";
    public static final String KEYS_ATTRIBUTE = "keys";
    public static final String UNSELECTED_ATTRIBUTE = "unselected";
    public static final String IMPORTNAMES_ATTRIBUTE = "importNames";
    public static final String FORMBUILDER_PROPERTY = "formbuilder";
    public static final String TABMAPPING_PROPERTY = "tabmapping";
    public static final String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
    public static final String BUTTONGROUP_PROPERTY = "buttongroup";
    public static final String BUTTONGROUP_TRUE = "true";
    public static final String GRIDBAG_LAYOUT = "gridbag";
    public static final String NULL_LAYOUT = "null";
    public static final String BORDER_LAYOUT = "border";
    public static final String BOX_LAYOUT = "box";
    public static final String CARD_LAYOUT = "card";
    public static final String FLOW_LAYOUT = "flow";
    public static final String GRID_LAYOUT = "grid";
    public static final String TABLE_LAYOUT = "table";
    public static final String FORM_LAYOUT = "form";
    public static final String FLEXIBLEGRID_LAYOUT = "flexiblegrid";
    public static final String HGAP_ELEMENT = "hgap";
    public static final String VGAP_ELEMENT = "vgap";
    public static final String AXIS_ELEMENT = "axis";
    public static final String ALIGN_ELEMENT = "align";
    public static final String COLUMNS_ELEMENT = "columns";
    public static final String ROWS_ELEMENT = "rows";
    public static final String COLUMNGROUPS_ELEMENT = "columngroups";
    public static final String ROWGROUPS_ELEMENT = "rowgroups";
    public static final String LINEBREAK_ELEMENT = "linebreak";
    public static final String TABLELAYOUT_FILL = "fill";
    public static final String TABLELAYOUT_PREFERRED = "preferred";
    public static final String TABLELAYOUT_MINIMUM = "minimum";
    public static final String LINE_ATTRIBUTE = "line";
    public static final String ETCHED_ATTRIBUTE = "etched";
    public static final String BEVEL_ATTRIBUTE = "bevel";
    public static final String EMPTY_ATTRIBUTE = "empty";
    public static final String MATTE_ATTRIBUTE = "matte";
    public static final String COLOR_ELEMENT = "color";
    public static final String THICKNESS_ELEMENT = "thickness";
    public static final String SUNKEN_ATTRIBUTE = "sunken";
    public static final String SUNKEN_RAISED = "raised";
    public static final String SUNKEN_LOWERED = "lowered";
    public static final String SCROLLBAR_NEVER = "never";
    public static final String SCROLLBAR_ALWAYS = "always";
    public static final String SCROLLBAR_AS_NEEDED = "asNeeded";
    public static final String ROOT_ELEMENT = "xml2swing";
    public static final String NONVISUAL_ELEMENT = "nonvisual";
    public static final String VISUAL_ELEMENT = "visual";
    public static final String CONNECT_ELEMENT = "connect";
    public static final String STATEHANDLING_ELEMENT = "statehandling";
    public static final String DATABINDING_ELEMENT = "databinding";
    private Map<String, Component> mNameToVisual;
    private Map<String, Component> mShortNameToVisual;
    private Map<Component, String> mVisualToName;
    private Map<String, ? super Object> mNameToNonVisual;
    private IconCache mIconCache;
    private SwingDecoratorFunctionality mSwingDecorator;
    private boolean mSwingDecoratorCreated;
    private Locale mLocale;
    private boolean mIsDisposed;

    public SwingDecoratorFunctionality getSwingDecorator() {
        if (!this.mSwingDecoratorCreated) {
            this.mSwingDecoratorCreated = true;
            ArrayList<ResourceBundle> rbs = new ArrayList<ResourceBundle>();
            for (String string : this.getNameToNonVisual().keySet()) {
                String name = string;
                if (name == null || !name.startsWith(DEFAULT_ID_RESOURCE)) continue;
                ResourceBundle rb = (ResourceBundle)this.getNonVisualObject(name);
                rbs.add(rb);
            }
            if (!rbs.isEmpty()) {
                this.mSwingDecorator = new SwingDecoratorFunctionality(false, this.getIconCache());
                for (String string : rbs) {
                    this.mSwingDecorator.addBundle((ResourceBundle)((Object)string));
                }
            }
        }
        return this.mSwingDecorator;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public static WidgetFactoryRegistry getWidgetFactoryRegistry() {
        if (sWidgetFactoryRegistry == null) {
            sWidgetFactoryRegistry = new WidgetFactoryRegistry();
        }
        return sWidgetFactoryRegistry;
    }

    private SwingXMLBuilder(Locale pLocale) {
        if (pLocale == null) {
            pLocale = Locale.getDefault();
        }
        this.mNameToVisual = new HashMap<String, Component>();
        this.mShortNameToVisual = new HashMap<String, Component>();
        this.mVisualToName = new HashMap<Component, String>();
        this.mNameToNonVisual = new HashMap<String, Object>();
        this.mIconCache = new IconCache();
        this.mLocale = pLocale;
    }

    public static SwingXMLBuilder create(Element pElement) throws IllegalArgumentException {
        return SwingXMLBuilder.create(pElement, null, null);
    }

    public static SwingXMLBuilder create(Element pElement, Locale pLocale) throws IllegalArgumentException {
        return SwingXMLBuilder.create(pElement, pLocale, null);
    }

    public static SwingXMLBuilder create(Element pElement, Map<String, ? super Object> pNonVisual) throws IllegalArgumentException {
        return SwingXMLBuilder.create(pElement, null, pNonVisual);
    }

    public static SwingXMLBuilder create(Element pElement, Locale pLocale, Map<String, ? super Object> pNonVisual) throws IllegalArgumentException {
        Element stateElement;
        Element dataBindingElement;
        Element connectElement;
        Element visualElement;
        BuilderDelegate delegate;
        Element nonVisualElement;
        if (pElement == null) {
            throw SwingXMLBuilder.createException("null element");
        }
        if (!ROOT_ELEMENT.equals(pElement.getName())) {
            throw SwingXMLBuilder.createException("XML root element ist not xml2swing", pElement);
        }
        Element root = pElement;
        SwingXMLBuilder builder = new SwingXMLBuilder(pLocale);
        if (pNonVisual != null) {
            for (String o : pNonVisual.keySet()) {
                String key = o;
                if (key instanceof String) continue;
                if (key == null) {
                    throw SwingXMLBuilder.createException("key of the pNonVisual Map is not a string but null", pElement);
                }
                throw SwingXMLBuilder.createException("key of the pNonVisual Map is not a string but a " + key.getClass().getName(), pElement);
            }
            builder.mNameToNonVisual.putAll(pNonVisual);
        }
        if ((nonVisualElement = root.getChild(NONVISUAL_ELEMENT)) != null) {
            delegate = new NonVisualBuilderDelegate();
            delegate.build(builder, nonVisualElement);
        }
        if ((visualElement = root.getChild(VISUAL_ELEMENT)) != null) {
            delegate = new VisualBuilderDelegate();
            delegate.build(builder, visualElement);
        }
        if ((connectElement = root.getChild(CONNECT_ELEMENT)) != null) {
            delegate = new ConnectionBuilderDelegate();
            delegate.build(builder, connectElement);
        }
        if ((dataBindingElement = root.getChild(DATABINDING_ELEMENT)) != null) {
            delegate = new DataBindingBuilderDelegate();
            delegate.build(builder, dataBindingElement);
        }
        if ((stateElement = root.getChild(STATEHANDLING_ELEMENT)) != null) {
            delegate = new StateHandlingBuilderDelegate();
            delegate.build(builder, stateElement);
        }
        return builder;
    }

    public static SwingXMLBuilder create(InputStream pInputStream) throws IllegalArgumentException {
        return SwingXMLBuilder.create(pInputStream, null, null);
    }

    public static SwingXMLBuilder create(InputStream pInputStream, Locale pLocale) throws IllegalArgumentException {
        return SwingXMLBuilder.create(pInputStream, pLocale, null);
    }

    public static SwingXMLBuilder create(InputStream pInputStream, Map<String, ? super Object> pNonVisual) throws IllegalArgumentException {
        return SwingXMLBuilder.create(pInputStream, null, pNonVisual);
    }

    public static SwingXMLBuilder create(InputStream pInputStream, Locale pLocale, Map<String, ? super Object> pNonVisual) throws IllegalArgumentException {
        if (pInputStream == null) {
            throw SwingXMLBuilder.createException("null inputstream");
        }
        SAXBuilder builder = new SAXBuilder();
        builder.setEntityResolver(new EntityHelper());
        builder.setValidation(true);
        try {
            Document doc = builder.build(pInputStream);
            Element root = doc.getRootElement();
            return SwingXMLBuilder.create(root, pLocale, pNonVisual);
        }
        catch (Exception e) {
            throw SwingXMLBuilder.createException("could not parse document", e);
        }
    }

    public void dispose() {
        if (!this.mIsDisposed) {
            for (Object object : this.mNameToNonVisual.values()) {
                ValueModel valueModel;
                Object o = object;
                if (o instanceof State) {
                    State state = (State)o;
                    if (state.isDisposed()) continue;
                    state.dispose();
                    continue;
                }
                if (!(o instanceof ValueModel) || (valueModel = (ValueModel)o).isDisposed()) continue;
                valueModel.dispose();
            }
            this.mIconCache = null;
            this.mLocale = null;
            this.mNameToNonVisual.clear();
            this.mNameToNonVisual = null;
            this.mNameToVisual.clear();
            this.mNameToVisual = null;
            this.mShortNameToVisual.clear();
            this.mShortNameToVisual = null;
            this.mSwingDecorator = null;
            this.mSwingDecoratorCreated = false;
            this.mVisualToName.clear();
            this.mVisualToName = null;
            this.mIsDisposed = true;
        }
    }

    public Map<String, Component> getNameToVisual() {
        return this.mNameToVisual;
    }

    public Map<String, Component> getShortNameToVisual() {
        return this.mShortNameToVisual;
    }

    public Map<Component, String> getVisualToName() {
        return this.mVisualToName;
    }

    public Map<String, ? super Object> getNameToNonVisual() {
        return this.mNameToNonVisual;
    }

    public Container getContainerByName(String pName) {
        if (this.mIsDisposed) {
            throw new IllegalStateException("SwingXMLBuilder was disposed");
        }
        Object value = this.getVisualByName(pName);
        if (value instanceof Container) {
            return (Container)value;
        }
        return null;
    }

    public String getNameByContainer(Container pContainer) {
        if (this.mIsDisposed) {
            throw new IllegalStateException("SwingXMLBuilder was disposed");
        }
        return this.mVisualToName.get(pContainer);
    }

    public JComponent get(String pName) {
        return this.getComponentByName(pName);
    }

    public JComponent getByShortName(String pName) {
        if (this.mIsDisposed) {
            throw new IllegalStateException("SwingXMLBuilder was disposed");
        }
        Component value = this.mShortNameToVisual.get(pName);
        if (value instanceof JComponent) {
            return (JComponent)value;
        }
        return null;
    }

    public JComponent getComponentByName(String pName) {
        if (this.mIsDisposed) {
            throw new IllegalStateException("SwingXMLBuilder was disposed");
        }
        Object value = this.getVisualByName(pName);
        if (value instanceof JComponent) {
            return (JComponent)value;
        }
        return null;
    }

    public JComponent getComponentByAnyName(String pName) {
        JComponent back = this.getComponentByName(pName);
        if (back == null) {
            back = this.getByShortName(pName);
        }
        return back;
    }

    private Object getVisualByName(String pName) {
        String name;
        if (pName == null) {
            return null;
        }
        if (!pName.contains("..")) {
            name = pName;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(pName, SEPARATOR);
            ArrayList<String> list = new ArrayList<String>(tokenizer.countTokens());
            int stackCount = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ("..".equals(token)) {
                    if (--stackCount < 0) {
                        throw SwingXMLBuilder.createException(pName + ": contains more ..'s than elements");
                    }
                    list.remove(stackCount);
                    continue;
                }
                list.add(token);
                ++stackCount;
            }
            StringBuilder nameBuffer = new StringBuilder();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                nameBuffer.append((String)list.get(i));
                if (i >= n - 1) continue;
                nameBuffer.append(SEPARATOR);
            }
            name = nameBuffer.toString();
        }
        return this.mNameToVisual.get(name);
    }

    public String getNameByComponent(JComponent pComponent) {
        return this.getNameByContainer(pComponent);
    }

    public Object getNonVisualObject(String pName) {
        if (this.mIsDisposed) {
            throw new IllegalStateException("SwingXMLBuilder was disposed");
        }
        return this.mNameToNonVisual.get(pName);
    }

    public <T> T getNonVisualObject(String pName, Class<T> pType) {
        if (this.mIsDisposed) {
            throw new IllegalStateException("SwingXMLBuilder was disposed");
        }
        return pType.cast(this.mNameToNonVisual.get(pName));
    }

    public IconCache getIconCache() {
        if (this.mIsDisposed) {
            throw new IllegalStateException("SwingXMLBuilder was disposed");
        }
        return this.mIconCache;
    }

    public WidgetFactory getWidgetFactory() {
        if (this.mIsDisposed) {
            throw new IllegalStateException("SwingXMLBuilder was disposed");
        }
        return SwingXMLBuilder.getWidgetFactoryRegistry();
    }

    public static IllegalArgumentException createException(String pMessagePrefix) {
        return SwingXMLBuilder.createException(pMessagePrefix, null, null);
    }

    public static IllegalArgumentException createException(String pMessagePrefix, Exception pException) {
        return SwingXMLBuilder.createException(pMessagePrefix, pException, null);
    }

    public static IllegalArgumentException createException(String pMessagePrefix, Element pElement) {
        return SwingXMLBuilder.createException(pMessagePrefix, null, pElement);
    }

    public static IllegalArgumentException createException(String pMessagePrefix, Exception pException, Element pElement) {
        String CR = System.getProperty("line.separator");
        int INDENT = 4;
        String prefix = pMessagePrefix == null ? "no detailed message" : pMessagePrefix;
        StringBuilder sb = new StringBuilder(prefix);
        if (pElement != null) {
            ArrayList<Element> elementBacktrace = new ArrayList<Element>();
            Parent current = pElement;
            do {
                elementBacktrace.add((Element)current);
            } while ((current = current.getParent()) instanceof Element);
            sb.append(", XML Element backtrace:");
            sb.append(CR);
            int n = elementBacktrace.size();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)elementBacktrace.get(n - i - 1);
                String id = element.getAttributeValue(ID_ATTRIBUTE);
                for (int j = 0; j < i * INDENT; ++j) {
                    sb.append(' ');
                }
                sb.append(element.getName());
                if (id != null) {
                    sb.append(" (id=");
                    sb.append(id);
                    sb.append(')');
                } else {
                    sb.append(" (id unknown)");
                }
                if (i == n - 1) continue;
                sb.append(CR);
            }
        }
        IllegalArgumentException e = new IllegalArgumentException(sb.toString());
        if (pException != null) {
            e.initCause(pException);
        }
        return e;
    }

    public static boolean isSameLanguage(Element pElement, Locale pLocale) {
        String iso639Language = pLocale.getLanguage();
        Attribute elementLanguage = pElement.getAttribute(LANG_ATTRIBUTE);
        return elementLanguage == null || elementLanguage.getValue().equals(iso639Language);
    }

    public boolean isSameLanguage(Element pElement) {
        return SwingXMLBuilder.isSameLanguage(pElement, this.mLocale);
    }

    public String getTitle(Element pElement) {
        String title = null;
        for (Element o : pElement.getChildren(TITLE_ELEMENT)) {
            Element titleElement = o;
            if (!this.isSameLanguage(titleElement)) continue;
            title = titleElement.getText();
        }
        return title;
    }

    public static String getTitleDefaultLocale(Element pElement) {
        String title = null;
        for (Element o : pElement.getChildren(TITLE_ELEMENT)) {
            Element titleElement = o;
            if (!SwingXMLBuilder.isSameLanguage(titleElement, Locale.getDefault())) continue;
            title = titleElement.getText();
        }
        return title;
    }

    static Class<?> getClass(Element pElement) {
        String sourceClassName = pElement.getAttributeValue(CLASS_ATTRIBUTE);
        Class<?> sourceClass = null;
        try {
            if (sourceClassName != null) {
                sourceClass = Class.forName(sourceClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw SwingXMLBuilder.createException("class " + sourceClassName + " not found", e, pElement);
        }
        return sourceClass;
    }

    public static interface BuilderDelegate {
        public void build(SwingXMLBuilder var1, Element var2);
    }

    public static interface Backlink {
        public void setSwingXMLBuilder(SwingXMLBuilder var1);
    }

    private static class EntityHelper
    implements EntityResolver {
        private EntityHelper() {
        }

        @Override
        public InputSource resolveEntity(String pPublicId, String pSystemId) {
            switch (pSystemId) {
                case "http://www.sdm.com/dtd/xml2swing-2.0.dtd": {
                    return this.loadDtd(SwingXMLBuilder.SYSTEM_ID_2_0_FILE);
                }
                case "http://www.sdm.com/dtd/xml2swing-1.9.dtd": {
                    return this.loadDtd(SwingXMLBuilder.SYSTEM_ID_1_9_FILE);
                }
                case "http://www.sdm.com/dtd/xml2swing-1.8.dtd": {
                    return this.loadDtd(SwingXMLBuilder.SYSTEM_ID_1_8_FILE);
                }
                case "http://www.sdm.com/dtd/xml2swing-1.7.dtd": {
                    return this.loadDtd(SwingXMLBuilder.SYSTEM_ID_1_7_FILE);
                }
                case "http://www.sdm.com/dtd/xml2swing-1.6.dtd": {
                    return this.loadDtd(SwingXMLBuilder.SYSTEM_ID_1_6_FILE);
                }
                case "http://www.sdm.com/dtd/xml2swing-1.5.dtd": {
                    return this.loadDtd(SwingXMLBuilder.SYSTEM_ID_1_5_FILE);
                }
                case "http://www.sdm.com/dtd/xml2swing-1.4.dtd": {
                    return this.loadDtd(SwingXMLBuilder.SYSTEM_ID_1_4_FILE);
                }
            }
            return null;
        }

        private InputSource loadDtd(String pFileName) {
            InputStream dtd;
            InputSource back = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null && (dtd = loader.getResourceAsStream(pFileName)) != null) {
                back = new InputSource(dtd);
            }
            return back;
        }
    }
}

