/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class TitledSeparator
extends JPanel {
    private JLabel mTitleLabel;
    private static final int DEFAULT_POS = 7;

    public TitledSeparator() {
        this("", 7);
    }

    public TitledSeparator(String pTitle) {
        this(pTitle, 7);
    }

    public TitledSeparator(String pTitle, int pPos) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        if (pPos != 1) {
            JSeparator sep = new JSeparator();
            if (pPos > 0) {
                sep.setPreferredSize(new Dimension(pPos, sep.getPreferredSize().height));
                gbc.weightx = 0.0;
            } else {
                gbc.weightx = 1.0;
            }
            gbc.insets = new Insets(2, 0, 0, 3);
            this.add((Component)sep, gbc);
        }
        this.mTitleLabel = new JLabel(pTitle);
        Font f = UIManager.getFont("TitledBorder.font");
        Color c = UIManager.getColor("TitledBorder.titleColor");
        this.mTitleLabel.setFont(f);
        this.mTitleLabel.setForeground(c);
        this.add(this.mTitleLabel);
        if (pPos != -1) {
            JSeparator sep = new JSeparator();
            if (pPos < 0) {
                sep.setPreferredSize(new Dimension(-pPos, sep.getPreferredSize().height));
                gbc.weightx = 0.0;
            } else {
                gbc.weightx = 1.0;
            }
            gbc.insets = new Insets(2, 3, 0, 0);
            this.add((Component)sep, gbc);
        }
    }

    public String getText() {
        return this.mTitleLabel.getText();
    }

    public void setText(String pTitle) {
        this.mTitleLabel.setText(pTitle);
    }
}

