/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import javax.swing.RootPaneContainer;
import net.sf.cuf.fw2.GlassPane;
import net.sf.cuf.state.AbstractStateAdapter;
import net.sf.cuf.state.State;

public class SwingGlassPaneAdapter
extends AbstractStateAdapter {
    private Component mLastFocusOwner;
    private Cursor mLastCursor;

    public SwingGlassPaneAdapter() {
    }

    public SwingGlassPaneAdapter(State pState) {
        super(pState);
    }

    @Override
    protected void adjustInitialState(Object pTarget, boolean pEnabled) {
        if (pTarget instanceof RootPaneContainer && pTarget instanceof Window) {
            RootPaneContainer target = (RootPaneContainer)pTarget;
            if (!(target.getGlassPane() instanceof GlassPane)) {
                target.setGlassPane(new GlassPane());
            }
        } else {
            throw new IllegalStateException("we cant handle that object:" + pTarget);
        }
        this.processStateChange(pTarget, pEnabled);
    }

    @Override
    protected void processStateChange(Object pTarget, boolean pEnabled) {
        GlassPane glassPane = (GlassPane)((RootPaneContainer)pTarget).getGlassPane();
        Window target = (Window)pTarget;
        if (pEnabled && !glassPane.isVisible()) {
            this.mLastFocusOwner = target.getFocusOwner();
            this.mLastCursor = target.getCursor();
            target.setCursor(Cursor.getPredefinedCursor(3));
            glassPane.setVisible(true);
            glassPane.requestFocus();
        } else if (!pEnabled && glassPane.isVisible()) {
            if (this.mLastCursor != null) {
                target.setCursor(this.mLastCursor);
            }
            glassPane.setVisible(false);
            if (this.mLastFocusOwner != null) {
                this.mLastFocusOwner.requestFocus();
            }
        }
    }
}

