/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state.ui;

import java.awt.Color;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import net.sf.cuf.state.AbstractStateAdapter;
import net.sf.cuf.state.State;

public class SwingEditableAdapter
extends AbstractStateAdapter {
    private Color mNonEditableFieldBackground;
    private Color mEditableFieldBackground;

    public SwingEditableAdapter() {
        this.initColors();
    }

    public SwingEditableAdapter(State pState) {
        super(pState);
        this.initColors();
    }

    private void initColors() {
        this.mEditableFieldBackground = UIManager.getColor("TextField.background");
        this.mNonEditableFieldBackground = UIManager.getColor("TextField.inactiveBackground");
    }

    @Override
    protected void adjustInitialState(Object pTarget, boolean pEnabled) {
        this.processStateChange(pTarget, pEnabled);
    }

    @Override
    protected void processStateChange(Object pTarget, boolean pEnabled) {
        if (pTarget instanceof JTextComponent) {
            JTextComponent component = (JTextComponent)pTarget;
            component.setEditable(pEnabled);
            if (pTarget instanceof JTextArea) {
                JTextArea textArea = (JTextArea)pTarget;
                if (pEnabled) {
                    textArea.setBackground(this.mEditableFieldBackground);
                } else {
                    textArea.setBackground(this.mNonEditableFieldBackground);
                }
            }
        } else {
            throw new IllegalStateException("we cant handle that object:" + pTarget);
        }
    }
}

