/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state.ui;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.sf.cuf.state.State;
import net.sf.cuf.state.ui.AbstractSwingState;

public class SwingDocumentState
extends AbstractSwingState
implements State,
DocumentListener {
    private String mContent;
    private Document mDocument;

    public SwingDocumentState(JTextComponent pTextField) {
        this(pTextField, "");
    }

    public SwingDocumentState(JTextComponent pTextField, String pContent) {
        if (pTextField == null) {
            throw new IllegalArgumentException("textfield must not be null");
        }
        if (pContent == null) {
            throw new IllegalArgumentException("compare content must not be null");
        }
        this.mContent = pContent;
        this.mDocument = pTextField.getDocument();
        this.mIsEnabled = this.getInternalState();
        this.mName = pTextField.getName();
        if (this.mName == null) {
            this.mName = "";
        }
        this.mDocument.addDocumentListener(this);
    }

    public void setCompareContent(String pContent) {
        if (pContent == null) {
            throw new IllegalArgumentException("compare content must not be null");
        }
        this.mContent = pContent;
        this.checkStateChange();
    }

    public void updateCompareFromDocument() {
        try {
            this.mContent = this.mDocument.getText(0, this.mDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.checkStateChange();
    }

    @Override
    protected boolean getInternalState() {
        String documentContent = null;
        try {
            documentContent = this.mDocument.getText(0, this.mDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return this.mContent.equals(documentContent);
    }

    @Override
    protected void setReason() {
        this.mReason = this.mDocument;
    }

    @Override
    public void insertUpdate(DocumentEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    public void removeUpdate(DocumentEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    public void changedUpdate(DocumentEvent pEvent) {
        this.checkStateChange();
    }
}

