/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import net.sf.cuf.model.DelegateAccess;
import net.sf.cuf.model.SelectionInList;
import net.sf.cuf.model.ValueHolder;
import net.sf.cuf.model.ui.ColumnAlignmentRenderer;
import net.sf.cuf.model.ui.ListTableMapperBase;
import net.sf.cuf.model.ui.NewTableSorter;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class ListTableMapper
extends ListTableMapperBase {
    private List<Mapping> mColumnMapping = Collections.emptyList();
    private static final Class[] NO_CLASSES = new Class[0];
    private static final Object[] NO_OBJECTS = new Object[0];

    public ListTableMapper(JTable pTable, SelectionInList pValueModel, List<Mapping> pMapping, boolean pSortable) {
        this(pTable, pValueModel, pMapping, pSortable, -1);
    }

    public ListTableMapper(JTable pTable, SelectionInList pValueModel, List<Mapping> pMapping, boolean pSortable, int pColumnForInitialSorting) {
        this.init(pTable, pValueModel);
        this.setColumnMapping(pTable, pMapping, pSortable, pColumnForInitialSorting);
    }

    private void setColumnMapping(JTable pTable, List<Mapping> pMapping, boolean pSortable, int pColumnForInitialSorting) {
        if (pMapping == null) {
            throw new IllegalArgumentException("mapping must not be null");
        }
        ArrayList<Mapping> columnMapping = new ArrayList<Mapping>(pMapping.size());
        int n = pMapping.size();
        for (int i = 0; i < n; ++i) {
            Mapping mapping = pMapping.get(i);
            Mapping myMapping = new Mapping(mapping);
            columnMapping.add(myMapping);
        }
        this.mColumnMapping = columnMapping;
        TableModelEvent e = new TableModelEvent(this, -1);
        this.fireTableChanged(e);
        if (pSortable) {
            NewTableSorter sorter = new NewTableSorter(pTable.getModel());
            sorter.setTableHeader(pTable.getTableHeader());
            pTable.setModel(sorter);
            this.setIndexConverter(sorter);
            int n2 = pMapping.size();
            for (int i = 0; i < n2; ++i) {
                Mapping mapping = pMapping.get(i);
                if (mapping.getComparatorClass() == null) continue;
                try {
                    Comparator myComparator = (Comparator)mapping.getComparatorClass().getConstructor(NO_CLASSES).newInstance(NO_OBJECTS);
                    sorter.setColumnComparator(mapping.getColumnClass(), myComparator);
                    continue;
                }
                catch (Exception e1) {
                    throw SwingXMLBuilder.createException("could not instantiate ComparatorClass " + mapping.getComparatorClass() + " for " + mapping.getColumnClass(), e1);
                }
            }
            if (pColumnForInitialSorting >= 0 && pColumnForInitialSorting < sorter.getColumnCount()) {
                sorter.forceInitialSorting(pColumnForInitialSorting);
            }
        }
        int n3 = pMapping.size();
        for (int i = 0; i < n3; ++i) {
            Mapping mapping = pMapping.get(i);
            if (mapping.getColumnAlignment() != null) {
                pTable.getColumnModel().getColumn(i).setCellRenderer(new ColumnAlignmentRenderer(mapping.getColumnAlignment()));
            } else if (mapping.getColumnClass() != null && Boolean.class.isAssignableFrom(mapping.getColumnClass())) {
                pTable.getColumnModel().getColumn(i).setCellRenderer(new ColumnAlignmentRenderer("center"));
            } else if (mapping.getColumnClass() != null && (Number.class.isAssignableFrom(mapping.getColumnClass()) || Date.class.isAssignableFrom(mapping.getColumnClass()))) {
                pTable.getColumnModel().getColumn(i).setCellRenderer(new ColumnAlignmentRenderer("right"));
            } else {
                pTable.getColumnModel().getColumn(i).setCellRenderer(new ColumnAlignmentRenderer("left"));
            }
            if (mapping.getColumnPrefWidthIntValue() <= 0) continue;
            pTable.setAutoResizeMode(0);
            JTextField dummyTextField = new JTextField(mapping.getColumnPrefWidthIntValue());
            pTable.getColumnModel().getColumn(i).setPreferredWidth(dummyTextField.getPreferredSize().width);
        }
    }

    @Override
    public int getColumnCount() {
        return this.mColumnMapping.size();
    }

    @Override
    public String getColumnName(int pColumnIndex) {
        return this.mColumnMapping.get(pColumnIndex).getColumnTitle();
    }

    public Class getColumnClass(int pColumnIndex) {
        Class<Object> clazz = this.mColumnMapping.get(pColumnIndex).getColumnClass();
        if (clazz == null) {
            clazz = Object.class;
        }
        return clazz;
    }

    @Override
    public Object getValueAt(int pRowIndex, int pColumnIndex) {
        Mapping mapping = this.mColumnMapping.get(pColumnIndex);
        DelegateAccess valueModel = mapping.getValueModel();
        Object list = this.mSelectionInList.getValue();
        Object value = list.get(pRowIndex);
        Object back = valueModel.getValue(value);
        return back;
    }

    public Object getRawValueAt(int pRowIndex, int pColumnIndex) {
        Object list = this.mSelectionInList.getValue();
        Object value = list.get(pRowIndex);
        return value;
    }

    public Object getValueForSortingAt(int pRowIndex, int pColumnIndex) {
        Mapping mapping = this.mColumnMapping.get(pColumnIndex);
        DelegateAccess valueModelForSorting = mapping.getValueModelForSorting();
        Object list = this.mSelectionInList.getValue();
        Object value = list.get(pRowIndex);
        Object back = valueModelForSorting.getValue(value);
        return back;
    }

    public boolean isColumnSortable(int pColumnIndex) {
        Mapping mapping = this.mColumnMapping.get(pColumnIndex);
        return mapping.isSortable();
    }

    public static class Mapping {
        private String mColumnTitle = "";
        private String mColumnAlignment = null;
        private int mColumnPrefWidth = 0;
        private Class mColumnClass = null;
        private DelegateAccess mValueModel = new ValueHolder();
        private DelegateAccess mValueModelForSorting = null;
        private boolean mSortable = false;
        private Class mComparatorClass = null;

        public Mapping() {
        }

        public Mapping(Mapping pCopyFrom) {
            this(pCopyFrom.getColumnTitle(), pCopyFrom.getColumnAlignment(), pCopyFrom.getColumnPrefWidth(), pCopyFrom.getColumnClass(), pCopyFrom.getValueModel(), pCopyFrom.getValueModelForSorting(), pCopyFrom.isSortable(), pCopyFrom.getComparatorClassName());
        }

        public Mapping(String pColumnTitle) {
            this();
            this.setColumnTitle(pColumnTitle);
        }

        public Mapping(String pColumnTitle, Class pColumnClass) {
            this();
            this.setColumnTitle(pColumnTitle);
            this.setColumnClass(pColumnClass);
        }

        public Mapping(String pColumnTitle, Class pColumnClass, DelegateAccess pValueModel) {
            this();
            this.setColumnTitle(pColumnTitle);
            this.setColumnClass(pColumnClass);
            this.setValueModel(pValueModel);
        }

        public Mapping(String pColumnTitle, String pColumnAlignment, Class pColumnClass, DelegateAccess pValueModel) {
            this();
            this.setColumnTitle(pColumnTitle);
            this.setColumnAlignment(pColumnAlignment);
            this.setColumnClass(pColumnClass);
            this.setValueModel(pValueModel);
        }

        public Mapping(String pColumnTitle, String pColumnAlignment, String pColumnPrefWidth, Class pColumnClass, DelegateAccess pValueModel, DelegateAccess pValueModelForSorting, boolean pSortable, String pComparatorClassName) {
            this();
            this.setColumnTitle(pColumnTitle);
            this.setColumnAlignment(pColumnAlignment);
            this.setColumnPrefWidth(pColumnPrefWidth);
            this.setColumnClass(pColumnClass);
            this.setValueModel(pValueModel);
            this.setValueModelForSorting(pValueModelForSorting);
            this.setSortable(pSortable);
            this.setComparatorClassName(pComparatorClassName);
        }

        public String getColumnTitle() {
            return this.mColumnTitle;
        }

        private void setColumnTitle(String pColumnTitle) {
            if (pColumnTitle == null) {
                throw new IllegalArgumentException("column title must not be null");
            }
            this.mColumnTitle = pColumnTitle;
        }

        public String getColumnAlignment() {
            return this.mColumnAlignment;
        }

        private void setColumnAlignment(String pColumnAlignment) {
            this.mColumnAlignment = pColumnAlignment;
        }

        public String getColumnPrefWidth() {
            return Integer.toString(this.mColumnPrefWidth);
        }

        public int getColumnPrefWidthIntValue() {
            return this.mColumnPrefWidth;
        }

        private void setColumnPrefWidth(String pColumnPrefWidth) {
            if (pColumnPrefWidth == null) {
                this.mColumnPrefWidth = 0;
            } else {
                try {
                    this.mColumnPrefWidth = Integer.parseInt(pColumnPrefWidth);
                }
                catch (NumberFormatException e) {
                    throw SwingXMLBuilder.createException("could not parse prefWidth " + pColumnPrefWidth + " of column " + this.getColumnTitle(), e);
                }
            }
        }

        public Class getComparatorClass() {
            return this.mComparatorClass;
        }

        public String getComparatorClassName() {
            return this.mComparatorClass == null ? null : this.mComparatorClass.getName();
        }

        private void setComparatorClassName(String pComparatorClass) {
            if (pComparatorClass == null) {
                return;
            }
            try {
                this.mComparatorClass = Class.forName(pComparatorClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("class " + pComparatorClass + " not found");
            }
        }

        public Class getColumnClass() {
            return this.mColumnClass;
        }

        private void setColumnClass(Class pColumnClass) {
            this.mColumnClass = pColumnClass;
        }

        public DelegateAccess getValueModel() {
            return this.mValueModel;
        }

        private void setValueModel(DelegateAccess pValueModel) {
            if (pValueModel == null) {
                throw new IllegalArgumentException("value model must not be null");
            }
            this.mValueModel = pValueModel;
        }

        public DelegateAccess getValueModelForSorting() {
            return this.mValueModelForSorting;
        }

        public void setValueModelForSorting(DelegateAccess pValueModelForSorting) {
            this.mValueModelForSorting = pValueModelForSorting;
        }

        public boolean isSortable() {
            return this.mSortable;
        }

        private void setSortable(boolean pSortable) {
            this.mSortable = pSortable;
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (!(pOther instanceof Mapping)) {
                return false;
            }
            Mapping mapping = (Mapping)pOther;
            if (this.mColumnPrefWidth != mapping.mColumnPrefWidth) {
                return false;
            }
            if (this.mSortable != mapping.mSortable) {
                return false;
            }
            if (this.mColumnAlignment != null ? !this.mColumnAlignment.equals(mapping.mColumnAlignment) : mapping.mColumnAlignment != null) {
                return false;
            }
            if (this.mColumnClass != null ? !this.mColumnClass.equals(mapping.mColumnClass) : mapping.mColumnClass != null) {
                return false;
            }
            if (this.mColumnTitle != null ? !this.mColumnTitle.equals(mapping.mColumnTitle) : mapping.mColumnTitle != null) {
                return false;
            }
            if (this.mComparatorClass != null ? !this.mComparatorClass.equals(mapping.mComparatorClass) : mapping.mComparatorClass != null) {
                return false;
            }
            if (this.mValueModel != null ? !this.mValueModel.equals(mapping.mValueModel) : mapping.mValueModel != null) {
                return false;
            }
            return !(this.mValueModelForSorting != null ? !this.mValueModelForSorting.equals(mapping.mValueModelForSorting) : mapping.mValueModelForSorting != null);
        }

        public int hashCode() {
            int result = this.mColumnTitle != null ? this.mColumnTitle.hashCode() : 0;
            result = 29 * result + (this.mColumnAlignment != null ? this.mColumnAlignment.hashCode() : 0);
            result = 29 * result + this.mColumnPrefWidth;
            result = 29 * result + (this.mColumnClass != null ? this.mColumnClass.hashCode() : 0);
            result = 29 * result + (this.mValueModel != null ? this.mValueModel.hashCode() : 0);
            result = 29 * result + (this.mValueModelForSorting != null ? this.mValueModelForSorting.hashCode() : 0);
            result = 29 * result + (this.mSortable ? 1 : 0);
            result = 29 * result + (this.mComparatorClass != null ? this.mComparatorClass.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ListTableMapper.Mapping{ColumnTitle='" + this.mColumnTitle + '\'' + ", ColumnAlignment='" + this.mColumnAlignment + '\'' + ", ColumnPrefWidth=" + this.mColumnPrefWidth + ", ColumnClass=" + this.mColumnClass + ", ValueModel=" + this.mValueModel + ", ValueModelForSorting=" + this.mValueModelForSorting + ", Sortable=" + this.mSortable + ", ComparatorClass=" + this.mComparatorClass + '}';
        }
    }
}

