/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import net.sf.cuf.model.DelegateAccess;
import net.sf.cuf.model.SelectionInList;

public class FilteringListModelAdapter {
    private final JComboBox mComboBox;
    private final SelectionInList mSil;
    private final DelegateAccess mDelegateAccess;
    private final JTextComponent mTextComponent;
    private final FilteringListModel mModel;
    private boolean mInSelectionChange;
    private final FilteringDocument mDocument;

    public FilteringListModelAdapter(JComboBox pComboBox, SelectionInList pSil, DelegateAccess pDelegateAccess) {
        this(pComboBox, pSil, pDelegateAccess, true);
    }

    public FilteringListModelAdapter(JComboBox pComboBox, SelectionInList pSil, DelegateAccess pDelegateAccess, final boolean pDeleteInvalidFilterAfterFocusLost) {
        if (pComboBox == null) {
            throw new IllegalArgumentException("pComboBox must not be null");
        }
        if (pSil == null) {
            throw new IllegalArgumentException("pComboBox must not be null");
        }
        this.mComboBox = pComboBox;
        this.mSil = pSil;
        this.mDelegateAccess = pDelegateAccess;
        this.mTextComponent = (JTextComponent)this.mComboBox.getEditor().getEditorComponent();
        this.mComboBox.setEditable(true);
        this.mModel = new FilteringListModel();
        this.mComboBox.setModel(this.mModel);
        this.mDocument = new FilteringDocument();
        this.mTextComponent.setDocument(this.mDocument);
        this.mSil.onChangeSend(this, "vmDataChanged");
        this.mSil.selectionHolder().onChangeSend(this, "vmSelectionChanged");
        this.mTextComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent pE) {
                if (pDeleteInvalidFilterAfterFocusLost) {
                    FilteringListModelAdapter.this.deleteFilteringTextIfInvalid();
                }
                FilteringListModelAdapter.this.mComboBox.hidePopup();
                FilteringListModelAdapter.this.mModel.setPattern("");
                FilteringListModelAdapter.this.mDocument.clearFlags();
            }
        });
    }

    public int getIndexByObject(Object pItem) {
        Object list = this.mSil.getValue();
        if (list == null) {
            return -1;
        }
        int index = -1;
        if (this.mDelegateAccess != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object item = this.mDelegateAccess.getValue(list.get(i));
                if (pItem != item && (pItem == null || !pItem.equals(item))) continue;
                index = i;
                break;
            }
        } else {
            index = list.indexOf(pItem);
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmDataChanged(ChangeEvent pEvent) {
        if (this.mInSelectionChange) {
            return;
        }
        this.mInSelectionChange = true;
        try {
            if ("".equals(this.mTextComponent.getText())) {
                this.mModel.setPattern("");
            } else {
                this.mTextComponent.setText("");
            }
            this.mModel.fireContentChanged();
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmSelectionChanged(ChangeEvent pEvent) {
        if (this.mInSelectionChange) {
            return;
        }
        int index = this.mSil.selectionHolder().intValue();
        this.mInSelectionChange = true;
        try {
            Object list = this.mSil.getValue();
            if (list == null) {
                return;
            }
            if (index == -1) {
                this.mTextComponent.setText("");
            } else {
                Object selectedItem = list.get(index);
                Object value = this.getValueFromObject(selectedItem);
                if (value != null) {
                    this.mTextComponent.setText(value.toString());
                } else {
                    this.mTextComponent.setText("");
                }
            }
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    private Object getValueFromObject(Object pObject) {
        if (this.mDelegateAccess == null) {
            return pObject;
        }
        return this.mDelegateAccess.getValue(pObject);
    }

    public void deleteFilteringTextIfInvalid() {
        String text = this.mTextComponent.getText();
        int index = this.getIndexByObject(text);
        if (index < 0) {
            this.mModel.setSelectedItem(null);
        }
    }

    public void setPattern(String pPattern) {
        this.mModel.setPattern(pPattern);
    }

    private class FilteringListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 1L;
        private final FilteredData mData = new FilteredData();

        public FilteringListModel() {
            this.setPattern("");
        }

        public void setPattern(String pPattern) {
            List pre = this.mData.getData();
            this.mData.setPattern(pPattern);
            List post = this.mData.getData();
            if (!pre.equals(post) && FilteringListModelAdapter.this.mComboBox.isPopupVisible()) {
                FilteringListModelAdapter.this.mComboBox.hidePopup();
                FilteringListModelAdapter.this.mComboBox.showPopup();
            }
        }

        @Override
        public Object getSelectedItem() {
            int index = FilteringListModelAdapter.this.mSil.getIndex();
            if (index < 0 || FilteringListModelAdapter.this.mSil.getValue() == null) {
                return null;
            }
            Object object = FilteringListModelAdapter.this.mSil.getValue().get(index);
            return FilteringListModelAdapter.this.getValueFromObject(object);
        }

        @Override
        public void setSelectedItem(Object pAnObject) {
            int index = FilteringListModelAdapter.this.getIndexByObject(pAnObject);
            FilteringListModelAdapter.this.mSil.selectionHolder().setValue(index);
            if (index >= 0) {
                FilteringListModelAdapter.this.mTextComponent.setText((String)this.getSelectedItem());
            } else {
                FilteringListModelAdapter.this.mTextComponent.setText("");
            }
        }

        @Override
        public int getSize() {
            return this.mData.getData().size();
        }

        @Override
        public Object getElementAt(int pIndex) {
            return this.mData.getData().get(pIndex);
        }

        public void fireContentChanged() {
            this.fireContentsChanged(this, -1, -1);
        }

        class FilteredData {
            private List mFilteredData;

            FilteredData() {
            }

            List getData() {
                return this.mFilteredData == null ? Collections.EMPTY_LIST : this.mFilteredData;
            }

            void setPattern(String pPattern) {
                String patternLc = pPattern == null ? "" : pPattern.toLowerCase();
                this.filter(patternLc);
            }

            private void filter(String pPattern) {
                this.mFilteredData = new ArrayList();
                Object list = FilteringListModelAdapter.this.mSil.getValue();
                if (list == null) {
                    return;
                }
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    Object value = FilteringListModelAdapter.this.getValueFromObject(i.next());
                    this.filterElement(pPattern, value);
                }
            }

            private void filterElement(String pPattern, Object pObject) {
                if (pObject == null) {
                    if ("".equals(pPattern)) {
                        this.mFilteredData.add(null);
                    }
                } else {
                    String string = pObject.toString();
                    if (string.toLowerCase().contains(pPattern)) {
                        this.mFilteredData.add(string);
                    }
                }
            }
        }
    }

    private class FilteringDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private boolean mArrowKeyPressed = false;
        private boolean mEnterKeyPressed = false;

        public FilteringDocument() {
            FilteringListModelAdapter.this.mTextComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent pE) {
                    int key;
                    if (pE.getKeyCode() > 48) {
                        FilteringListModelAdapter.this.mComboBox.showPopup();
                    }
                    if ((key = pE.getKeyCode()) == 38 || key == 40) {
                        FilteringDocument.this.mArrowKeyPressed = true;
                    }
                    if (key == 10) {
                        FilteringDocument.this.mEnterKeyPressed = true;
                    }
                }
            });
        }

        @Override
        public void remove(int pOffs, int pLen) throws BadLocationException {
            super.remove(pOffs, pLen);
            if (this.mArrowKeyPressed) {
                this.mArrowKeyPressed = false;
            } else {
                this.updateModel();
            }
        }

        @Override
        public void insertString(int pOffs, String pStr, AttributeSet pA) throws BadLocationException {
            super.insertString(pOffs, pStr, pA);
            if (this.mEnterKeyPressed) {
                this.mEnterKeyPressed = false;
                return;
            }
            String text = this.getText(0, this.getLength());
            if (this.mArrowKeyPressed) {
                FilteringListModelAdapter.this.mModel.setSelectedItem(text);
                this.mArrowKeyPressed = false;
            } else if (!text.equals(FilteringListModelAdapter.this.mModel.getSelectedItem())) {
                this.updateModel();
            }
        }

        private void updateModel() {
            String textToMatch = FilteringListModelAdapter.this.mTextComponent.getText();
            FilteringListModelAdapter.this.mModel.setPattern(textToMatch);
        }

        public void clearFlags() {
            this.mEnterKeyPressed = false;
            this.mArrowKeyPressed = false;
        }
    }
}

