/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.sf.cuf.model.ValueModel;

public class DocumentAdapter
implements ChangeListener,
DocumentListener {
    private ValueModel<String> mValueModel;
    private Document mDocument;
    private JTextComponent mTextComponent;
    private boolean mInSetValue;
    private boolean mInInsertString;

    public DocumentAdapter(ValueModel<String> pValueModel, JTextComponent pTextField) {
        if (pTextField == null) {
            throw new IllegalArgumentException("text field must not be null");
        }
        this.init(pValueModel, pTextField.getDocument(), pTextField);
    }

    public DocumentAdapter(ValueModel<String> pValueModel, Document pDocument) {
        this.init(pValueModel, pDocument, null);
    }

    private void init(ValueModel<String> pValueModel, Document pDocument, JTextComponent pTextComponent) {
        if (pValueModel == null) {
            throw new IllegalArgumentException("value model must not be null");
        }
        if (pDocument == null) {
            throw new IllegalArgumentException("text document must not be null");
        }
        this.mValueModel = pValueModel;
        this.mDocument = pDocument;
        this.mTextComponent = pTextComponent;
        this.mInSetValue = false;
        this.mInInsertString = false;
        this.propagateStateChange(this.getVMValue());
        this.mValueModel.addChangeListener(this);
        this.mDocument.addDocumentListener(this);
    }

    public JTextComponent getTextComponent() {
        return this.mTextComponent;
    }

    private String getVMValue() {
        String value = this.mValueModel.getValue();
        String content = value != null ? value : "";
        return content;
    }

    @Override
    public void stateChanged(ChangeEvent pEvent) {
        if (this.mInSetValue) {
            return;
        }
        this.propagateStateChange(this.getVMValue());
    }

    @Override
    public void insertUpdate(DocumentEvent pEvent) {
        this.propagateDocumentChange();
    }

    @Override
    public void removeUpdate(DocumentEvent pEvent) {
        this.propagateDocumentChange();
    }

    @Override
    public void changedUpdate(DocumentEvent pEvent) {
        this.propagateDocumentChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateStateChange(String pContent) {
        if (this.mDocument.getLength() == 0 && pContent.length() == 0) {
            return;
        }
        try {
            this.mInInsertString = true;
            if (this.mDocument instanceof AbstractDocument) {
                ((AbstractDocument)this.mDocument).replace(0, this.mDocument.getLength(), pContent, null);
            } else {
                this.mDocument.remove(0, this.mDocument.getLength());
                this.mDocument.insertString(0, pContent, null);
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            this.mInInsertString = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateDocumentChange() {
        if (this.mInInsertString) {
            return;
        }
        String documentContent = null;
        try {
            documentContent = this.mDocument.getText(0, this.mDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        try {
            this.mInSetValue = true;
            this.mValueModel.setValue(documentContent);
        }
        finally {
            this.mInSetValue = false;
        }
    }
}

