/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.state;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.state.MutableState;
import net.sf.cuf.state.SimpleState;

public class ValueState
extends SimpleState
implements MutableState,
ChangeListener {
    private static final String TRUE = Boolean.TRUE.toString();
    private ValueModel<?> mModel;
    private Boolean mMeaningOfNull;

    public ValueState(ValueModel<?> pModel) {
        if (pModel == null) {
            throw new IllegalStateException("model must not be null");
        }
        this.mModel = pModel;
        this.propagateModelToState();
        this.mModel.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean pEnabled) {
        this.mInSetEnabled = true;
        try {
            this.mModel.setValue(pEnabled);
            super.setEnabled(pEnabled);
        }
        finally {
            this.mInSetEnabled = false;
        }
    }

    @Override
    public void setEnabled(boolean pEnabled, Object pReason) {
        this.mModel.setValue(pEnabled);
        super.setEnabled(pEnabled, pReason);
    }

    @Override
    public void reset() {
        this.mModel.setValue(null);
        super.reset();
    }

    public void setMeaningOfNull(Boolean pMeaningOfNull) {
        this.mMeaningOfNull = pMeaningOfNull;
        this.propagateModelToState();
    }

    public Boolean getMeaningOfNull() {
        return this.mMeaningOfNull;
    }

    @Override
    public void stateChanged(ChangeEvent pEvent) {
        if (this.inSetEnabled()) {
            return;
        }
        this.propagateModelToState();
    }

    private void propagateModelToState() {
        if (this.mModel.getValue() == null) {
            if (this.mMeaningOfNull == null) {
                super.reset();
            } else {
                super.setEnabled(this.mMeaningOfNull, this.mModel);
            }
        } else {
            super.setEnabled(this.getModelAsBoolean(this.mModel), this.mModel);
        }
    }

    private boolean getModelAsBoolean(ValueModel<?> pModel) {
        Object value = pModel.getValue();
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return value.toString().equals(TRUE);
    }
}

