/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.state;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.state.AbstractState;

public class MinMaxState
extends AbstractState
implements ChangeListener {
    private ValueModel<?> mTrigger;
    private Integer mMinValue;
    private Integer mMaxValue;
    private boolean mInvert;

    public MinMaxState(ValueModel<?> pTrigger, Integer pMinValue, Integer pMaxValue, boolean pInvert) {
        if (pTrigger == null) {
            throw new IllegalArgumentException("pTrigger must not be null");
        }
        this.mTrigger = pTrigger;
        this.mMinValue = pMinValue;
        this.mMaxValue = pMaxValue;
        this.mInvert = pInvert;
        this.mIsInitialized = true;
        this.mTrigger.addChangeListener(this);
        this.checkTriggerValue();
    }

    @Override
    public void stateChanged(ChangeEvent pE) {
        this.checkTriggerValue();
    }

    private void checkTriggerValue() {
        boolean newIsEnabled = false;
        Object value = this.mTrigger.getValue();
        if (value instanceof CharSequence) {
            int length = ((CharSequence)value).length();
            newIsEnabled = this.isEnabled(length);
        } else if (value instanceof Number) {
            int intValue = ((Number)value).intValue();
            newIsEnabled = this.isEnabled(intValue);
        } else if (value == null) {
            newIsEnabled = this.isEnabled(0);
        }
        if (newIsEnabled != this.mIsEnabled) {
            this.mIsEnabled = newIsEnabled;
            this.fireStateChanged();
        }
    }

    private boolean isEnabled(int pValue) {
        boolean isEnabled = this.mMinValue != null && this.mMaxValue != null ? pValue >= this.mMinValue && pValue <= this.mMaxValue : (this.mMinValue != null && pValue >= this.mMinValue ? true : this.mMaxValue != null && pValue <= this.mMaxValue);
        if (this.mInvert) {
            return !isEnabled;
        }
        return isEnabled;
    }
}

