/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.AbstractValueModel;
import net.sf.cuf.model.UnmodifiableValueHolder;
import net.sf.cuf.model.ValueHolder;
import net.sf.cuf.model.ValueModel;

public class MultiSelectionInList
extends AbstractValueModel
implements ChangeListener {
    public static final Comparator EQUALS_COMPARATOR = new Comparator(){

        public int compare(Object pO1, Object pO2) {
            if (pO1 == null) {
                if (pO2 == null) {
                    return 0;
                }
                return -1;
            }
            if (pO2 == null) {
                return -1;
            }
            if (pO1.equals(pO2)) {
                return 0;
            }
            return -1;
        }
    };
    public static final Comparator IDENTITY_COMPARATOR = new Comparator(){

        public int compare(Object pO1, Object pO2) {
            if (pO1 == pO2) {
                return 0;
            }
            return -1;
        }
    };
    private ValueModel mListHolder;
    private UnmodifiableValueHolder mSelectedIndexSetValueHolder;
    private UnmodifiableValueHolder mSelectedValuesHolder;
    private SortedSet mSelectedIndexSet;
    private List mSelectedValuesList;
    private Comparator mSelectionComparator;

    public MultiSelectionInList(ValueModel pListHolder) {
        if (pListHolder == null) {
            throw new IllegalArgumentException("list holder must not be null");
        }
        Object value = pListHolder.getValue();
        if (value != null && !(value instanceof List)) {
            throw new IllegalArgumentException("list holder value must be null or a List not a " + value.getClass().getName());
        }
        this.init(pListHolder);
    }

    public MultiSelectionInList(List pList) {
        this.init(new ValueHolder<List>(pList));
    }

    private void init(ValueModel pListHolder) {
        this.mListHolder = pListHolder;
        this.mSelectedValuesList = new ArrayList();
        this.mSelectedIndexSet = new TreeSet();
        this.mSelectedValuesHolder = new UnmodifiableValueHolder<SelectedValuesListAdapter>(new SelectedValuesListAdapter());
        this.mSelectedIndexSetValueHolder = new UnmodifiableValueHolder<SelectedIndexSetAdapter>(new SelectedIndexSetAdapter());
        this.mSelectionComparator = IDENTITY_COMPARATOR;
        this.mListHolder.addChangeListener(this);
    }

    public void setSelectionComparator(Comparator pSelectionComparator) {
        this.mSelectionComparator = pSelectionComparator == null ? IDENTITY_COMPARATOR : pSelectionComparator;
    }

    @Override
    public boolean isEditable() {
        return this.mListHolder.isEditable();
    }

    @Override
    public void dispose() {
        if (this.mListHolder != null && !this.mListHolder.isDisposed()) {
            this.mListHolder.removeChangeListener(this);
        }
        this.mSelectedIndexSetValueHolder.dispose();
        this.mSelectedValuesHolder.dispose();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object pValue, boolean pIsSetForced) {
        this.checkDisposed();
        if (this.isInSetValue()) {
            return;
        }
        if (pValue != null && !(pValue instanceof List)) {
            throw new IllegalArgumentException("value must be a List or null, not a " + pValue.getClass().getName());
        }
        this.setInSetValue(true, pIsSetForced);
        try {
            this.mListHolder.setValue(pValue);
            this.updateSelectionForBaseListChange();
            this.fireStateChanged();
        }
        finally {
            this.setInSetValue(false, false);
        }
    }

    @Override
    public Object getValue() {
        try {
            this.checkDisposed();
        }
        catch (IllegalStateException e) {
            return null;
        }
        return this.mListHolder.getValue();
    }

    @Override
    public void stateChanged(ChangeEvent pEvent) {
        this.checkDisposed();
        if (this.isInSetValue()) {
            return;
        }
        this.updateSelectionForBaseListChange();
        this.fireStateChanged();
    }

    protected List getBaseList() {
        Object value = this.mListHolder.getValue();
        if (value != null && !(value instanceof List)) {
            throw new IllegalArgumentException("value must be a List, not a " + value.getClass().getName());
        }
        return (List)value;
    }

    private void updateSelectionForBaseListChange() {
        if (this.mSelectedValuesList.isEmpty()) {
            return;
        }
        List baseList = this.getBaseList();
        boolean selectedValuesChanged = false;
        boolean selectedIndexChanged = false;
        if (baseList == null || baseList.isEmpty()) {
            this.clearSelection();
            return;
        }
        int lastMatchingOffset = 0;
        int[] oldSelectedIndexes = new int[this.mSelectedIndexSet.size()];
        int i = 0;
        Iterator iter = this.mSelectedIndexSet.iterator();
        while (iter.hasNext()) {
            oldSelectedIndexes[i] = (Integer)iter.next();
            ++i;
        }
        int[] newSelectedIndexes = new int[oldSelectedIndexes.length];
        for (i = 0; i < oldSelectedIndexes.length; ++i) {
            Object selectedValueToFind = this.mSelectedValuesList.get(i);
            newSelectedIndexes[i] = this.findIndex(selectedValueToFind, baseList, oldSelectedIndexes[i], oldSelectedIndexes[i] + lastMatchingOffset);
            if (newSelectedIndexes[i] >= 0) {
                this.mSelectedValuesList.set(i, baseList.get(newSelectedIndexes[i]));
            }
            if (newSelectedIndexes[i] == oldSelectedIndexes[i]) continue;
            selectedIndexChanged = true;
            if (newSelectedIndexes[i] < 0) continue;
            lastMatchingOffset = newSelectedIndexes[i] - oldSelectedIndexes[i];
        }
        if (selectedIndexChanged) {
            for (i = oldSelectedIndexes.length - 1; i >= 0; --i) {
                if (oldSelectedIndexes[i] == newSelectedIndexes[i]) continue;
                this.mSelectedIndexSet.remove(new Integer(oldSelectedIndexes[i]));
                if (newSelectedIndexes[i] >= 0) continue;
                selectedValuesChanged = true;
                this.mSelectedValuesList.remove(i);
            }
            for (i = 0; i < oldSelectedIndexes.length; ++i) {
                if (oldSelectedIndexes[i] == newSelectedIndexes[i] || newSelectedIndexes[i] < 0) continue;
                this.mSelectedIndexSet.add(newSelectedIndexes[i]);
            }
            ArrayList<Integer> newSelectedIndexesList = new ArrayList<Integer>();
            for (i = 0; i < newSelectedIndexes.length; ++i) {
                if (newSelectedIndexes[i] < 0) continue;
                newSelectedIndexesList.add(newSelectedIndexes[i]);
            }
            if (newSelectedIndexesList.size() != this.mSelectedValuesList.size()) {
                throw new RuntimeException("Encountered illegal situation during processing of change event (1): list sizes do not match: " + newSelectedIndexesList.size() + " vs." + this.mSelectedValuesList.size());
            }
            if (newSelectedIndexesList.size() != this.mSelectedIndexSet.size()) {
                throw new RuntimeException("Encountered illegal situation during processing of change event (2): list sizes do not match: " + newSelectedIndexesList.size() + " vs." + this.mSelectedIndexSet.size());
            }
            newSelectedIndexes = new int[newSelectedIndexesList.size()];
            for (i = 0; i < newSelectedIndexes.length; ++i) {
                newSelectedIndexes[i] = (Integer)newSelectedIndexesList.get(i);
            }
            boolean reorderNecessary = false;
            for (i = 1; i < newSelectedIndexesList.size(); ++i) {
                if (newSelectedIndexes[i - 1] < newSelectedIndexes[i]) continue;
                reorderNecessary = true;
                break;
            }
            if (reorderNecessary) {
                this.sortListWithIndex(newSelectedIndexes, this.mSelectedValuesList);
                selectedValuesChanged = true;
            }
        }
        if (selectedIndexChanged) {
            this.mSelectedIndexSetValueHolder.signalExternalUpdate();
        }
        if (selectedValuesChanged) {
            this.mSelectedValuesHolder.signalExternalUpdate();
        }
    }

    void sortListWithIndex(int[] pReferenceOrder, List pList) {
        if (pReferenceOrder.length != pList.size()) {
            throw new IllegalArgumentException("pList must have the same size as pReferenceOrder: " + pList.size() + " vs. " + pReferenceOrder.length);
        }
        final IdentityHashMap referenceMap = new IdentityHashMap();
        for (int i = 0; i < pReferenceOrder.length; ++i) {
            referenceMap.put(pList.get(i), pReferenceOrder[i]);
        }
        Collections.sort(pList, new Comparator(){

            public int compare(Object pObj1, Object pObj2) {
                return ((Integer)referenceMap.get(pObj1)).compareTo((Integer)referenceMap.get(pObj2));
            }
        });
    }

    private int findIndex(Object pValueToFind, List pList, int pFirstIndexHint, int pSecondIndexHint) {
        if (pFirstIndexHint >= 0 && pFirstIndexHint < pList.size() && 0 == this.mSelectionComparator.compare(pList.get(pFirstIndexHint), pValueToFind)) {
            return pFirstIndexHint;
        }
        if (pSecondIndexHint != pFirstIndexHint && pSecondIndexHint >= 0 && pSecondIndexHint < pList.size() && 0 == this.mSelectionComparator.compare(pList.get(pSecondIndexHint), pValueToFind)) {
            return pSecondIndexHint;
        }
        for (int i = 0; i < pList.size(); ++i) {
            if (0 != this.mSelectionComparator.compare(pList.get(i), pValueToFind)) continue;
            return i;
        }
        return -1;
    }

    public ValueModel getSelectedIndexSetValueModel() {
        return this.mSelectedIndexSetValueHolder;
    }

    public ValueModel getSelectedValuesHolder() {
        return this.mSelectedValuesHolder;
    }

    public int determineIndexInBaseList(Object pElement) {
        List baseList = this.getBaseList();
        if (baseList == null || baseList.isEmpty()) {
            return -1;
        }
        return this.findIndex(pElement, baseList, -1, -1);
    }

    public void selectAll() {
        this.mSelectedValuesList.clear();
        this.mSelectedIndexSet.clear();
        List baseList = this.getBaseList();
        for (int i = 0; i < baseList.size(); ++i) {
            this.mSelectedIndexSet.add(i);
            this.mSelectedValuesList.add(baseList.get(i));
        }
        this.signalSelectionChange();
    }

    public void clearSelection() {
        if (this.mSelectedValuesList.isEmpty()) {
            return;
        }
        this.mSelectedValuesList.clear();
        this.mSelectedIndexSet.clear();
        this.signalSelectionChange();
    }

    private void signalSelectionChange() {
        this.mSelectedIndexSetValueHolder.signalExternalUpdate();
        this.mSelectedValuesHolder.signalExternalUpdate();
    }

    public void setSelectedIndexes(Collection pSelectedIndexes) {
        ((SelectedIndexSetAdapter)this.mSelectedIndexSetValueHolder.getValue()).setSelectedIndexes(pSelectedIndexes);
    }

    public void setSelectedElements(Collection pSelectedValues) {
        ((SelectedValuesListAdapter)this.mSelectedValuesHolder.getValue()).setSelectedElements(pSelectedValues);
    }

    private class SelectedIndexSetAdapter
    implements SortedSet,
    Serializable {
        private static final long serialVersionUID = 6728079508990733354L;

        private SelectedIndexSetAdapter() {
        }

        public Comparator comparator() {
            return MultiSelectionInList.this.mSelectedIndexSet.comparator();
        }

        protected void setSelectedIndexes(Collection pSelectedIndexes) {
            int indexInBaseList;
            MultiSelectionInList.this.mSelectedIndexSet.clear();
            MultiSelectionInList.this.mSelectedValuesList.clear();
            List baseList = MultiSelectionInList.this.getBaseList();
            for (Object element : pSelectedIndexes) {
                if (element == null) {
                    throw new IllegalArgumentException("elements in index collection must not be null");
                }
                if (!(element instanceof Integer)) {
                    throw new IllegalArgumentException("elements in index collection must be integers, not a " + element.getClass().getName());
                }
                indexInBaseList = (Integer)element;
                if (indexInBaseList < 0 || indexInBaseList >= baseList.size()) {
                    throw new IndexOutOfBoundsException("index must be in range from 0 to " + (baseList.size() - 1) + ": " + indexInBaseList);
                }
                MultiSelectionInList.this.mSelectedIndexSet.add(element);
            }
            for (Object aMSelectedIndexSet : MultiSelectionInList.this.mSelectedIndexSet) {
                indexInBaseList = (Integer)aMSelectedIndexSet;
                MultiSelectionInList.this.mSelectedValuesList.add(baseList.get(indexInBaseList));
            }
            MultiSelectionInList.this.signalSelectionChange();
        }

        public Object first() {
            return MultiSelectionInList.this.mSelectedIndexSet.first();
        }

        public SortedSet headSet(Object pToElement) {
            return Collections.unmodifiableSortedSet(MultiSelectionInList.this.mSelectedIndexSet.headSet(pToElement));
        }

        public Object last() {
            return MultiSelectionInList.this.mSelectedIndexSet.last();
        }

        public SortedSet subSet(Object pFromElement, Object pToElement) {
            return Collections.unmodifiableSortedSet(MultiSelectionInList.this.mSelectedIndexSet.subSet(pFromElement, pToElement));
        }

        public SortedSet tailSet(Object pFromElement) {
            return Collections.unmodifiableSortedSet(MultiSelectionInList.this.mSelectedIndexSet.tailSet(pFromElement));
        }

        @Override
        public boolean add(Object pObject) {
            boolean changed = this.addIndexInternal(pObject);
            if (changed) {
                MultiSelectionInList.this.signalSelectionChange();
            }
            return changed;
        }

        private boolean addIndexInternal(Object pObject) {
            int index;
            if (pObject == null) {
                throw new IllegalArgumentException("pObject must not be null");
            }
            if (!(pObject instanceof Integer)) {
                throw new IllegalArgumentException("pObject must be an integer, not a " + pObject.getClass().getName());
            }
            List baseList = MultiSelectionInList.this.getBaseList();
            int indexInBaseList = (Integer)pObject;
            if (indexInBaseList < 0 || indexInBaseList >= baseList.size()) {
                throw new IndexOutOfBoundsException("index must be in range from 0 to " + (baseList.size() - 1) + ": " + indexInBaseList);
            }
            if (MultiSelectionInList.this.mSelectedIndexSet.contains(pObject)) {
                return false;
            }
            int indexInOurList = 0;
            Iterator iter = MultiSelectionInList.this.mSelectedIndexSet.iterator();
            while (iter.hasNext() && (index = ((Integer)iter.next()).intValue()) <= indexInBaseList) {
                ++indexInOurList;
            }
            MultiSelectionInList.this.mSelectedValuesList.add(indexInOurList, baseList.get(indexInBaseList));
            MultiSelectionInList.this.mSelectedIndexSet.add(indexInBaseList);
            return true;
        }

        @Override
        public boolean addAll(Collection pCollection) {
            boolean changed = false;
            for (Object element : pCollection) {
                changed |= this.addIndexInternal(element);
            }
            if (changed) {
                MultiSelectionInList.this.signalSelectionChange();
            }
            return changed;
        }

        @Override
        public void clear() {
            MultiSelectionInList.this.clearSelection();
        }

        @Override
        public boolean contains(Object pObject) {
            return MultiSelectionInList.this.mSelectedIndexSet.contains(pObject);
        }

        @Override
        public boolean containsAll(Collection pCollection) {
            return MultiSelectionInList.this.mSelectedIndexSet.containsAll(pCollection);
        }

        @Override
        public boolean isEmpty() {
            return MultiSelectionInList.this.mSelectedIndexSet.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                private Iterator mSelectedIndexIterator;
                private Object mLastReturnedValue;
                {
                    this.mSelectedIndexIterator = MultiSelectionInList.this.mSelectedIndexSet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.mSelectedIndexIterator.hasNext();
                }

                public Object next() {
                    this.mLastReturnedValue = this.mSelectedIndexIterator.next();
                    return this.mLastReturnedValue;
                }

                @Override
                public void remove() {
                    if (this.mLastReturnedValue == null) {
                        throw new IllegalStateException("must call next() before remove()");
                    }
                    SelectedIndexSetAdapter.this.remove(this.mLastReturnedValue);
                    this.mLastReturnedValue = null;
                }
            };
        }

        @Override
        public boolean remove(Object pObject) {
            boolean changed = this.removeElementInternal(pObject);
            if (changed) {
                MultiSelectionInList.this.signalSelectionChange();
            }
            return changed;
        }

        private boolean removeElementInternal(Object pElement) {
            int index;
            if (!MultiSelectionInList.this.mSelectedIndexSet.contains(pElement)) {
                return false;
            }
            int indexInBaseList = (Integer)pElement;
            int indexInOurList = 0;
            Iterator iter = MultiSelectionInList.this.mSelectedIndexSet.iterator();
            while (iter.hasNext() && (index = ((Integer)iter.next()).intValue()) != indexInBaseList) {
                ++indexInOurList;
            }
            MultiSelectionInList.this.mSelectedIndexSet.remove(pElement);
            MultiSelectionInList.this.mSelectedValuesList.remove(indexInOurList);
            return true;
        }

        @Override
        public boolean removeAll(Collection pCollection) {
            boolean changed = false;
            for (Object element : pCollection) {
                changed |= this.removeElementInternal(element);
            }
            if (changed) {
                MultiSelectionInList.this.signalSelectionChange();
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection pCollection) {
            boolean changed = false;
            ArrayList indexesToRemove = new ArrayList(MultiSelectionInList.this.mSelectedIndexSet);
            Iterator iter = indexesToRemove.iterator();
            while (iter.hasNext()) {
                Integer index = (Integer)iter.next();
                if (!pCollection.contains(index)) continue;
                iter.remove();
            }
            for (Object anIndexesToRemove : indexesToRemove) {
                Integer index = (Integer)anIndexesToRemove;
                changed |= this.removeElementInternal(index);
            }
            if (changed) {
                MultiSelectionInList.this.signalSelectionChange();
            }
            return changed;
        }

        @Override
        public int size() {
            return MultiSelectionInList.this.mSelectedIndexSet.size();
        }

        @Override
        public Object[] toArray() {
            return MultiSelectionInList.this.mSelectedIndexSet.toArray();
        }

        @Override
        public Object[] toArray(Object[] pArray) {
            return MultiSelectionInList.this.mSelectedIndexSet.toArray(pArray);
        }

        @Override
        public boolean equals(Object pObj) {
            return MultiSelectionInList.this.mSelectedIndexSet.equals(pObj);
        }

        public String toString() {
            return MultiSelectionInList.this.mSelectedIndexSet.toString();
        }

        private Object writeReplace() {
            return new TreeSet(this);
        }
    }

    private class SelectedValuesListAdapter
    implements List,
    Serializable {
        private static final long serialVersionUID = 1250229061027889954L;

        private SelectedValuesListAdapter() {
        }

        protected void setSelectedElements(Collection pSelectedValues) {
            MultiSelectionInList.this.mSelectedIndexSet.clear();
            MultiSelectionInList.this.mSelectedValuesList.clear();
            if (pSelectedValues.isEmpty()) {
                MultiSelectionInList.this.signalSelectionChange();
            } else {
                this.addAll(pSelectedValues);
            }
        }

        @Override
        public boolean add(Object pObject) {
            boolean changed = this.addElementInternal(pObject);
            if (changed) {
                MultiSelectionInList.this.signalSelectionChange();
            }
            return changed;
        }

        public void add(int pIndex, Object pElement) {
            this.add(pElement);
        }

        @Override
        public boolean addAll(Collection pCollection) {
            boolean changed = false;
            for (Object element : pCollection) {
                changed |= this.addElementInternal(element);
            }
            if (changed) {
                MultiSelectionInList.this.signalSelectionChange();
            }
            return changed;
        }

        public boolean addAll(int pIndex, Collection pCollection) {
            return this.addAll(pCollection);
        }

        private boolean addElementInternal(Object pElement) {
            int index;
            int indexInBaseList = MultiSelectionInList.this.determineIndexInBaseList(pElement);
            if (indexInBaseList < 0) {
                throw new IllegalArgumentException("the new element must be in the base list as reference to be added to the selected list: " + pElement);
            }
            if (MultiSelectionInList.this.mSelectedIndexSet.contains(new Integer(indexInBaseList))) {
                return false;
            }
            Object elementInBaseList = MultiSelectionInList.this.getBaseList().get(indexInBaseList);
            int indexInOurList = 0;
            Iterator iter = MultiSelectionInList.this.mSelectedIndexSet.iterator();
            while (iter.hasNext() && (index = ((Integer)iter.next()).intValue()) <= indexInBaseList) {
                ++indexInOurList;
            }
            MultiSelectionInList.this.mSelectedValuesList.add(indexInOurList, elementInBaseList);
            MultiSelectionInList.this.mSelectedIndexSet.add(indexInBaseList);
            return true;
        }

        @Override
        public void clear() {
            MultiSelectionInList.this.clearSelection();
        }

        @Override
        public boolean contains(Object pObject) {
            return MultiSelectionInList.this.mSelectedValuesList.contains(pObject);
        }

        @Override
        public boolean containsAll(Collection pCollection) {
            return MultiSelectionInList.this.mSelectedValuesList.containsAll(pCollection);
        }

        public Object get(int pIndex) {
            return MultiSelectionInList.this.mSelectedValuesList.get(pIndex);
        }

        @Override
        public int indexOf(Object pObject) {
            return MultiSelectionInList.this.mSelectedValuesList.indexOf(pObject);
        }

        @Override
        public boolean isEmpty() {
            return MultiSelectionInList.this.mSelectedValuesList.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                private Iterator mSelectedValuesIterator;
                private Object mLastReturnedValue;
                {
                    this.mSelectedValuesIterator = MultiSelectionInList.this.mSelectedValuesList.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.mSelectedValuesIterator.hasNext();
                }

                public Object next() {
                    this.mLastReturnedValue = this.mSelectedValuesIterator.next();
                    return this.mLastReturnedValue;
                }

                @Override
                public void remove() {
                    if (this.mLastReturnedValue == null) {
                        throw new IllegalStateException("must call next() before remove()");
                    }
                    SelectedValuesListAdapter.this.remove(this.mLastReturnedValue);
                    this.mLastReturnedValue = null;
                }
            };
        }

        @Override
        public int lastIndexOf(Object pObject) {
            return MultiSelectionInList.this.mSelectedValuesList.lastIndexOf(pObject);
        }

        public ListIterator listIterator() {
            throw new UnsupportedOperationException("ListIterators are not (yet) supported in the selected values list");
        }

        public ListIterator listIterator(int pIndex) {
            throw new UnsupportedOperationException("ListIterators are not (yet) supported in the selected values list");
        }

        @Override
        public boolean remove(Object pObject) {
            boolean changed = this.removeElementInternal(pObject);
            if (changed) {
                MultiSelectionInList.this.signalSelectionChange();
            }
            return changed;
        }

        public Object remove(int pIndex) {
            Object object = MultiSelectionInList.this.mSelectedValuesList.get(pIndex);
            this.removeElementInternalAtIndex(pIndex);
            MultiSelectionInList.this.signalSelectionChange();
            return object;
        }

        @Override
        public boolean removeAll(Collection pCollection) {
            boolean changed = false;
            for (Object element : pCollection) {
                changed |= this.removeElementInternal(element);
            }
            if (changed) {
                MultiSelectionInList.this.signalSelectionChange();
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection pCollection) {
            ArrayList collectionAsList = pCollection instanceof List ? (ArrayList)pCollection : new ArrayList(pCollection);
            boolean changed = false;
            for (int testIndex = MultiSelectionInList.this.mSelectedValuesList.size() - 1; testIndex >= 0; --testIndex) {
                if (MultiSelectionInList.this.findIndex(MultiSelectionInList.this.mSelectedValuesList.get(testIndex), collectionAsList, -1, -1) >= 0) continue;
                changed = true;
                this.removeElementInternalAtIndex(testIndex);
            }
            if (changed) {
                MultiSelectionInList.this.signalSelectionChange();
            }
            return changed;
        }

        public Object set(int pIndex, Object pElement) {
            Object previousObject = MultiSelectionInList.this.mSelectedValuesList.get(pIndex);
            if (previousObject == pElement) {
                return pElement;
            }
            this.removeElementInternalAtIndex(pIndex);
            this.addElementInternal(pElement);
            MultiSelectionInList.this.signalSelectionChange();
            return previousObject;
        }

        private boolean removeElementInternal(Object pElement) {
            int ourIndex = MultiSelectionInList.this.findIndex(pElement, MultiSelectionInList.this.mSelectedValuesList, -1, -1);
            if (ourIndex < 0) {
                return false;
            }
            this.removeElementInternalAtIndex(ourIndex);
            return true;
        }

        private void removeElementInternalAtIndex(int pIndex) {
            if (pIndex < 0 || pIndex >= MultiSelectionInList.this.mSelectedValuesList.size()) {
                throw new IndexOutOfBoundsException("index must be in range from 0 to " + (MultiSelectionInList.this.mSelectedValuesList.size() - 1) + ": " + pIndex);
            }
            Iterator iter = MultiSelectionInList.this.mSelectedIndexSet.iterator();
            for (int i = 0; i <= pIndex; ++i) {
                iter.next();
            }
            iter.remove();
            MultiSelectionInList.this.mSelectedValuesList.remove(pIndex);
        }

        @Override
        public int size() {
            return MultiSelectionInList.this.mSelectedValuesList.size();
        }

        public List subList(int pFromIndex, int pToIndex) {
            return Collections.unmodifiableList(MultiSelectionInList.this.mSelectedValuesList.subList(pFromIndex, pToIndex));
        }

        @Override
        public Object[] toArray() {
            return MultiSelectionInList.this.mSelectedValuesList.toArray();
        }

        @Override
        public Object[] toArray(Object[] pArray) {
            return MultiSelectionInList.this.mSelectedValuesList.toArray(pArray);
        }

        @Override
        public boolean equals(Object pObj) {
            return MultiSelectionInList.this.mSelectedValuesList.equals(pObj);
        }

        @Override
        public int hashCode() {
            return MultiSelectionInList.this.mSelectedValuesList.hashCode();
        }

        public String toString() {
            return MultiSelectionInList.this.mSelectedValuesList.toString();
        }

        private Object writeReplace() {
            return new ArrayList(this);
        }
    }
}

