/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvview.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.table.AbstractTableModel;
import net.sf.cuf.csvview.util.FilteredTableModel;

public class TreeTableModel
extends AbstractTableModel
implements FilteredTableModel {
    private int mRowCount;
    private int mFilteredRows;
    private int[] mFilteredRowsIndexMapper;
    private Object[][] mData;
    public static final String[] HEADER = new String[]{"path", "name", "size", "last modified"};
    public static final Class<?>[] HEADERCLASS = new Class[]{String.class, String.class, Long.class, Date.class};

    public TreeTableModel(File pRootNode) {
        if (pRootNode == null) {
            throw new IllegalArgumentException("root file node must not be null");
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        this.traverseTree(pRootNode, rows);
        this.mFilteredRows = this.mRowCount = rows.size();
        this.mData = new Object[this.mRowCount][HEADER.length];
        this.mFilteredRowsIndexMapper = new int[this.mRowCount];
        for (int i = 0; i < this.mRowCount; ++i) {
            this.mFilteredRowsIndexMapper[i] = i;
            Object[] row = (Object[])rows.get(i);
            System.arraycopy(row, 0, this.mData[i], 0, row.length);
        }
    }

    private void traverseTree(File pCurrentNode, List<Object[]> pRows) {
        File[] children;
        if (!pCurrentNode.canRead() || !pCurrentNode.exists()) {
            return;
        }
        Object[] row = new Object[HEADER.length];
        row[0] = pCurrentNode.getPath();
        row[1] = pCurrentNode.getName();
        row[2] = pCurrentNode.length();
        row[3] = new Date(pCurrentNode.lastModified());
        pRows.add(row);
        if (pCurrentNode.isDirectory() && (children = pCurrentNode.listFiles()) != null) {
            for (File child : children) {
                this.traverseTree(child, pRows);
            }
        }
    }

    @Override
    public int getAllRowsCount() {
        return this.mRowCount;
    }

    @Override
    public int getColumnCount() {
        return HEADER.length;
    }

    @Override
    public Class<?> getColumnClass(int pColumnIndex) {
        return HEADERCLASS[pColumnIndex];
    }

    @Override
    public int getRowCount() {
        return this.mFilteredRows;
    }

    @Override
    public Object getValueAt(int pRowIndex, int pColumnIndex) {
        int realIndex = this.mFilteredRowsIndexMapper[pRowIndex];
        Object[] row = this.mData[realIndex];
        return row[pColumnIndex];
    }

    @Override
    public String getColumnName(int pColumnIndex) {
        return HEADER[pColumnIndex];
    }

    @Override
    public boolean filter(String pFilterExpression) {
        Pattern filter;
        try {
            filter = Pattern.compile(pFilterExpression, 2);
        }
        catch (PatternSyntaxException ignored) {
            return false;
        }
        Matcher match = filter.matcher("");
        this.mFilteredRows = 0;
        block2: for (int i = 0; i < this.mData.length; ++i) {
            Object[] row;
            for (Object column : row = this.mData[i]) {
                match.reset(column.toString());
                if (!match.find()) continue;
                this.mFilteredRowsIndexMapper[this.mFilteredRows] = i;
                ++this.mFilteredRows;
                continue block2;
            }
        }
        this.fireTableDataChanged();
        return true;
    }

    @Override
    public void filterReset() {
        this.mFilteredRows = this.mRowCount;
        for (int i = 0; i < this.mRowCount; ++i) {
            this.mFilteredRowsIndexMapper[i] = i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setFirstRowIsHeader(boolean pFirstRowIsHeader) {
    }
}

