/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvview;

import com.jgoodies.looks.Options;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.sf.cuf.csvview.Version;
import net.sf.cuf.fw.AbstractSwingApplication;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.EDTExceptionUtil;
import net.sf.cuf.fw2.UserProperties;
import net.sf.cuf.model.ValueHolder;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.ui.SwingDecorator;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class Main
extends AbstractSwingApplication {
    private Main() {
    }

    @Override
    public void doStart(String[] pArgs) {
        super.doStart(pArgs);
        StringBuilder version = new StringBuilder("error report for csvview");
        version.append(", Version ");
        version.append(Version.VERSION);
        version.append(" (");
        version.append(Version.DATE);
        version.append(')');
        EDTExceptionUtil.setVersion(".csvview", version.toString());
        this.loadProperties();
        SwingDecorator.addBundle("i18n/sortingtable");
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        System.setProperty("sun.awt.noerasebackground", "true");
        System.setProperty("sun.awt.keepWorkingSetOnMinimize", "true");
        if (System.getProperty("os.name", "unknown").toLowerCase().contains("linux")) {
            System.setProperty("swing.aatext", "true");
        }
        ArrayList<String> plafDisplayNames = new ArrayList<String>();
        ArrayList<String> plafClassnNames = new ArrayList<String>();
        plafDisplayNames.add("System");
        plafClassnNames.add(UIManager.getSystemLookAndFeelClassName());
        plafDisplayNames.add("Swing Metal");
        plafClassnNames.add("javax.swing.plaf.metal.MetalLookAndFeel");
        plafDisplayNames.add("JGoodies Windows");
        plafClassnNames.add("com.jgoodies.looks.windows.WindowsLookAndFeel");
        plafDisplayNames.add("JGoodies Plastic XP");
        plafClassnNames.add("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        plafDisplayNames.add("JGoodies Plastic");
        plafClassnNames.add("com.jgoodies.looks.plastic.PlasticLookAndFeel");
        plafDisplayNames.add("JGoodies Plastic 3D");
        plafClassnNames.add("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        String plafClassName = this.getProperty("plaf", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        if (!plafClassnNames.contains(plafClassName)) {
            plafClassName = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
        }
        ValueHolder<String> selectedPlafClassName = new ValueHolder<String>(plafClassName);
        this.getAppModel().put("plafItems", plafDisplayNames);
        this.getAppModel().put("plafKeys", plafClassnNames);
        this.getAppModel().put("PlafSelection", selectedPlafClassName);
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        Options.setDefaultIconSize(new Dimension(18, 18));
        try {
            UIManager.setLookAndFeel((String)selectedPlafClassName.getValue());
        }
        catch (Exception ignored) {
            // empty catch block
        }
        ArrayList<String> inputKeys = new ArrayList<String>();
        inputKeys.add("file");
        inputKeys.add("url");
        inputKeys.add("tree");
        String csvSource = this.getProperty("csvSource", "file");
        if (!inputKeys.contains(csvSource)) {
            csvSource = "file";
        }
        ValueHolder<String> inputSelection = new ValueHolder<String>(csvSource);
        this.getAppModel().put("inputItems", inputKeys);
        this.getAppModel().put("inputKeys", inputKeys);
        this.getAppModel().put("InputSelection", inputSelection);
        List<String> encodingKeys = Arrays.asList("Cp1252", "UTF-8", "ISO-8859-1");
        String encoding = this.getProperty("encoding", "Cp1252");
        if (!encodingKeys.contains(encoding)) {
            encoding = "Cp1252";
        }
        ValueHolder<String> encodingSelection = new ValueHolder<String>(encoding);
        this.getAppModel().put("encodingItems", encodingKeys);
        this.getAppModel().put("encodingKeys", encodingKeys);
        this.getAppModel().put("EncodingSelection", encodingSelection);
        HashMap<String, ? super Object> nonVisual = new HashMap<String, Object>();
        nonVisual.put("AppProperties", this.getProperties());
        nonVisual.putAll(this.getAppModel());
        String fileName = "csvview.xml";
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        InputStream input = loader.getResourceAsStream(fileName);
        SwingXMLBuilder builder = SwingXMLBuilder.create(input, nonVisual);
        this.getAppModel().put("FirstRowIsHeader", builder.getNonVisualObject("FirstRowIsHeader"));
        this.getAppModel().put("CSVSeparator", builder.getNonVisualObject("CSVSeparator"));
        this.getAppModel().put("EncodingSelection", builder.getNonVisualObject("EncodingSelection"));
        this.getAppModel().put("CopyWholeRow", builder.getNonVisualObject("CopyWholeRow"));
        final Dc dc = (Dc)builder.getNonVisualObject("MainDc");
        final HashMap<String, Main> args = new HashMap<String, Main>();
        args.put("Application", this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dc.init(null, args);
            }
        });
    }

    @Override
    public void doStop() {
        this.saveProperties();
        System.exit(0);
    }

    private void loadProperties() {
        try {
            this.mAppProperties = UserProperties.read(null, null, ".csvview_user.properties");
        }
        catch (Exception e) {
            System.err.println("will ignore loadProperties problems: " + e);
        }
    }

    private void saveProperties() {
        try {
            ValueModel inputSelection = (ValueModel)this.getAppModel().get("InputSelection");
            String csvSource = (String)inputSelection.getValue();
            this.setProperty("csvSource", csvSource);
            ValueModel plafSelection = (ValueModel)this.getAppModel().get("PlafSelection");
            String defaultLAF = (String)plafSelection.getValue();
            this.setProperty("plaf", defaultLAF);
            ValueModel encodingSelection = (ValueModel)this.getAppModel().get("EncodingSelection");
            String encoding = (String)encodingSelection.getValue();
            this.setProperty("encoding", encoding);
            UserProperties.write(this.mAppProperties, null, ".csvview_user.properties");
        }
        catch (Exception e) {
            System.err.println("will ignore saveProperties problems: " + e);
        }
    }

    public static void main(String[] pArgs) {
        Main app = new Main();
        app.doStart(pArgs);
    }
}

