/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.AbstractButton;
import javax.swing.Icon;

class TableHeaderIcon
implements Icon {
    private boolean mAscending = true;
    protected static final Icon ICON_SORT_ASCENDING = new TableHeaderIcon(true);
    protected static final Icon ICON_SORT_DESCENDING = new TableHeaderIcon(false);

    private TableHeaderIcon(boolean pAscending) {
        this.mAscending = pAscending;
    }

    public static Icon getIconSortAscending() {
        return ICON_SORT_ASCENDING;
    }

    public static Icon getIconSortDescending() {
        return ICON_SORT_DESCENDING;
    }

    @Override
    public int getIconHeight() {
        return 12;
    }

    @Override
    public int getIconWidth() {
        return 8;
    }

    @Override
    public void paintIcon(Component pComponent, Graphics pGraphics, int pX, int pY) {
        boolean selected = ((AbstractButton)pComponent).isSelected() || ((AbstractButton)pComponent).getModel().isPressed();
        int maxX = this.mAscending ? 7 : 5;
        int maxY = 11;
        pGraphics.translate(pX, pY);
        if (selected) {
            if (this.mAscending) {
                pGraphics.setColor(SystemColor.controlDkShadow);
                pGraphics.drawLine(1, 0, 1, maxY);
                pGraphics.setColor(SystemColor.controlShadow);
                pGraphics.drawLine(2, 0, maxX, maxY);
                pGraphics.drawLine(2, maxY, maxX - 1, maxY);
                pGraphics.setColor(SystemColor.control);
                pGraphics.drawLine(2, 2, 2, maxY - 1);
                pGraphics.setColor(SystemColor.controlShadow);
                pGraphics.drawLine(3, 6, 3, 9);
                pGraphics.drawLine(4, 8, 4, 9);
                pGraphics.setColor(SystemColor.controlDkShadow);
                pGraphics.drawLine(3, maxY - 1, maxX - 1, maxY - 1);
                pGraphics.drawLine(3, 4, maxX - 2, maxY - 2);
            } else {
                pGraphics.setColor(SystemColor.controlDkShadow);
                pGraphics.drawLine(0, 0, maxX - 1, maxY - 2);
                pGraphics.drawLine(1, 0, maxX - 1, 0);
                pGraphics.setColor(SystemColor.controlShadow);
                pGraphics.drawLine(maxX, 0, maxX, maxY);
                pGraphics.setColor(SystemColor.control);
                pGraphics.drawLine(1, 1, 4, 1);
                pGraphics.setColor(SystemColor.controlShadow);
                pGraphics.drawLine(2, 2, 3, 2);
                pGraphics.drawLine(2, 3, 3, 3);
                pGraphics.drawLine(3, 4, 3, 5);
                pGraphics.setColor(SystemColor.controlDkShadow);
                pGraphics.drawLine(maxX - 1, 2, maxX - 1, 7);
            }
        } else if (this.mAscending) {
            pGraphics.setColor(SystemColor.controlDkShadow);
            pGraphics.drawLine(1, 0, 1, maxY);
            pGraphics.setColor(SystemColor.controlHighlight);
            pGraphics.drawLine(2, 0, 8, maxY);
            pGraphics.drawLine(2, maxY, maxX, maxY);
        } else {
            pGraphics.setColor(SystemColor.controlDkShadow);
            pGraphics.drawLine(1, 0, maxX, 0);
            pGraphics.drawLine(0, 0, maxX - 1, maxY - 2);
            pGraphics.setColor(SystemColor.controlHighlight);
            pGraphics.drawLine(maxX, 1, maxX, maxY);
        }
        pGraphics.translate(-pX, -pY);
    }
}

