/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import net.sf.cuf.ui.SwingDecorator;
import net.sf.cuf.ui.table.BasicDialog;
import net.sf.cuf.ui.table.TableSortInfo;

public class SortDialog
extends BasicDialog {
    private static final int CRITERIA_COUNT = 3;
    private static final int COLUMN_HEADER_OFFSET = 1;
    private JComboBox[] mCriteria;
    private JRadioButton[] mAscending;
    private JRadioButton[] mDescending;
    private JTable mCurrentTable = null;
    private TableSortInfo mResult;

    public SortDialog(Frame pOwner) {
        super(pOwner, "TABLESORT_DIALOG");
        this.addComponents();
    }

    private void addComponents() {
        Container pane = this.getContentPane();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        Insets insetsLabel = new Insets(2, 4, 2, 4);
        Insets insetsCombo = new Insets(2, 4, 2, 4);
        Insets insetsRadio = new Insets(2, 10, 2, 4);
        Insets insetsButtons = new Insets(15, 4, 2, 4);
        this.mCriteria = new JComboBox[3];
        this.mAscending = new JRadioButton[3];
        this.mDescending = new JRadioButton[3];
        for (int i = 0; i < 3; ++i) {
            JLabel l = new JLabel();
            SwingDecorator.initialize(l, "TABLESORT_DIALOG_CRITERIA" + (i + 1));
            gbc.gridx = 0;
            gbc.insets = insetsLabel;
            pane.add((Component)l, gbc);
            this.mCriteria[i] = new JComboBox();
            SwingDecorator.initialize(this.mCriteria[i], "TABLESORT_DIALOG_CRITERIAINPUT" + (i + 1));
            this.mCriteria[i].unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            gbc.gridx = 1;
            gbc.insets = insetsCombo;
            pane.add((Component)this.mCriteria[i], gbc);
            Box box = Box.createVerticalBox();
            gbc.gridx = 2;
            gbc.insets = insetsRadio;
            pane.add((Component)box, gbc);
            ButtonGroup bg = new ButtonGroup();
            this.mAscending[i] = new JRadioButton();
            SwingDecorator.initialize(this.mAscending[i], "TABLESORT_DIALOG_ASCENDING");
            box.add(this.mAscending[i]);
            bg.add(this.mAscending[i]);
            box.add(Box.createVerticalStrut(-3));
            this.mDescending[i] = new JRadioButton();
            SwingDecorator.initialize(this.mDescending[i], "TABLESORT_DIALOG_DESCENDING");
            box.add(this.mDescending[i]);
            bg.add(this.mDescending[i]);
            ++gbc.gridy;
        }
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 14;
        gbc.insets = insetsButtons;
        pane.add((Component)this.createOkCancelButtons(), gbc);
        JRootPane root = this.getRootPane();
        KeyStroke k1 = KeyStroke.getKeyStroke(10, 0, false);
        KeyStroke k2 = KeyStroke.getKeyStroke(10, 0, true);
        ActionListener a1 = root.getActionForKeyStroke(k1);
        ActionListener a2 = root.getActionForKeyStroke(k2);
        root.unregisterKeyboardAction(k1);
        root.unregisterKeyboardAction(k2);
        root.registerKeyboardAction(new FilteredAction(a1), k1, 2);
        root.registerKeyboardAction(new FilteredAction(a2), k2, 2);
    }

    public TableSortInfo show(JTable pTable, TableSortInfo pSortInfo) {
        if (pTable == null) {
            throw new IllegalArgumentException("table must not be null");
        }
        if (pSortInfo == null) {
            throw new IllegalArgumentException("tableSortInfoList must not be null");
        }
        Object[] headers = this.fetchVisibleColumnHeaders(pTable.getColumnModel(), 1);
        for (int i = 0; i < 3; ++i) {
            this.mCriteria[i].setModel(new DefaultComboBoxModel<Object>(headers));
        }
        this.initializeComponents(pTable, pSortInfo);
        this.mCriteria[0].requestFocus();
        this.mCurrentTable = pTable;
        this.showDialog();
        this.mCurrentTable = null;
        return this.mResult;
    }

    private void initializeComponents(JTable pTable, TableSortInfo pSortInfo) {
        int numInitialize = Math.min(3, pSortInfo.size());
        for (int i = 0; i < 3; ++i) {
            int sel = 0;
            boolean asc = true;
            if (i < numInitialize) {
                sel = pTable.convertColumnIndexToView(pSortInfo.getColumn(i)) + 1;
                asc = pSortInfo.isAscending(i);
            }
            this.mCriteria[i].setSelectedIndex(sel);
            this.mAscending[i].setSelected(asc);
            this.mDescending[i].setSelected(!asc);
        }
    }

    @Override
    protected void processDialogOk() {
        this.setVisible(false);
        this.mResult = new TableSortInfo();
        for (int i = 0; i < 3; ++i) {
            int selectedIndex = this.mCriteria[i].getSelectedIndex();
            if (selectedIndex < 1) continue;
            this.mResult.sortByColumn(this.mCurrentTable.convertColumnIndexToModel(selectedIndex - 1), this.mAscending[i].isSelected());
        }
    }

    @Override
    protected void processDialogCancel() {
        this.setVisible(false);
        this.mResult = null;
    }

    protected class FilteredAction
    implements ActionListener {
        private ActionListener mAction;

        public FilteredAction(ActionListener pAction) {
            this.mAction = pAction;
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
            if (!this.isAnyComboBoxPopupVisible()) {
                this.mAction.actionPerformed(pEvent);
            }
        }

        public boolean isAnyComboBoxPopupVisible() {
            boolean res = false;
            for (int i = 0; i < 3; ++i) {
                res |= SortDialog.this.mCriteria[i].isPopupVisible();
            }
            return res;
        }
    }
}

