/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import net.sf.cuf.ui.table.ContextMenuAction;

public class ContextMenuActionColumnToEdge
extends ContextMenuAction {
    public static final int EDGE_LEFT = 1;
    public static final int EDGE_RIGHT = 2;
    private int mode;

    public ContextMenuActionColumnToEdge(int pMode) {
        if (pMode != 1 && pMode != 2) {
            throw new IllegalArgumentException("mode must have a valid value");
        }
        this.mode = pMode;
    }

    @Override
    public String getKennung() {
        return this.mAdapter.getContextMenuKennung() + (this.mode == 1 ? "_COLLEFT" : "_COLRIGHT");
    }

    @Override
    public boolean isEnabled() {
        if (!this.mAdapter.getTable().getTableHeader().getReorderingAllowed()) {
            return false;
        }
        int viewIndex = this.mAdapter.getViewColumnIndex();
        return viewIndex != -1 && viewIndex != this.getEdgeColumnIndex();
    }

    @Override
    public void performAction() {
        this.mAdapter.getTable().moveColumn(this.mAdapter.getViewColumnIndex(), this.getEdgeColumnIndex());
    }

    private int getEdgeColumnIndex() {
        return this.mode == 1 ? 0 : this.mAdapter.getTable().getColumnCount() - 1;
    }
}

