/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableLayout2
extends TableLayout {
    protected static final Pattern PATTERN = Pattern.compile("(.+)\\s*\\((\\w+)\\)");
    protected Map<String, String> mSymbolicCR = new HashMap<String, String>();
    public static final String FILLTEXT = "fill";
    public static final String PREFERREDTEXT = "preferred";
    public static final String MINIMUMTEXT = "minimum";

    public TableLayout2() {
    }

    public TableLayout2(String pColumns, String pRows) {
        this();
        double[] columns = this.getCR(pColumns);
        double[] rows = this.getCR(pRows);
        this.setColumn(columns);
        this.setRow(rows);
    }

    private double[] getCR(String pCR) {
        Matcher m = PATTERN.matcher("");
        String[] crsString = pCR.trim().split("\\s*,\\s*");
        double[] crs = new double[crsString.length];
        for (int i = 0; i < crsString.length; ++i) {
            String crString = crsString[i];
            m.reset(crString);
            if (m.matches()) {
                crString = m.group(1);
                String symbolicName = m.group(2);
                Integer index = i;
                if (this.mSymbolicCR.containsKey(symbolicName)) {
                    throw new IllegalArgumentException("symbolic name " + symbolicName + " not uniq");
                }
                this.mSymbolicCR.put(symbolicName.concat(","), index.toString().concat(","));
            }
            crs[i] = crString.equalsIgnoreCase(FILLTEXT) ? -1.0 : (crString.equalsIgnoreCase(PREFERREDTEXT) ? -2.0 : (crString.equalsIgnoreCase(MINIMUMTEXT) ? -3.0 : Double.parseDouble(crString)));
        }
        return crs;
    }

    @Override
    public void addLayoutComponent(Component pComponent, Object pConstraint) {
        Object constraint = pConstraint;
        if (pConstraint instanceof String) {
            String constraintString = (String)pConstraint;
            constraintString = constraintString.concat(",");
            constraintString = constraintString.replaceAll("\\s", "");
            Iterator<Map.Entry<String, String>> i$ = this.mSymbolicCR.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, String> stringStringEntry;
                Map.Entry<String, String> entry = stringStringEntry = i$.next();
                constraintString = constraintString.replaceAll(entry.getKey(), entry.getValue().toString());
            }
            if (constraintString.endsWith(",")) {
                constraint = constraintString.substring(0, constraintString.length() - 1);
            }
        }
        super.addLayoutComponent(pComponent, constraint);
    }
}

