/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.sf.cuf.ui.DispatcherAction;

public class SwingConnectionManager
implements ActionListener,
ChangeListener,
ListSelectionListener,
TreeSelectionListener,
CaretListener,
FocusListener,
PropertyChangeListener,
DocumentListener {
    private final Map<Source, Target> mSourceToTarget = new HashMap<Source, Target>();
    private static final SwingConnectionManager SCM = new SwingConnectionManager();
    private static final Class<?>[] NO_CLASS_ARGS = new Class[0];

    private SwingConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAndStoreActionTarget(Object pActionSource, Object pTarget, String pMethodName) {
        if (pActionSource == null) {
            throw new IllegalArgumentException("ActionSource must not be null");
        }
        if (pTarget == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        if (pMethodName == null) {
            throw new IllegalArgumentException("MethodName must not be null");
        }
        if (!Modifier.isPublic(pTarget.getClass().getModifiers())) {
            throw new IllegalArgumentException("Target must be an object from a public class");
        }
        Target target = new Target(pTarget, pMethodName, ActionEvent.class);
        Map<Source, Target> map = SwingConnectionManager.SCM.mSourceToTarget;
        synchronized (map) {
            Source source = new Source(pActionSource, ActionEvent.class);
            SwingConnectionManager.SCM.mSourceToTarget.put(source, target);
        }
    }

    public static void createActionConnection(JComboBox pActionSource, Object pTarget, String pMethodName) {
        SwingConnectionManager.checkAndStoreActionTarget(pActionSource, pTarget, pMethodName);
        pActionSource.addActionListener(SCM);
    }

    public static void createActionConnection(JTextField pActionSource, Object pTarget, String pMethodName) {
        SwingConnectionManager.checkAndStoreActionTarget(pActionSource, pTarget, pMethodName);
        pActionSource.addActionListener(SCM);
    }

    public static void createActionConnection(AbstractButton pActionSource, Object pTarget, String pMethodName) {
        SwingConnectionManager.checkAndStoreActionTarget(pActionSource, pTarget, pMethodName);
        pActionSource.addActionListener(SCM);
    }

    public static void createActionConnection(DispatcherAction pActionSource, Object pTarget, String pMethodName) {
        SwingConnectionManager.checkAndStoreActionTarget(pActionSource, pTarget, pMethodName);
        pActionSource.addActionListener(SCM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAndStoreChangeTarget(Object pChangeSource, Object pTarget, String pMethodName) {
        if (pChangeSource == null) {
            throw new IllegalArgumentException("ChangeSource must not be null");
        }
        if (pTarget == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        if (pMethodName == null) {
            throw new IllegalArgumentException("MethodName must not be null");
        }
        Target target = new Target(pTarget, pMethodName, ChangeEvent.class);
        Map<Source, Target> map = SwingConnectionManager.SCM.mSourceToTarget;
        synchronized (map) {
            Source source = new Source(pChangeSource, ChangeEvent.class);
            SwingConnectionManager.SCM.mSourceToTarget.put(source, target);
        }
    }

    public static void createChangeConnection(JSlider pChangeSource, Object pTarget, String pMethodName) {
        SwingConnectionManager.checkAndStoreChangeTarget(pChangeSource, pTarget, pMethodName);
        pChangeSource.addChangeListener(SCM);
    }

    public static void createChangeConnection(AbstractButton pChangeSource, Object pTarget, String pMethodName) {
        SwingConnectionManager.checkAndStoreChangeTarget(pChangeSource, pTarget, pMethodName);
        pChangeSource.addChangeListener(SCM);
    }

    public static void createChangeConnection(JTabbedPane pChangeSource, Object pTarget, String pMethodName) {
        SwingConnectionManager.checkAndStoreChangeTarget(pChangeSource, pTarget, pMethodName);
        pChangeSource.addChangeListener(SCM);
    }

    public static void createChangeConnection(JSpinner pChangeSource, Object pTarget, String pMethodName) {
        SwingConnectionManager.checkAndStoreChangeTarget(pChangeSource, pTarget, pMethodName);
        pChangeSource.addChangeListener(SCM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTreeSelectionConnection(JTree pTreeSelectionSource, Object pTarget, String pMethodName) {
        if (pTreeSelectionSource == null) {
            throw new IllegalArgumentException("TreeSelectionSource must not be null");
        }
        if (pTarget == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        if (pMethodName == null) {
            throw new IllegalArgumentException("MethodName must not be null");
        }
        Target target = new Target(pTarget, pMethodName, TreeSelectionEvent.class);
        Map<Source, Target> map = SwingConnectionManager.SCM.mSourceToTarget;
        synchronized (map) {
            Source source = new Source(pTreeSelectionSource, TreeSelectionEvent.class);
            SwingConnectionManager.SCM.mSourceToTarget.put(source, target);
        }
        pTreeSelectionSource.addTreeSelectionListener(SCM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAndStoreListSelectionTarget(Object pListSelectionSource, Object pTarget, String pMethodName) {
        if (pListSelectionSource == null) {
            throw new IllegalArgumentException("ListSelectionSource must not be null");
        }
        if (pTarget == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        if (pMethodName == null) {
            throw new IllegalArgumentException("MethodName must not be null");
        }
        Target target = new Target(pTarget, pMethodName, ListSelectionEvent.class);
        Map<Source, Target> map = SwingConnectionManager.SCM.mSourceToTarget;
        synchronized (map) {
            Source source = new Source(pListSelectionSource, ListSelectionEvent.class);
            SwingConnectionManager.SCM.mSourceToTarget.put(source, target);
        }
    }

    public static void createListSelectionConnection(JList pListSelectionSource, Object pTarget, String pMethodName) {
        SwingConnectionManager.checkAndStoreListSelectionTarget(pListSelectionSource, pTarget, pMethodName);
        pListSelectionSource.addListSelectionListener(SCM);
    }

    public static void createListSelectionConnection(JTable pListSelectionSource, Object pTarget, String pMethodName) {
        SwingConnectionManager.checkAndStoreListSelectionTarget(pListSelectionSource.getSelectionModel(), pTarget, pMethodName);
        pListSelectionSource.getSelectionModel().addListSelectionListener(SCM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCaretConnection(JTextComponent pCaretSource, Object pTarget, String pMethodName) {
        if (pCaretSource == null) {
            throw new IllegalArgumentException("CaretSource must not be null");
        }
        if (pTarget == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        if (pMethodName == null) {
            throw new IllegalArgumentException("MethodName must not be null");
        }
        Target target = new Target(pTarget, pMethodName, CaretEvent.class);
        Map<Source, Target> map = SwingConnectionManager.SCM.mSourceToTarget;
        synchronized (map) {
            Source source = new Source(pCaretSource, CaretEvent.class);
            SwingConnectionManager.SCM.mSourceToTarget.put(source, target);
        }
        pCaretSource.addCaretListener(SCM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFocusConnection(JComponent pFocusSource, Object pTarget, String pMethodName) {
        if (pFocusSource == null) {
            throw new IllegalArgumentException("FocusSource must not be null");
        }
        if (pTarget == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        if (pMethodName == null) {
            throw new IllegalArgumentException("MethodName must not be null");
        }
        Target target = new Target(pTarget, pMethodName, FocusEvent.class);
        Map<Source, Target> map = SwingConnectionManager.SCM.mSourceToTarget;
        synchronized (map) {
            Source source = new Source(pFocusSource, FocusEvent.class);
            SwingConnectionManager.SCM.mSourceToTarget.put(source, target);
        }
        pFocusSource.addFocusListener(SCM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPropertyChangeConnection(JComponent pPropertyChangeSource, Object pTarget, String pMethodName) {
        if (pPropertyChangeSource == null) {
            throw new IllegalArgumentException("PropertyChangeSource must not be null");
        }
        if (pTarget == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        if (pMethodName == null) {
            throw new IllegalArgumentException("MethodName must not be null");
        }
        Target target = new Target(pTarget, pMethodName, PropertyChangeEvent.class);
        Map<Source, Target> map = SwingConnectionManager.SCM.mSourceToTarget;
        synchronized (map) {
            Source source = new Source(pPropertyChangeSource, PropertyChangeEvent.class);
            SwingConnectionManager.SCM.mSourceToTarget.put(source, target);
        }
        pPropertyChangeSource.addPropertyChangeListener(SCM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAndStoreDocumentTarget(Document pDocumentSource, Object pTarget, String pMethodName) {
        if (pDocumentSource == null) {
            throw new IllegalArgumentException("DocumentSource must not be null");
        }
        if (pTarget == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        if (pMethodName == null) {
            throw new IllegalArgumentException("MethodName must not be null");
        }
        Target target = new Target(pTarget, pMethodName, DocumentEvent.class);
        Map<Source, Target> map = SwingConnectionManager.SCM.mSourceToTarget;
        synchronized (map) {
            Source source = new Source(pDocumentSource, DocumentEvent.class);
            SwingConnectionManager.SCM.mSourceToTarget.put(source, target);
        }
        pDocumentSource.addDocumentListener(SCM);
    }

    public static void createDocumentConnection(JTextComponent pDocumentSource, Object pTarget, String pMethodName) {
        Document document = pDocumentSource.getDocument();
        SwingConnectionManager.checkAndStoreDocumentTarget(document, pTarget, pMethodName);
    }

    public static void createDocumentConnection(Document pDocumentSource, Object pTarget, String pMethodName) {
        SwingConnectionManager.checkAndStoreDocumentTarget(pDocumentSource, pTarget, pMethodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConnection(Object pTarget) {
        Map<Source, Target> map = SwingConnectionManager.SCM.mSourceToTarget;
        synchronized (map) {
            Iterator<Map.Entry<Source, Target>> it = SwingConnectionManager.SCM.mSourceToTarget.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Source, Target> entry = it.next();
                Target target = entry.getValue();
                if (target.getTarget() != pTarget) continue;
                Object eventSource = entry.getKey().getSource();
                Class<?> eventClass = entry.getKey().getEventClass();
                if (eventSource instanceof AbstractButton) {
                    ((AbstractButton)eventSource).removeActionListener(SCM);
                    ((AbstractButton)eventSource).removeChangeListener(SCM);
                    ((AbstractButton)eventSource).removeFocusListener(SCM);
                } else if (eventSource instanceof DispatcherAction) {
                    ((DispatcherAction)eventSource).removeActionListener(SCM);
                } else if (eventSource instanceof JComboBox) {
                    ((JComboBox)eventSource).removeActionListener(SCM);
                    ((JComboBox)eventSource).removeFocusListener(SCM);
                } else if (eventSource instanceof JTextField) {
                    ((JTextField)eventSource).removeActionListener(SCM);
                    ((JTextField)eventSource).removeCaretListener(SCM);
                    ((JTextField)eventSource).removeFocusListener(SCM);
                } else if (eventSource instanceof JSlider) {
                    ((JSlider)eventSource).removeChangeListener(SCM);
                    ((JSlider)eventSource).removeFocusListener(SCM);
                } else if (eventSource instanceof JTree) {
                    ((JTree)eventSource).removeTreeSelectionListener(SCM);
                    ((JTree)eventSource).removeFocusListener(SCM);
                } else if (eventSource instanceof JList) {
                    ((JList)eventSource).removeListSelectionListener(SCM);
                    ((JList)eventSource).removeFocusListener(SCM);
                } else if (eventSource instanceof JTabbedPane) {
                    ((JTabbedPane)eventSource).removeChangeListener(SCM);
                } else if (eventSource instanceof ListSelectionModel) {
                    ((ListSelectionModel)eventSource).removeListSelectionListener(SCM);
                } else if (eventSource instanceof Document) {
                    ((Document)eventSource).removeDocumentListener(SCM);
                } else if (eventClass.equals(FocusEvent.class)) {
                    ((JComponent)eventSource).removeFocusListener(SCM);
                } else if (eventClass.equals(PropertyChangeEvent.class)) {
                    ((JComponent)eventSource).removePropertyChangeListener(SCM);
                } else {
                    System.err.println("WARNING: SwingConnectionManager.removeConnection() internal error for target " + pTarget);
                }
                it.remove();
            }
        }
    }

    private void makeCall(Target pTarget, Object pEvent) {
        try {
            Object[] objectArray;
            if (pTarget.isNoEventInCallback()) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = pEvent;
            }
            Object[] args = objectArray;
            pTarget.getMethod().invoke(pTarget.getTarget(), args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            IllegalArgumentException iae = new IllegalArgumentException(cause != null ? cause.getMessage() : e.getMessage());
            iae.initCause(cause);
            throw iae;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent pAction) {
        Object actionSource = pAction.getSource();
        Target target = null;
        Map<Source, Target> map = this.mSourceToTarget;
        synchronized (map) {
            if (actionSource != null) {
                Source source = new Source(actionSource, ActionEvent.class);
                target = this.mSourceToTarget.get(source);
            }
        }
        if (target != null) {
            this.makeCall(target, pAction);
        } else {
            System.err.println("WARNING: SwingConnectionManager.actionPerformed() called from unknown source");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent pChange) {
        Object changeSource = pChange.getSource();
        Target target = null;
        Map<Source, Target> map = this.mSourceToTarget;
        synchronized (map) {
            if (changeSource != null) {
                Source source = new Source(changeSource, ChangeEvent.class);
                target = this.mSourceToTarget.get(source);
            }
        }
        if (target != null) {
            this.makeCall(target, pChange);
        } else {
            System.err.println("WARNING: SwingConnectionManager.stateChanged() called from unknown source");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent pTreeSelection) {
        Object treeSelectionSource = pTreeSelection.getSource();
        Target target = null;
        Map<Source, Target> map = this.mSourceToTarget;
        synchronized (map) {
            if (treeSelectionSource != null) {
                Source source = new Source(treeSelectionSource, TreeSelectionEvent.class);
                target = this.mSourceToTarget.get(source);
            }
        }
        if (target != null) {
            this.makeCall(target, pTreeSelection);
        } else {
            System.err.println("WARNING: SwingConnectionManager.valueChanged(TreeSelectionEvent) called from unknown source");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent pListSelection) {
        Object listSelectionSource = pListSelection.getSource();
        Target target = null;
        Map<Source, Target> map = this.mSourceToTarget;
        synchronized (map) {
            if (listSelectionSource != null) {
                Source source = new Source(listSelectionSource, ListSelectionEvent.class);
                target = this.mSourceToTarget.get(source);
            }
        }
        if (target != null) {
            this.makeCall(target, pListSelection);
        } else {
            System.err.println("WARNING: SwingConnectionManager.valueChanged(ListSelectionEvent) called from unknown source" + listSelectionSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretUpdate(CaretEvent pCaret) {
        Object caretSource = pCaret.getSource();
        Target target = null;
        Map<Source, Target> map = this.mSourceToTarget;
        synchronized (map) {
            if (caretSource != null) {
                Source source = new Source(caretSource, CaretEvent.class);
                target = this.mSourceToTarget.get(source);
            }
        }
        if (target != null) {
            this.makeCall(target, pCaret);
        } else {
            System.err.println("WARNING: SwingConnectionManager.caretUpdate(CaretEvent) called from unknown source" + caretSource);
        }
    }

    @Override
    public void focusGained(FocusEvent pFocus) {
        this.focusLost(pFocus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void focusLost(FocusEvent pFocus) {
        Object focusSource = pFocus.getSource();
        Target target = null;
        Map<Source, Target> map = this.mSourceToTarget;
        synchronized (map) {
            if (focusSource != null) {
                Source source = new Source(focusSource, FocusEvent.class);
                target = this.mSourceToTarget.get(source);
            }
        }
        if (target != null) {
            this.makeCall(target, pFocus);
        } else {
            System.err.println("WARNING: SwingConnectionManager.focusLost/Gained(FocusEvent) called from unknown source" + focusSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent pPropertyChange) {
        Object propertyChangeSource = pPropertyChange.getSource();
        Target target = null;
        Map<Source, Target> map = this.mSourceToTarget;
        synchronized (map) {
            if (propertyChangeSource != null) {
                Source source = new Source(propertyChangeSource, PropertyChangeEvent.class);
                target = this.mSourceToTarget.get(source);
            }
        }
        if (target != null) {
            this.makeCall(target, pPropertyChange);
        } else {
            System.err.println("WARNING: SwingConnectionManager.propertyChange(PropertyChangeEvent) called from unknown source" + propertyChangeSource);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent pDocumentEvent) {
        this.processDocumentChange(pDocumentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent pDocumentEvent) {
        this.processDocumentChange(pDocumentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent pDocumentEvent) {
        this.processDocumentChange(pDocumentEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDocumentChange(DocumentEvent pDocumentEvent) {
        Document documentEventSource = pDocumentEvent.getDocument();
        Target target = null;
        Map<Source, Target> map = this.mSourceToTarget;
        synchronized (map) {
            if (documentEventSource != null) {
                Source source = new Source(documentEventSource, DocumentEvent.class);
                target = this.mSourceToTarget.get(source);
            }
        }
        if (target != null) {
            this.makeCall(target, pDocumentEvent);
        } else {
            System.err.println("WARNING: SwingConnectionManager.processDocumentChange(DocumentEvent) called from unknown source" + documentEventSource);
        }
    }

    private static class Target {
        private Object mTarget;
        private Method mMethod;
        private boolean mNoEventInCallback;

        Target(Object pTarget, String pMethodName, Class<?> pEventClass) {
            if (pTarget == null) {
                throw new IllegalArgumentException("target must not be null");
            }
            if (pMethodName == null) {
                throw new IllegalArgumentException("method name must not be null");
            }
            if (pEventClass == null) {
                throw new IllegalArgumentException("event class must not be null");
            }
            try {
                this.mMethod = pTarget.getClass().getMethod(pMethodName, pEventClass);
                this.mNoEventInCallback = false;
            }
            catch (NoSuchMethodException e1) {
                try {
                    this.mMethod = pTarget.getClass().getMethod(pMethodName, NO_CLASS_ARGS);
                    this.mNoEventInCallback = true;
                }
                catch (NoSuchMethodException e2) {
                    throw new IllegalArgumentException("no method " + pMethodName + " with the right signature found" + " in class " + pTarget.getClass().getName());
                }
            }
            this.mTarget = pTarget;
        }

        public Object getTarget() {
            return this.mTarget;
        }

        public Method getMethod() {
            return this.mMethod;
        }

        public boolean isNoEventInCallback() {
            return this.mNoEventInCallback;
        }

        public boolean equals(Object pObject) {
            if (pObject == this) {
                return true;
            }
            if (!(pObject instanceof Target)) {
                return false;
            }
            Target target = (Target)pObject;
            return target.mTarget == this.mTarget && target.mMethod.getName().equals(this.mMethod.getName());
        }

        public int hashCode() {
            return this.mTarget.hashCode() | this.mMethod.hashCode();
        }

        public String toString() {
            return this.mTarget.toString() + this.mMethod.toString();
        }
    }

    private static class Source {
        private Object mSource;
        private Class<?> mEventClass;

        Source(Object pSource, Class<?> pEventClass) {
            if (pSource == null) {
                throw new IllegalArgumentException("source must not be null");
            }
            if (pEventClass == null) {
                throw new IllegalArgumentException("event class must not be null");
            }
            this.mSource = pSource;
            this.mEventClass = pEventClass;
        }

        public Object getSource() {
            return this.mSource;
        }

        public Class<?> getEventClass() {
            return this.mEventClass;
        }

        public boolean equals(Object pObject) {
            if (pObject == this) {
                return true;
            }
            if (!(pObject instanceof Source)) {
                return false;
            }
            Source source = (Source)pObject;
            return source.mSource == this.mSource && source.mEventClass.equals(this.mEventClass);
        }

        public int hashCode() {
            return this.mSource.hashCode() | this.mEventClass.hashCode();
        }

        public String toString() {
            return this.mSource.toString() + this.mEventClass.toString();
        }
    }
}

