/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.debug;

import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.cuf.debug.ClassNameAdapter;
import net.sf.cuf.debug.DoubleDelegateAccess;
import net.sf.cuf.debug.StateInfo;
import net.sf.cuf.model.DelegateAccess;
import net.sf.cuf.model.MixedAccessAdapter;
import net.sf.cuf.model.SelectionInList;
import net.sf.cuf.model.ui.ListTableMapper;
import net.sf.cuf.state.State;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StateChecker {
    private StateChecker() {
    }

    public static void setupFromBuilder(String pTitle, SwingXMLBuilder pBuilder) {
        List stateInfos = StateChecker.getStateInfos(pBuilder);
        StateChecker.buildDisplay(pTitle, pBuilder, stateInfos);
    }

    private static void buildDisplay(String pFilename, SwingXMLBuilder pBuilder, final List pStateInfos) {
        final JFrame frame = new JFrame("States for " + pFilename);
        JPanel contentPane = new JPanel(new BorderLayout());
        frame.setContentPane(contentPane);
        JTable stateTable = new JTable();
        final SelectionInList stateSIL = new SelectionInList(pStateInfos);
        ArrayList<ListTableMapper.Mapping> mapping = new ArrayList<ListTableMapper.Mapping>();
        AttrAdapter stateAA = new AttrAdapter("state");
        mapping.add(new ListTableMapper.Mapping("ID", String.class, new AttrAdapter("id")));
        mapping.add(new ListTableMapper.Mapping("class", String.class, new DoubleDelegateAccess(stateAA, new ClassNameAdapter())));
        mapping.add(new ListTableMapper.Mapping("initialized", Boolean.class, new DoubleDelegateAccess(stateAA, new AttrAdapter("initialized", "is", "set"))));
        mapping.add(new ListTableMapper.Mapping("enabled", Boolean.class, new DoubleDelegateAccess(stateAA, new AttrAdapter("enabled", "is", "set"))));
        new ListTableMapper(stateTable, stateSIL, mapping, false);
        final ChangeListener updateListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent pE) {
                stateSIL.signalExternalUpdate();
                stateSIL.selectionHolder().setValueForced(stateSIL.selectionHolder().getValue());
            }
        };
        for (Object pStateInfo : pStateInfos) {
            StateInfo stateInfo = (StateInfo)pStateInfo;
            stateInfo.getState().addChangeListener(updateListener);
        }
        final JTextArea detailsTextArea = new JTextArea(30, 100);
        contentPane.add(new JSplitPane(0, new JScrollPane(stateTable), new JScrollPane(detailsTextArea)));
        stateSIL.selectionHolder().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent pE) {
                if (stateSIL.selectionHolder().intValue() >= 0) {
                    detailsTextArea.setText(StateChecker.getDetailsFor((StateInfo)pStateInfos.get(stateSIL.selectionHolder().intValue())));
                    detailsTextArea.setCaretPosition(0);
                } else {
                    detailsTextArea.setText("");
                }
            }
        });
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent pE) {
                for (Object pStateInfo : pStateInfos) {
                    StateInfo stateInfo = (StateInfo)pStateInfo;
                    stateInfo.getState().removeChangeListener(updateListener);
                }
                frame.setVisible(false);
                frame.dispose();
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    protected static String getDetailsFor(StateInfo pStateInfo) {
        return pStateInfo.getDetails();
    }

    private static List getStateInfos(Document pDocument, SwingXMLBuilder pBuilder) {
        ArrayList<StateInfo> stateInfos = new ArrayList<StateInfo>();
        Node stateHandling = pDocument.getElementsByTagName("statehandling").item(0);
        NodeList childNodes = stateHandling.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String id;
            Object nonVisual;
            Node idAttr;
            Node stateNode = childNodes.item(i);
            if (stateNode.getAttributes() == null || (idAttr = stateNode.getAttributes().getNamedItem("id")) == null || !((nonVisual = pBuilder.getNonVisualObject(id = idAttr.getNodeValue())) instanceof State)) continue;
            State state = (State)nonVisual;
            stateInfos.add(new StateInfo(id, stateNode, state));
        }
        return stateInfos;
    }

    private static List getStateInfos(SwingXMLBuilder pBuilder) {
        ArrayList<StateInfo> stateInfos = new ArrayList<StateInfo>();
        Map<String, ? super Object> nonvisualMap = pBuilder.getNameToNonVisual();
        for (String o : nonvisualMap.keySet()) {
            String key = o;
            Object nonVisual = nonvisualMap.get(key);
            if (!(nonVisual instanceof State)) continue;
            State state = (State)nonVisual;
            stateInfos.add(new StateInfo(key, state));
        }
        return stateInfos;
    }

    private static Document scanXml(String pFilename) throws SAXException, IOException, ParserConfigurationException {
        InputStream in = StateChecker.class.getResourceAsStream(pFilename);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(new EntityHelper());
        Document document = db.parse(in);
        in.close();
        return document;
    }

    private static class AttrAdapter
    extends MixedAccessAdapter
    implements DelegateAccess {
        public AttrAdapter(Class pSourceClass, String pAspectName, String pGetterPrefix, String pSetterPrefix) {
            super(pSourceClass, pAspectName, pGetterPrefix, pSetterPrefix);
        }

        public AttrAdapter(Class pSourceClass, String pAspectName) {
            super(pSourceClass, pAspectName);
        }

        public AttrAdapter(String pAspectName, String pGetterPrefix, String pSetterPrefix) {
            super(pAspectName, pGetterPrefix, pSetterPrefix);
        }

        public AttrAdapter(String pAspectName) {
            super(pAspectName);
        }
    }

    private static class EntityHelper
    implements EntityResolver {
        private EntityHelper() {
        }

        @Override
        public InputSource resolveEntity(String pPublicId, String pSystemId) {
            if ("http://www.sdm.com/dtd/xml2swing-1.6.dtd".equals(pSystemId)) {
                return this.loadDtd("xml2swing-1.6.dtd");
            }
            return null;
        }

        private InputSource loadDtd(String pFileName) {
            InputStream dtd;
            InputSource back = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null && (dtd = loader.getResourceAsStream(pFileName)) != null) {
                back = new InputSource(dtd);
            }
            return back;
        }
    }
}

