/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvview.option;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.appevent.AppEventSupport;
import net.sf.cuf.appevent.AppEventUtil;
import net.sf.cuf.csvview.option.OptionDc;
import net.sf.cuf.csvview.util.CSVFileFilter;
import net.sf.cuf.csvview.util.DataSourceChanged;
import net.sf.cuf.csvview.util.EXEFileFilter;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Pc;
import net.sf.cuf.model.BufferedValueHolder;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class OptionPc
implements Pc,
AppEventSupport,
SwingXMLBuilder.Backlink {
    private SwingXMLBuilder mBuilder;
    private Application mApp;
    private OptionDc mDc;
    private ValueModel mTrigger;
    private BufferedValueHolder mInputSelectionBuffer;
    private BufferedValueHolder mFileNameBuffer;
    private BufferedValueHolder mURLNameBuffer;
    private BufferedValueHolder mTreeNameBuffer;
    private BufferedValueHolder mFirstRowIsHeaderBuffer;
    private BufferedValueHolder mCSVSeparatorBuffer;
    private ValueModel mExeActiveBuffer;
    private ValueModel mExeNameBuffer;
    private ValueModel mPLAFSelectionBuffer;
    private BufferedValueHolder mEncodingSelectionBuffer;
    private ValueModel mCopyRowSelectionBuffer;
    private static final String BASE = "Frame/OptionsDialog/Panel/Options/";

    public void setSwingXMLBuilder(SwingXMLBuilder pBuilder) {
        this.mBuilder = pBuilder;
    }

    public void postAppEvent(AppEvent pAppEvent) {
        AppEventUtil.postAppEvent((AppEventSupport)this.mDc, (AppEvent)pAppEvent);
    }

    public void init(Dc pDc, Map<String, ? super Object> pArgs) {
        this.mDc = (OptionDc)pDc;
        this.mApp = (Application)pArgs.get("Application");
        this.mTrigger = (ValueModel)this.mBuilder.getNonVisualObject("OptionPc/Trigger");
        this.mFileNameBuffer = (BufferedValueHolder)this.mBuilder.getNonVisualObject("OptionPc/FileNameBuffer");
        this.mURLNameBuffer = (BufferedValueHolder)this.mBuilder.getNonVisualObject("OptionPc/URLNameBuffer");
        this.mTreeNameBuffer = (BufferedValueHolder)this.mBuilder.getNonVisualObject("OptionPc/TreeNameBuffer");
        this.mFirstRowIsHeaderBuffer = (BufferedValueHolder)this.mBuilder.getNonVisualObject("OptionPc/FirstRowIsHeaderBuffer");
        this.mCSVSeparatorBuffer = (BufferedValueHolder)this.mBuilder.getNonVisualObject("OptionPc/CSVSeparatorBuffer");
        this.mExeActiveBuffer = (ValueModel)this.mBuilder.getNonVisualObject("OptionPc/ExeActiveBuffer");
        this.mExeNameBuffer = (ValueModel)this.mBuilder.getNonVisualObject("OptionPc/ExeNameBuffer");
        this.mCopyRowSelectionBuffer = (ValueModel)this.mBuilder.getNonVisualObject("OptionPc/CopyRowSelectionBuffer");
        this.mPLAFSelectionBuffer = (ValueModel)this.mBuilder.getNonVisualObject("OptionPc/PlafSelectionBuffer");
        this.mEncodingSelectionBuffer = (BufferedValueHolder)this.mBuilder.getNonVisualObject("OptionPc/EncodingSelectionBuffer");
        this.mInputSelectionBuffer = (BufferedValueHolder)this.mBuilder.getNonVisualObject("OptionPc/InputSelectionBuffer");
    }

    public void show() {
        JDialog optionsDialog = (JDialog)this.mBuilder.getContainerByName("Frame/OptionsDialog");
        optionsDialog.setModal(true);
        JButton okButton = (JButton)this.mBuilder.getComponentByName("Frame/OptionsDialog/Panel/ButtonBar/OK");
        optionsDialog.getRootPane().setDefaultButton(okButton);
        this.mTrigger.setValueForced((Object)Boolean.FALSE);
        optionsDialog.pack();
        Rectangle parentBounds = optionsDialog.getParent().getBounds();
        int deltaX = (parentBounds.width - optionsDialog.getBounds().width) / 2;
        int deltaY = (parentBounds.height - optionsDialog.getBounds().height) / 2;
        optionsDialog.setLocation(parentBounds.x + deltaX, parentBounds.y + deltaY);
        optionsDialog.setVisible(true);
    }

    public void ok() {
        JDialog optionsDialog = (JDialog)this.mBuilder.getContainerByName("Frame/OptionsDialog");
        optionsDialog.setVisible(false);
        boolean sourceChanged = false;
        if (this.mInputSelectionBuffer.isBufferEqual() && this.mEncodingSelectionBuffer.isBufferEqual()) {
            ValueModel inputSelection = (ValueModel)this.mApp.getAppModel().get("InputSelection");
            String csvSource = (String)inputSelection.getValue();
            if (csvSource.equals("file")) {
                sourceChanged = !this.mFileNameBuffer.isBufferEqual();
                sourceChanged = sourceChanged || !this.mFirstRowIsHeaderBuffer.isBufferEqual();
                sourceChanged = sourceChanged || !this.mCSVSeparatorBuffer.isBufferEqual();
            } else if (csvSource.equals("url")) {
                sourceChanged = !this.mURLNameBuffer.isBufferEqual();
                sourceChanged = sourceChanged || !this.mFirstRowIsHeaderBuffer.isBufferEqual();
                sourceChanged = sourceChanged || !this.mCSVSeparatorBuffer.isBufferEqual();
            } else if (csvSource.equals("tree")) {
                sourceChanged = !this.mTreeNameBuffer.isBufferEqual();
            }
        } else {
            sourceChanged = true;
        }
        this.mTrigger.setValueForced((Object)Boolean.TRUE);
        if (sourceChanged) {
            this.postAppEvent(new DataSourceChanged(this));
        }
    }

    public void cancel() {
        JDialog optionsDialog = (JDialog)this.mBuilder.getContainerByName("Frame/OptionsDialog");
        optionsDialog.setVisible(false);
    }

    public void defaults() {
        this.mInputSelectionBuffer.setValue((Object)"file");
        this.mFileNameBuffer.setValue((Object)"src/test/resources/ca-500.csv");
        this.mURLNameBuffer.setValue((Object)"");
        this.mTreeNameBuffer.setValue((Object)System.getProperty("user.home"));
        this.mFirstRowIsHeaderBuffer.setValue((Object)Boolean.valueOf("true"));
        this.mCSVSeparatorBuffer.setValue((Object)",");
        this.mExeActiveBuffer.setValue((Object)"false");
        this.mExeNameBuffer.setValue((Object)"");
        this.mPLAFSelectionBuffer.setValue((Object)"com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        this.mEncodingSelectionBuffer.setValue((Object)"Cp1252");
        this.mCopyRowSelectionBuffer.setValue((Object)Boolean.valueOf("false"));
    }

    public void fileSearch() {
        this.showChooser(new CSVFileFilter(), 0, "Frame/OptionsDialog/Panel/Options/Source/FileName");
    }

    public void treeSearch() {
        this.showChooser(null, 1, "Frame/OptionsDialog/Panel/Options/Source/TreeName");
    }

    public void exeSearch() {
        this.showChooser(new EXEFileFilter(), 0, "Frame/OptionsDialog/Panel/Options/Action/EXEName");
    }

    private void showChooser(FileFilter pFileFilter, int pFileSelectionMode, String pTextFieldName) {
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("Frame");
        String dir = this.mApp.getProperty("fileopen.dir", ".");
        JFileChooser fileChooser = new JFileChooser(dir);
        if (pFileFilter != null) {
            fileChooser.addChoosableFileFilter(pFileFilter);
        }
        fileChooser.setFileSelectionMode(pFileSelectionMode);
        int back = fileChooser.showOpenDialog(frame);
        if (back == 0) {
            File file = fileChooser.getSelectedFile();
            String fileName = null;
            try {
                fileName = file.getCanonicalPath();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if (fileName != null) {
                JTextField textField = (JTextField)this.mBuilder.getComponentByName(pTextFieldName);
                textField.setText(fileName);
                this.mApp.setProperty("fileopen.dir", file.getParent());
            }
        }
    }
}

