/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.builder;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import net.sf.cuf.ui.DispatcherAction;

public class PopupManager
extends MouseAdapter {
    public static final String POPUPMANAGER_PROPERTY = "popupmanager";
    private JPopupMenu mPopup;
    private int mLastX;
    private int mLastY;

    PopupManager(String pTitle) {
        this.mPopup = new JPopupMenu(pTitle);
        this.mPopup.putClientProperty(POPUPMANAGER_PROPERTY, this);
    }

    public JPopupMenu getPopup() {
        return this.mPopup;
    }

    public int getX() {
        return this.mLastX;
    }

    public int getY() {
        return this.mLastY;
    }

    public void addManagedComponent(JComponent pComponent) {
        pComponent.addMouseListener(this);
    }

    public void removeManagedComponent(JComponent pComponent) {
        pComponent.removeMouseListener(this);
    }

    @Override
    public void mousePressed(MouseEvent pEvent) {
        this.handleMouseEvent(pEvent);
    }

    @Override
    public void mouseReleased(MouseEvent pEvent) {
        this.handleMouseEvent(pEvent);
    }

    private void handleMouseEvent(MouseEvent pEvent) {
        if (pEvent.isPopupTrigger()) {
            this.mLastX = pEvent.getX();
            this.mLastY = pEvent.getY();
            this.mPopup.show(pEvent.getComponent(), this.mLastX, this.mLastY);
        }
    }

    public static JComponent getPopupTrigger(ActionEvent pEvent) {
        JPopupMenu popup = PopupManager.getRootPopup(pEvent);
        if (popup != null) {
            Component trigger = popup.getInvoker();
            if (trigger instanceof JComponent) {
                return (JComponent)trigger;
            }
            return null;
        }
        return null;
    }

    public static JPopupMenu getRootPopup(ActionEvent pEvent) {
        Container parent;
        if (pEvent == null) {
            return null;
        }
        Object source = pEvent.getSource();
        JPopupMenu mp = null;
        if (source instanceof DispatcherAction) {
            source = ((DispatcherAction)source).getRealSource();
        }
        if (source instanceof Component && (parent = ((Component)source).getParent()) instanceof JPopupMenu) {
            mp = (JPopupMenu)parent;
            while (mp != null && mp.getInvoker() != null && mp.getInvoker() instanceof JMenu && mp.getInvoker().getParent() != null && mp.getInvoker().getParent() instanceof JPopupMenu) {
                mp = (JPopupMenu)mp.getInvoker().getParent();
            }
        }
        return mp;
    }
}

