/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.builder;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class IconCache {
    public static final String ICON_PREFIX = "icons/";
    public static final String ICON_SUFFIX1 = ".png";
    public static final String ICON_SUFFIX2 = ".gif";
    public static final String ICON_MODIFIER_NORMAL = "";
    public static final String ICON_MODIFIER_DISABLED = "Disabled";
    public static final String ICON_MODIFIER_PRESSED = "Pressed";
    public static final String ICON_MODIFIER_SELECTED = "Selected";
    public static final String ICON_MODIFIER_DISABLED_SELECTED = "DisabledSelected";
    public static final String ICON_MODIFIER_ROLLOVER = "Rollover";
    public static final String ICON_MODIFIER_ROLLOVER_SELECTED = "RolloverSelected";
    public static final String ICON_MODIFIER_SMALL = "Small";
    private Map<String, ImageIcon> mIconCache = new HashMap<String, ImageIcon>();

    public ImageIcon getIcon(String pName, String pIconModifier) {
        if (pName == null) {
            return null;
        }
        StringBuilder buf1 = new StringBuilder("/");
        StringBuilder buf2 = new StringBuilder("/");
        buf1.append(ICON_PREFIX);
        buf2.append(ICON_PREFIX);
        buf1.append(pName);
        buf2.append(pName);
        buf1.append(pIconModifier);
        buf2.append(pIconModifier);
        buf1.append(ICON_SUFFIX1);
        buf2.append(ICON_SUFFIX2);
        String name1 = buf1.toString();
        String name2 = buf2.toString();
        if (this.mIconCache.containsKey(name1)) {
            return this.mIconCache.get(name1);
        }
        if (this.mIconCache.containsKey(name2)) {
            return this.mIconCache.get(name2);
        }
        ImageIcon imageIcon = null;
        try {
            URL url = this.getClass().getResource(name1);
            imageIcon = new ImageIcon(url);
            imageIcon.getImage();
            this.mIconCache.put(name1, imageIcon);
        }
        catch (Exception ignored1) {
            try {
                URL url = this.getClass().getResource(name2);
                imageIcon = new ImageIcon(url);
                imageIcon.getImage();
                this.mIconCache.put(name2, imageIcon);
            }
            catch (Exception ignored2) {
                this.mIconCache.put(name1, null);
                this.mIconCache.put(name2, imageIcon);
            }
        }
        return imageIcon;
    }
}

