/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state.ui;

import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import net.sf.cuf.state.ui.AbstractSwingState;

public class SwingTreeSelectionState
extends AbstractSwingState
implements TreeSelectionListener {
    private TreeSelectionModel mTreeSelectionModel;
    private TreePath mTreePath;

    public SwingTreeSelectionState(JTree pTree) {
        this(pTree, null);
    }

    public SwingTreeSelectionState(JTree pTree, TreePath pTreePath) {
        if (pTree == null) {
            throw new IllegalArgumentException("JTree must not be null");
        }
        this.init(pTree.getSelectionModel(), pTreePath);
    }

    public SwingTreeSelectionState(TreeSelectionModel pSelectionModel, TreePath pTreePath) {
        this.init(pSelectionModel, pTreePath);
    }

    private void init(TreeSelectionModel pSelectionModel, TreePath pTreePath) {
        if (pSelectionModel == null) {
            throw new IllegalArgumentException("tree selection model must not be null");
        }
        this.mTreePath = pTreePath;
        this.mTreeSelectionModel = pSelectionModel;
        this.mIsEnabled = this.getInternalState();
        this.mTreeSelectionModel.addTreeSelectionListener(this);
    }

    public void setCompareContent(TreePath pTreePath) {
        this.mTreePath = pTreePath;
        this.checkStateChange();
    }

    @Override
    public void valueChanged(TreeSelectionEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    protected boolean getInternalState() {
        if (this.mTreePath == null && this.mTreeSelectionModel.isSelectionEmpty()) {
            return true;
        }
        return this.mTreeSelectionModel.isPathSelected(this.mTreePath);
    }

    @Override
    protected void setReason() {
        this.mReason = this.mTreeSelectionModel;
    }
}

