/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.sf.cuf.state.State;

public class AbstractState
implements State {
    protected String mName = "";
    protected boolean mIsInitialized = false;
    protected boolean mIsEnabled = false;
    private boolean mIsDisposed = false;
    protected EventListenerList mListenerList = new EventListenerList();
    protected Object mReason = null;
    private ChangeEvent mChangeEvent;

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String pName) {
        this.checkDisposed();
        if (pName == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.mName = pName;
    }

    @Override
    public boolean isInitialized() {
        this.checkDisposed();
        return this.mIsInitialized;
    }

    @Override
    public boolean isEnabled() {
        this.checkDisposed();
        return this.mIsEnabled;
    }

    @Override
    public Object getChangeReason() {
        this.checkDisposed();
        return this.mReason;
    }

    protected void fireStateChanged() {
        this.checkDisposed();
        Object[] listeners = this.mListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.mChangeEvent == null) {
                this.mChangeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.mChangeEvent);
        }
    }

    @Override
    public void addChangeListener(ChangeListener pStateChangeListener) {
        this.checkDisposed();
        this.mListenerList.add(ChangeListener.class, pStateChangeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener pStateChangeListener) {
        this.checkDisposed();
        this.mListenerList.remove(ChangeListener.class, pStateChangeListener);
    }

    @Override
    public void dispose() {
        this.mIsDisposed = true;
        this.mListenerList = new EventListenerList();
    }

    @Override
    public boolean isDisposed() {
        return this.mIsDisposed;
    }

    protected void checkDisposed() throws IllegalStateException {
        if (this.mIsDisposed) {
            throw new IllegalStateException("state " + this.mName + " was already disposed");
        }
    }

    @Override
    public List<ChangeListener> getDependents() {
        this.checkDisposed();
        Object[] ll = this.mListenerList.getListenerList();
        ArrayList<ChangeListener> dependents = new ArrayList<ChangeListener>(this.mListenerList.getListenerCount());
        for (int i = 0; i < ll.length; i += 2) {
            if (ll[i] != ChangeListener.class) continue;
            ChangeListener dependent = (ChangeListener)ll[i + 1];
            dependents.add(dependent);
        }
        return Collections.unmodifiableList(dependents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[name= ");
        sb.append(this.mName);
        sb.append(", isInitialized= ");
        sb.append(this.mIsInitialized);
        sb.append(", isEnabled= ");
        sb.append(this.mIsEnabled);
        sb.append(", reason= ");
        sb.append(this.mReason);
        sb.append(']');
        return sb.toString();
    }
}

