/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import net.sf.cuf.model.ValueModel;

public class LOVAdapter
implements ListSelectionModel,
ComboBoxModel,
ActionListener {
    private List<?> mDisplayedItems;
    private ValueModel<List<?>> mDisplayedItemsVM;
    private List<?> mKeys;
    private ValueModel<List<?>> mKeysVM;
    private ValueModel<?> mSelectedKeyVM;
    private Object mUnselectedKey;
    private boolean mInSelectionChange;
    private EventListenerList mListenerList;
    private ListSelectionModel mListSelectionModel;
    private ButtonGroup mButtonGroup;
    private int mIndex;

    public LOVAdapter(JComboBox pComboBox, ValueModel<List<?>> pDisplayedItemsVM, ValueModel<List<?>> pKeysVM, ValueModel<?> pSelectedKeyVM) {
        this(pComboBox, pDisplayedItemsVM, pKeysVM, pSelectedKeyVM, null);
    }

    public LOVAdapter(JComboBox pComboBox, ValueModel<List<?>> pDisplayedItemsVM, ValueModel<List<?>> pKeysVM, ValueModel<?> pSelectedKeyVM, Object pUnselectedKey) {
        if (pComboBox == null) {
            throw new IllegalArgumentException("ComboBox must not be null");
        }
        if (pDisplayedItemsVM == null) {
            throw new IllegalArgumentException("DisplayedItemsVM must not be null");
        }
        if (pKeysVM == null) {
            throw new IllegalArgumentException("KeysVM must not be null");
        }
        if (pSelectedKeyVM == null) {
            throw new IllegalArgumentException("SelectedKeyVM must not be null");
        }
        List<?> displayedItems = this.getDisplayedList(pDisplayedItemsVM);
        List<?> keys = this.getKeysList(pKeysVM);
        DefaultListSelectionModel listSelectionModel = new DefaultListSelectionModel();
        this.init(displayedItems, pDisplayedItemsVM, keys, pKeysVM, pSelectedKeyVM, pUnselectedKey, listSelectionModel, null);
        pComboBox.setModel(this);
        this.vmSelectedKeyChanged(null);
    }

    public LOVAdapter(JComboBox pComboBox, List<?> pDisplayedItems, List<?> pKeys, ValueModel<?> pSelectedKeyVM) {
        this(pComboBox, pDisplayedItems, pKeys, pSelectedKeyVM, null);
    }

    public LOVAdapter(JComboBox pComboBox, List<?> pDisplayedItems, List<?> pKeys, ValueModel<?> pSelectedKeyVM, Object pUnselectedKey) {
        if (pDisplayedItems == null) {
            throw new IllegalArgumentException("DisplayedItems must not be null");
        }
        if (pKeys == null) {
            throw new IllegalArgumentException("Keys must not be null");
        }
        if (pSelectedKeyVM == null) {
            throw new IllegalArgumentException("SelectedKeyVM must not be null");
        }
        DefaultListSelectionModel listSelectionModel = new DefaultListSelectionModel();
        this.init(pDisplayedItems, null, pKeys, null, pSelectedKeyVM, pUnselectedKey, listSelectionModel, null);
        pComboBox.setModel(this);
        this.vmSelectedKeyChanged(null);
    }

    public LOVAdapter(JList pList, ValueModel<List<?>> pDisplayedItemsVM, ValueModel<List<?>> pKeysVM, ValueModel<?> pSelectedKeyVM) {
        this(pList, pDisplayedItemsVM, pKeysVM, pSelectedKeyVM, null);
    }

    public LOVAdapter(JList pList, ValueModel<List<?>> pDisplayedItemsVM, ValueModel<List<?>> pKeysVM, ValueModel<?> pSelectedKeyVM, Object pUnselectedKey) {
        if (pList == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        if (pDisplayedItemsVM == null) {
            throw new IllegalArgumentException("DisplayedItemsVM must not be null");
        }
        if (pKeysVM == null) {
            throw new IllegalArgumentException("KeysVM must not be null");
        }
        if (pSelectedKeyVM == null) {
            throw new IllegalArgumentException("SelectedKeyVM must not be null");
        }
        List<?> displayedItems = this.getDisplayedList(pDisplayedItemsVM);
        List<?> keys = this.getKeysList(pKeysVM);
        ListSelectionModel listSelectionModel = pList.getSelectionModel();
        if (listSelectionModel == null) {
            listSelectionModel = new DefaultListSelectionModel();
        }
        listSelectionModel.setSelectionMode(0);
        this.init(displayedItems, pDisplayedItemsVM, keys, pKeysVM, pSelectedKeyVM, pUnselectedKey, listSelectionModel, null);
        pList.setModel(this);
        pList.setSelectionModel(this);
        this.vmSelectedKeyChanged(null);
    }

    public LOVAdapter(JList pList, List<?> pDisplayedItems, List<?> pKeys, ValueModel<?> pSelectedKeyVM) {
        this(pList, pDisplayedItems, pKeys, pSelectedKeyVM, null);
    }

    public LOVAdapter(JList pList, List<?> pDisplayedItems, List<?> pKeys, ValueModel<?> pSelectedKeyVM, Object pUnselectedKey) {
        if (pDisplayedItems == null) {
            throw new IllegalArgumentException("DisplayedItems must not be null");
        }
        if (pKeys == null) {
            throw new IllegalArgumentException("Keys must not be null");
        }
        if (pSelectedKeyVM == null) {
            throw new IllegalArgumentException("SelectedKeyVM must not be null");
        }
        ListSelectionModel listSelectionModel = pList.getSelectionModel();
        if (listSelectionModel == null) {
            listSelectionModel = new DefaultListSelectionModel();
        }
        this.init(pDisplayedItems, null, pKeys, null, pSelectedKeyVM, pUnselectedKey, listSelectionModel, null);
        pList.setModel(this);
        pList.setSelectionModel(this);
        this.vmSelectedKeyChanged(null);
    }

    public LOVAdapter(ButtonGroup pButtonGroup, ValueModel<List<?>> pDisplayedItemsVM, ValueModel<List<?>> pKeysVM, ValueModel<?> pSelectedKeyVM, Object pUnselectedKey) {
        if (pButtonGroup == null) {
            throw new IllegalArgumentException("ButtonGroup must not be null");
        }
        if (pDisplayedItemsVM == null) {
            throw new IllegalArgumentException("DisplayedItemsVM must not be null");
        }
        if (pKeysVM == null) {
            throw new IllegalArgumentException("KeysVM must not be null");
        }
        if (pSelectedKeyVM == null) {
            throw new IllegalArgumentException("SelectedKeyVM must not be null");
        }
        List<?> displayedItems = this.getDisplayedList(pDisplayedItemsVM);
        List<?> keys = this.getKeysList(pKeysVM);
        this.initButtonGroup(pButtonGroup, displayedItems, pDisplayedItemsVM, keys, pKeysVM, pSelectedKeyVM, pUnselectedKey);
    }

    public LOVAdapter(ButtonGroup pButtonGroup, List<?> pDisplayedItems, List<?> pKeys, ValueModel<?> pSelectedKeyVM, Object pUnselectedKey) {
        if (pButtonGroup == null) {
            throw new IllegalArgumentException("ButtonGroup must not be null");
        }
        if (pDisplayedItems == null) {
            throw new IllegalArgumentException("DisplayedItems must not be null");
        }
        if (pKeys == null) {
            throw new IllegalArgumentException("Keys must not be null");
        }
        if (pSelectedKeyVM == null) {
            throw new IllegalArgumentException("SelectedKeyVM must not be null");
        }
        this.initButtonGroup(pButtonGroup, pDisplayedItems, null, pKeys, null, pSelectedKeyVM, pUnselectedKey);
    }

    private void initButtonGroup(ButtonGroup pButtonGroup, List<?> pDisplayedItems, ValueModel<List<?>> pDisplayedItemsVM, List<?> pKeys, ValueModel<List<?>> pKeysVM, ValueModel<?> pSelectedKeyVM, Object pUnselectedKey) {
        DefaultListSelectionModel listSelectionModel = new DefaultListSelectionModel();
        this.init(pDisplayedItems, pDisplayedItemsVM, pKeys, pKeysVM, pSelectedKeyVM, pUnselectedKey, listSelectionModel, pButtonGroup);
        Enumeration<AbstractButton> e = pButtonGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            button.addActionListener(this);
        }
        this.vmSelectedKeyChanged(null);
    }

    private List<?> getDisplayedList(ValueModel<List<?>> pValueModel) {
        List<?> list = pValueModel.getValue();
        return list == null ? Collections.emptyList() : list;
    }

    private List<?> getKeysList(ValueModel<List<?>> pValueModel) {
        List<?> list = pValueModel.getValue();
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    private void init(List<?> pDisplayedItems, ValueModel<List<?>> pDisplayedItemsVM, List<?> pKeys, ValueModel<List<?>> pKeysVM, ValueModel<?> pSelectedKeyVM, Object pUnselectedKey, ListSelectionModel pListSelectionModel, ButtonGroup pButtonGroup) {
        this.mDisplayedItems = pDisplayedItems;
        this.mDisplayedItemsVM = pDisplayedItemsVM;
        this.mKeys = pKeys;
        this.mKeysVM = pKeysVM;
        this.mSelectedKeyVM = pSelectedKeyVM;
        this.mUnselectedKey = pUnselectedKey;
        this.mInSelectionChange = false;
        this.mListenerList = new EventListenerList();
        this.mListSelectionModel = pListSelectionModel;
        this.mListSelectionModel.setSelectionMode(0);
        this.mButtonGroup = pButtonGroup;
        this.mIndex = -1;
        if (this.mDisplayedItemsVM != null) {
            this.mDisplayedItemsVM.onChangeSend(this, "vmItemsChanged");
            this.mKeysVM.onChangeSend(this, "vmKeysChanged");
        }
        this.mSelectedKeyVM.onChangeSend(this, "vmSelectedKeyChanged");
    }

    protected void fireListChanged(ListDataEvent pListDataEvent) {
        Object[] listeners = this.mListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            ((ListDataListener)listeners[i + 1]).contentsChanged(pListDataEvent);
        }
    }

    public int getSelectedIndex() {
        return this.mIndex;
    }

    public int getIndexByKey(Object pKey) {
        int n = this.mKeys.size();
        for (int i = 0; i < n; ++i) {
            Object key = this.mKeys.get(i);
            if (key == null && pKey == null) {
                return i;
            }
            if (key == null || !key.equals(pKey)) continue;
            return i;
        }
        return -1;
    }

    public void vmItemsChanged(ChangeEvent pEvent) {
        if (this.mInSelectionChange) {
            return;
        }
        int index = this.mIndex;
        this.mDisplayedItems = this.getDisplayedList(this.mDisplayedItemsVM);
        if (index < 0 || index >= this.mDisplayedItems.size()) {
            index = -1;
        }
        this.propagateChange(index);
        this.handleListSelection();
    }

    public void vmSelectedKeyChanged(ChangeEvent pEvent) {
        if (this.mInSelectionChange) {
            return;
        }
        this.mIndex = this.getIndexByKey(this.mSelectedKeyVM.getValue());
        this.propagateChange(this.mIndex);
    }

    public void vmKeysChanged(ChangeEvent pEvent) {
        if (this.mInSelectionChange) {
            return;
        }
        this.mKeys = this.getKeysList(this.mKeysVM);
        this.mIndex = this.getIndexByKey(this.mSelectedKeyVM.getValue());
        if (this.mDisplayedItemsVM == this.mKeysVM) {
            this.vmItemsChanged(pEvent);
        } else {
            this.propagateChange(this.mIndex);
            this.handleListSelection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateChange(int pIndex) {
        this.mInSelectionChange = true;
        try {
            if (pIndex == -1) {
                this.mListSelectionModel.clearSelection();
            } else {
                this.mListSelectionModel.setSelectionInterval(pIndex, pIndex);
            }
            ListDataEvent e = new ListDataEvent(this, 0, pIndex, pIndex);
            this.fireListChanged(e);
            if (this.mButtonGroup != null) {
                Enumeration<AbstractButton> elements = this.mButtonGroup.getElements();
                if (pIndex == -1) {
                    for (int i = 0; i < this.mButtonGroup.getButtonCount(); ++i) {
                        AbstractButton button = elements.nextElement();
                        button.setSelected(false);
                    }
                } else {
                    while (pIndex-- > 0) {
                        elements.nextElement();
                    }
                    AbstractButton toBeSelected = elements.nextElement();
                    toBeSelected.setSelected(true);
                }
            }
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    @Override
    public void setSelectionInterval(int pIndex0, int pIndex1) {
        this.mListSelectionModel.setSelectionInterval(pIndex0, pIndex1);
        this.handleListSelection();
    }

    @Override
    public void addSelectionInterval(int pIndex0, int pIndex1) {
        this.mListSelectionModel.addSelectionInterval(pIndex0, pIndex1);
        this.handleListSelection();
    }

    @Override
    public void removeSelectionInterval(int pIndex0, int pIndex1) {
        this.mListSelectionModel.removeSelectionInterval(pIndex0, pIndex1);
        this.handleListSelection();
    }

    @Override
    public void insertIndexInterval(int pIndex, int pLength, boolean pBefore) {
        this.mListSelectionModel.insertIndexInterval(pIndex, pLength, pBefore);
        this.handleListSelection();
    }

    @Override
    public void removeIndexInterval(int pIndex0, int pIndex1) {
        this.mListSelectionModel.removeIndexInterval(pIndex0, pIndex1);
        this.handleListSelection();
    }

    @Override
    public void clearSelection() {
        this.mListSelectionModel.clearSelection();
        this.handleListSelection();
    }

    @Override
    public int getMinSelectionIndex() {
        return this.mListSelectionModel.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.mListSelectionModel.getMaxSelectionIndex();
    }

    @Override
    public boolean isSelectedIndex(int pIndex) {
        if (pIndex == -1) {
            return false;
        }
        return this.mListSelectionModel.isSelectedIndex(pIndex);
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.mListSelectionModel.getAnchorSelectionIndex();
    }

    @Override
    public void setAnchorSelectionIndex(int pIndex) {
        this.mListSelectionModel.setAnchorSelectionIndex(pIndex);
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.mListSelectionModel.getLeadSelectionIndex();
    }

    @Override
    public void setLeadSelectionIndex(int pIndex) {
        this.mListSelectionModel.setLeadSelectionIndex(pIndex);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.mListSelectionModel.isSelectionEmpty();
    }

    @Override
    public void setValueIsAdjusting(boolean pValueIsAdjusting) {
        this.mListSelectionModel.setValueIsAdjusting(pValueIsAdjusting);
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.mListSelectionModel.getValueIsAdjusting();
    }

    @Override
    public void setSelectionMode(int pSelectionMode) {
        if (pSelectionMode != 0) {
            throw new IllegalArgumentException("this selection model only supports single selection");
        }
        this.mListSelectionModel.setSelectionMode(pSelectionMode);
    }

    @Override
    public int getSelectionMode() {
        return this.mListSelectionModel.getSelectionMode();
    }

    @Override
    public void addListSelectionListener(ListSelectionListener pListener) {
        this.mListSelectionModel.addListSelectionListener(pListener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener pListener) {
        this.mListSelectionModel.removeListSelectionListener(pListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListSelection() {
        if (this.mInSelectionChange) {
            return;
        }
        this.mInSelectionChange = true;
        try {
            this.mIndex = this.mListSelectionModel.getMinSelectionIndex();
            Object selectedKey = this.mIndex >= 0 && this.mIndex < this.mKeys.size() ? this.mKeys.get(this.mIndex) : this.mUnselectedKey;
            this.mSelectedKeyVM.setObjectValue(selectedKey);
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.getElementAt(this.mIndex);
    }

    @Override
    public void setSelectedItem(Object pItem) {
        int index = -1;
        int n = this.mDisplayedItems.size();
        for (int i = 0; i < n; ++i) {
            Object item = this.mDisplayedItems.get(i);
            if (pItem != item && (pItem == null || !pItem.equals(item))) continue;
            index = i;
            break;
        }
        this.setSelectionInterval(index, index);
    }

    @Override
    public int getSize() {
        return this.mDisplayedItems.size();
    }

    @Override
    public Object getElementAt(int pIndex) {
        if (pIndex < 0 || pIndex >= this.mDisplayedItems.size()) {
            return null;
        }
        return this.mDisplayedItems.get(pIndex);
    }

    @Override
    public void addListDataListener(ListDataListener pListDataListener) {
        this.mListenerList.add(ListDataListener.class, pListDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener pListDataListener) {
        this.mListenerList.remove(ListDataListener.class, pListDataListener);
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        ButtonModel selectedModel = this.mButtonGroup.getSelection();
        Enumeration<AbstractButton> e = this.mButtonGroup.getElements();
        int index = -1;
        for (int i = 0; i < this.mButtonGroup.getButtonCount(); ++i) {
            AbstractButton button = e.nextElement();
            if (button.getModel() != selectedModel) continue;
            index = i;
            break;
        }
        if (index == -1) {
            this.mListSelectionModel.clearSelection();
        } else {
            this.mListSelectionModel.setSelectionInterval(index, index);
        }
        this.handleListSelection();
    }
}

