/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.converter;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.AbstractValueModel;
import net.sf.cuf.model.DelegateAccess;
import net.sf.cuf.model.ValueHolder;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.model.converter.ConversionException;
import net.sf.cuf.model.converter.TypeConverter;

public abstract class AbstractTypeConverter<OwnT, SubjectT>
extends AbstractValueModel<OwnT>
implements TypeConverter<OwnT, SubjectT>,
ChangeListener,
DelegateAccess {
    private ValueModel<SubjectT> mSubject;
    private ValueHolder<Boolean> mInSync;
    private Object mSyncKey;
    private String mSyncMessage;
    private boolean mPropagateFailedConversions;

    protected AbstractTypeConverter(ValueModel<SubjectT> pSubject) {
        this(pSubject, true);
    }

    protected AbstractTypeConverter(ValueModel<SubjectT> pSubject, boolean pPropagateFailedConversions) {
        if (pSubject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        this.mSubject = pSubject;
        this.mPropagateFailedConversions = pPropagateFailedConversions;
        this.setInSetValue(false, false);
        this.mInSync = new ValueHolder<Boolean>(Boolean.TRUE);
        this.mSubject.addChangeListener(this);
    }

    public void setPropagateFailedConversions(boolean pPropagateFailedConversions) {
        this.mPropagateFailedConversions = pPropagateFailedConversions;
    }

    public boolean getPropagateFailedConversions() {
        return this.mPropagateFailedConversions;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public ValueModel<SubjectT> getSubject() {
        return this.mSubject;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (!this.mSubject.isDisposed()) {
            this.mSubject.removeChangeListener(this);
        }
        this.mInSync.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(OwnT pValue, boolean pIsSetForced) {
        this.checkDisposed();
        this.setInSetValue(true, pIsSetForced);
        try {
            Object convertedValue;
            try {
                convertedValue = this.convertOwnToSubjectValue(pValue);
                this.mInSync.setValue(Boolean.TRUE);
            }
            catch (ConversionException ex) {
                this.mInSync.setValue(Boolean.FALSE);
                if (ex.hasConversionValue()) {
                    convertedValue = ex.getConversionValue();
                }
                if (this.mPropagateFailedConversions) {
                    IllegalStateException ise = new IllegalStateException(ex.getMessage());
                    ise.initCause(ex.getCause());
                    throw ise;
                }
                this.setInSetValue(false, false);
                return;
            }
            this.mSubject.setValue(convertedValue);
            this.fireStateChanged();
        }
        finally {
            this.setInSetValue(false, false);
        }
    }

    @Override
    public OwnT getValue() {
        SubjectT subjectValue = this.mSubject.getValue();
        return this.getValue(subjectValue, this.mInSync);
    }

    @Override
    public Object getValue(Object pValue) {
        this.checkDisposed();
        Object value = pValue;
        if (this.mSubject instanceof DelegateAccess) {
            value = ((DelegateAccess)((Object)this.mSubject)).getValue(pValue);
        }
        return this.getValue(value, null);
    }

    private OwnT getValue(SubjectT pSubjectValue, ValueModel<Boolean> pInSync) {
        Object convertedValue;
        try {
            convertedValue = this.convertSubjectToOwnValue(pSubjectValue);
            if (pInSync != null) {
                pInSync.setValue(Boolean.TRUE);
            }
        }
        catch (ConversionException ex) {
            if (pInSync != null) {
                pInSync.setValue(Boolean.FALSE);
            }
            if (ex.hasConversionValue()) {
                convertedValue = ex.getConversionValue();
            }
            if (this.mPropagateFailedConversions) {
                IllegalStateException ise = new IllegalStateException(ex.getMessage());
                ise.initCause(ex.getCause());
                throw ise;
            }
            return null;
        }
        return convertedValue;
    }

    protected Object getSubjectValue() {
        this.checkDisposed();
        return this.mSubject.getValue();
    }

    @Override
    public ValueModel<Boolean> getSyncState() {
        this.checkDisposed();
        return this.mInSync;
    }

    @Override
    public Object getSyncKey() {
        return this.mSyncKey;
    }

    @Override
    public void setSyncKey(Object pKey) {
        this.mSyncKey = pKey;
    }

    @Override
    public String getSyncMessage() {
        if (this.mSyncMessage == null) {
            return "Umwandlung fehlgeschlagen";
        }
        return this.mSyncMessage;
    }

    @Override
    public void setSyncMessage(String pMessage) {
        if (pMessage == null) {
            throw new IllegalArgumentException("Sync message must not be null");
        }
        this.mSyncMessage = pMessage;
    }

    @Override
    public void stateChanged(ChangeEvent pEvent) {
        block3: {
            this.checkDisposed();
            if (this.isInSetValue()) {
                return;
            }
            try {
                this.convertSubjectToOwnValue(this.mSubject.getValue());
            }
            catch (ConversionException ex) {
                this.mInSync.setValue(Boolean.FALSE);
                if (ex.hasConversionValue() || this.mPropagateFailedConversions) break block3;
                return;
            }
        }
        this.fireStateChanged();
    }
}

