/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model;

import java.util.Properties;
import net.sf.cuf.model.AbstractValueModel;
import net.sf.cuf.model.ValueModel;

public class PropertiesAdapter
extends AbstractValueModel<Object>
implements ValueModel<Object> {
    private Properties mProperties;
    private String mKey;
    private String mDefaultValue;

    public PropertiesAdapter(Properties pProperties, String pKey, String pDefaultValue) {
        if (pProperties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        if (pKey == null) {
            throw new IllegalArgumentException("properties key must not be null");
        }
        this.mProperties = pProperties;
        this.mKey = pKey;
        this.mDefaultValue = pDefaultValue;
        this.setInSetValue(false, false);
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object pValue, boolean pIsSetForced) {
        String oldValue;
        this.checkDisposed();
        if (!pIsSetForced && ((oldValue = this.mProperties.getProperty(this.mKey)) == null && pValue == null || (oldValue != null ? oldValue.equals(pValue) : pValue.equals(oldValue)))) {
            return;
        }
        this.setInSetValue(true, pIsSetForced);
        try {
            this.mProperties.setProperty(this.mKey, pValue == null ? null : pValue.toString());
            this.fireStateChanged();
        }
        finally {
            this.setInSetValue(false, false);
        }
    }

    @Override
    public String getValue() {
        this.checkDisposed();
        return this.mProperties.getProperty(this.mKey, this.mDefaultValue);
    }
}

