/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model;

import java.util.Map;
import java.util.StringTokenizer;
import net.sf.cuf.model.AspectAccessAdapter;

public class MapAccessAdapter
implements AspectAccessAdapter {
    private String[] mKeys;

    public MapAccessAdapter(String pAspectName) {
        StringTokenizer st = new StringTokenizer(pAspectName, ".");
        this.mKeys = new String[st.countTokens()];
        for (int i = 0; i < this.mKeys.length; ++i) {
            this.mKeys[i] = st.nextToken();
        }
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public Object getValue(Object pSource) {
        if (pSource == null) {
            return null;
        }
        Object aspect = pSource;
        for (String mKey : this.mKeys) {
            Map source = (Map)aspect;
            String key = mKey;
            aspect = source.get(key);
        }
        return aspect;
    }

    @Override
    public void setValue(Object pSource, Object pValue) {
        Object aspect = pSource;
        Map source = (Map)aspect;
        for (String mKey : this.mKeys) {
            source = (Map)aspect;
            String key = mKey;
            aspect = source.get(key);
        }
        source.put(this.mKeys[this.mKeys.length - 1], pValue);
    }
}

