package net.sf.cuf.csvview.browse;

import net.sf.cuf.csvview.util.FilteredTableModel;
import net.sf.cuf.csvview.util.TreeTableModel;
import net.sf.cuf.xfer.AbstractRequest;
import net.sf.cuf.xfer.DefaultResponse;
import net.sf.cuf.xfer.Response;

import java.io.File;

/**
 * A LoadTreeRequest creates a FilteredTableModel.
 */
public class LoadTreeRequest extends AbstractRequest implements LoadDataRequest
{
    /** the file node we start from */
    private File  mFile;

    /**
     * Creates a new LoadTreeRequest, the tree is loaded in execute().
     * @param pFileName the file name we should start from, must not be null
     * @throws IllegalArgumentException if pFileName is null
     */
    public LoadTreeRequest(final String pFileName)
    {
        super();
        if (pFileName==null)
        {
            throw new IllegalArgumentException("file name must not be null");
        }
        mFile= new File(pFileName);
    }

    /**
     * Creates a new LoadTreeRequest, the tree is loaded in execute().
     * @param pFile the file we should start from, must not be null
     * @throws IllegalArgumentException if pFile is null
     */
    public LoadTreeRequest(final File pFile)
    {
        super();
        if (pFile==null)
        {
            throw new IllegalArgumentException("file must not be null");
        }
        mFile= pFile;
    }

    /**
     * Generate a TreeTableModel with the file given in the constructor.
     * @return a DefaultResponse with a FilteredTableModel as its result if
     *         everything worked, or an Exception as its error if we got problems
     */
    public Response execute()
    {
        DefaultResponse response= new DefaultResponse();
        try
        {
            FilteredTableModel model= new TreeTableModel(mFile);
            response.setResult(model);
        }
        catch (Exception e)
        {
            response.setError(e);
        }

        return response;
    }
}
