/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.table.TableCellRenderer;
import net.sf.cuf.ui.table.TableHeaderIcon;

public class TableHeaderRenderer
extends JPanel
implements TableCellRenderer {
    public static final int ASCENDING = 1;
    public static final int NONE = 0;
    public static final int DESCENDING = -1;
    private JLabel mLabelCaption = new JLabel();
    private JPanel mPanelButtons = new JPanel();
    private JButton mButtonSortAscending = new JButton(TableHeaderIcon.getIconSortAscending());
    private JButton mButtonSortDescending = new JButton(TableHeaderIcon.getIconSortDescending());
    private int mDirection = 0;
    private boolean mInitialized = false;

    public TableHeaderRenderer() {
        this.initialize();
    }

    public void setDirection(int pDirection) {
        if (pDirection != 1 && pDirection != 0 && pDirection != -1) {
            throw new IllegalArgumentException("invalid value for pDirection");
        }
        this.mDirection = pDirection;
    }

    public int hitButton(int pX, int pY) {
        Component component = this.mPanelButtons.findComponentAt(pX - this.mPanelButtons.getX(), pY - this.mPanelButtons.getY());
        if (component != null && component.equals(this.mButtonSortAscending)) {
            return 1;
        }
        if (component != null && component.equals(this.mButtonSortDescending)) {
            return -1;
        }
        return 0;
    }

    @Override
    public Component getTableCellRendererComponent(JTable pTable, Object pValue, boolean pIsSelected, boolean pHasFocus, int pRow, int pCol) {
        this.mLabelCaption.setText(' ' + pValue.toString());
        boolean ascending = this.mDirection == 1;
        boolean descending = this.mDirection == -1;
        this.mLabelCaption.setHorizontalAlignment(2);
        this.mPanelButtons.setVisible(true);
        this.mButtonSortAscending.setVisible(true);
        this.mButtonSortAscending.getModel().setArmed(ascending);
        this.mButtonSortAscending.getModel().setPressed(ascending);
        this.mButtonSortDescending.setVisible(true);
        this.mButtonSortDescending.getModel().setArmed(descending);
        this.mButtonSortDescending.getModel().setPressed(descending);
        return this;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.mInitialized) {
            this.mLabelCaption.updateUI();
            this.mPanelButtons.updateUI();
        }
    }

    private void initialize() {
        this.setBorder(new BevelBorder(0));
        this.setLayout(new BorderLayout());
        this.mPanelButtons.setLayout(new BoxLayout(this.mPanelButtons, 0));
        this.mPanelButtons.add(this.mButtonSortAscending);
        this.mPanelButtons.add(this.mButtonSortDescending);
        this.mButtonSortAscending.setBorder(null);
        this.mButtonSortAscending.setBorderPainted(false);
        this.mButtonSortAscending.setContentAreaFilled(false);
        this.mButtonSortAscending.setMargin(new Insets(2, 0, 2, 0));
        this.mButtonSortDescending.setBorder(null);
        this.mButtonSortDescending.setBorderPainted(false);
        this.mButtonSortDescending.setContentAreaFilled(false);
        this.mButtonSortDescending.setMargin(new Insets(2, 0, 2, 0));
        this.add((Component)this.mLabelCaption, "Center");
        this.add((Component)this.mPanelButtons, "East");
        this.mInitialized = true;
    }
}

