/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.sf.cuf.ui.SwingDecorator;

public abstract class BasicDialog
extends JDialog {
    protected String mKennung;
    protected JButton mButtonOK;
    protected JButton mButtonCancel;
    private boolean mPositioned = false;

    public BasicDialog(Frame pOwner, String pKennung) {
        super(pOwner, true);
        if (pOwner == null) {
            throw new IllegalArgumentException("owner must not be null");
        }
        if (pKennung == null || pKennung.length() == 0) {
            throw new IllegalArgumentException("kennung must not be null or empty");
        }
        this.mKennung = pKennung;
        SwingDecorator.initialize(this, pKennung);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent pEvent) {
                BasicDialog.this.processDialogCancel();
            }
        });
    }

    protected Container createOkCancelButtons() {
        int width;
        Box box = Box.createHorizontalBox();
        this.mButtonOK = new JButton();
        SwingDecorator.initialize(this.mButtonOK, this.mKennung + "_OK");
        this.mButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                BasicDialog.this.processDialogOk();
            }
        });
        box.add(this.mButtonOK);
        box.add(Box.createHorizontalStrut(10));
        this.mButtonCancel = new JButton();
        SwingDecorator.initialize(this.mButtonCancel, this.mKennung + "_CANCEL");
        this.mButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                BasicDialog.this.processDialogCancel();
            }
        });
        box.add(this.mButtonCancel);
        Dimension d1 = this.mButtonOK.getPreferredSize();
        Dimension d2 = this.mButtonCancel.getPreferredSize();
        d1.width = width = Math.max(d1.width, d2.width);
        d2.width = width;
        this.mButtonOK.setPreferredSize(d1);
        this.mButtonOK.setMinimumSize(d1);
        this.mButtonOK.setMaximumSize(d1);
        this.mButtonCancel.setPreferredSize(d2);
        this.mButtonCancel.setMinimumSize(d2);
        this.mButtonCancel.setMaximumSize(d2);
        this.mButtonOK.setDefaultCapable(true);
        this.mButtonCancel.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.mButtonOK);
        this.mButtonCancel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent pEvent) {
                BasicDialog.this.getRootPane().setDefaultButton(BasicDialog.this.mButtonOK);
            }

            @Override
            public void focusGained(FocusEvent pEvent) {
                BasicDialog.this.getRootPane().setDefaultButton(BasicDialog.this.mButtonCancel);
            }
        });
        return box;
    }

    protected void showDialog() {
        this.pack();
        if (!this.mPositioned) {
            this.setLocationRelativeTo(this.getOwner());
            this.mPositioned = true;
        }
        super.setVisible(true);
    }

    protected abstract void processDialogOk();

    protected abstract void processDialogCancel();

    protected Object[] fetchColumnHeaders(TableModel pModel, int pOffset) {
        pOffset = Math.max(pOffset, 0);
        int columns = pModel.getColumnCount();
        Object[] header = new Object[columns + pOffset];
        for (int i = 0; i < header.length; ++i) {
            header[i] = i < pOffset ? "" : pModel.getColumnName(i - pOffset);
        }
        return header;
    }

    protected Object[] fetchVisibleColumnHeaders(TableColumnModel pColumnModel, int pOffset) {
        pOffset = Math.max(pOffset, 0);
        int columns = pColumnModel.getColumnCount();
        Object[] header = new Object[columns + pOffset];
        for (int i = 0; i < header.length; ++i) {
            header[i] = i < pOffset ? "" : pColumnModel.getColumn(i - pOffset).getHeaderValue();
        }
        return header;
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane newRootPane = super.createRootPane();
        ActionListener escapeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                BasicDialog.this.processDialogCancel();
            }
        };
        newRootPane.registerKeyboardAction(escapeListener, stroke, 2);
        return newRootPane;
    }
}

